/***************************************************************************
                            HTMLInputElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLINPUTELEMENT_H
#define HTMLINPUTELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Form control. Note. Depending upon the environment the page is
 being viewed, the value property may be read-only for the file
 upload input type. For the "password" input type, the actual value
 returned may be masked to prevent unauthorized use. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-INPUT">
 INPUT element definition </a> in HTML 4.0.

 
 @short 
 Form control.
*/
@class HTMLFormElement; 

@interface HTMLInputElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Stores the initial control value (i.e., the initial value of
 <code> value </code> ).

     
*/
- (NSString *) defaultValue;

/** 
 see @ref defaultValue
     
*/
- setDefaultValue: (NSString *)arg1;

/** 
 When <code> type </code> has the value "Radio" or "Checkbox",
 stores the initial value of the <code> checked </code>
 attribute.

     
*/
- (BOOL) defaultChecked;

/** 
 see @ref defaultChecked
     
*/
- setDefaultChecked: (BOOL)arg1;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 A comma-separated list of content types that a server
 processing this form will handle correctly. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accept">
 accept attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accept;

/** 
 see @ref accept
     
*/
- setAccept: (NSString *)arg1;

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accessKey;

/** 
 see @ref accessKey
     
*/
- setAccessKey: (NSString *)arg1;

/** 
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Alternate text for user agents not rendering the normal content
 of this element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-alt">
 alt attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) alt;

/** 
 see @ref alt
     
*/
- setAlt: (NSString *)arg1;

/** 
 Describes whether a radio or check box is checked, when <code>
 type </code> has the value "Radio" or "Checkbox". The value is
 TRUE if explicitly set. Represents the current state of the
 checkbox or radio button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-checked">
 checked attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) checked;

/** 
 see @ref checked
     
*/
- setChecked: (BOOL)arg1;

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 Maximum number of characters for text fields, when <code> type
 </code> has the value "Text" or "Password". See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-maxlength">
 maxlength attribute definition </a> in HTML 4.0.

     
*/
- (long) maxLength;

/** 
 see @ref maxLength
     
*/
- setMaxLength: (long)arg1;

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-name-INPUT">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 This control is read-only. When <code> type </code> has the
 value "text" or "password" only. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-readonly">
 readonly attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) readOnly;

/** 
 see @ref readOnly
     
*/
- setReadOnly: (BOOL)arg1;

/** 
 Size information. The precise meaning is specific to each type
 of field. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-size-INPUT">
 size attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) size;

/** 
 see @ref size
     
*/
- setSize: (NSString *)arg1;

/** 
 When the <code> type </code> attribute has the value "Image",
 this attribute specifies the location of the image to be used
 to decorate the graphical submit button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-src">
 src attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) src;

/** 
 see @ref src
     
*/
- setSrc: (NSString *)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 The type of control created. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-type-INPUT">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;

/** 
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) useMap;

/** 
 see @ref useMap
     
*/
- setUseMap: (NSString *)arg1;

/** 
 The current form control value. Used for radio buttons and
 check boxes. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-value-INPUT">
 value attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) value;

/** 
 see @ref value
     
*/
- setValue: (NSString *)arg1;

/** 
 Removes keyboard focus from this element.

     
*/
- blur;

/** 
 Gives keyboard focus to this element.

     
*/
- focus;

/** 
 Select the contents of the text area. For <code> INPUT </code>
 elements whose <code> type </code> attribute has one of the
 following values: "Text", "File", or "Password".

     
*/
- select;

/** 
 Simulate a mouse-click. For <code> INPUT </code> elements whose
 <code> type </code> attribute has one of the following values:
 "Button", "Checkbox", "Radio", "Reset", or "Submit".
     
*/
- click;
@end

#endif
