/***************************************************************************
                            KAboutDialog.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KABOUTDIALOG_H
#define KABOUTDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDialogBase.h>

/**

 A @ref KDialogBase with predefined main widget.

 As a @ref KDialogBase it uses your application wide settings
 for @ref KDialogBase
 objects (base frame tiles, main frame tiles etc).
 To use it, simply create a KAboutDialog object, set all (or some) of its
 properties and show it. Do not derive it to create your own about dialog
 until you need some cool features that are unsupported and you have
 contacted me to add them.

 The dialog can be created using two different constructors. The
 difference between these constructors is the available components that
 can be used to build the contents of the dialog. The first (Constructor I)
 provides a number of easy to use methods. Basically it allows you
 to add the components of choice, and the components are placed in a
 predefined layout. You do not have to plan the layout. Everything is
 taken care of.

 The second constructor (Constructor II) works in quite the same manner
 as the first, but you have better control on where the components
 are postioned in the layout and you have access to an extended number
 of components you can install such as titles, product information,
 a tabbed pages (where you can display rich text with url links) and
 a person (developer) information field. The "About KDE" dialog box is
 created with Constructor II.

 For the derived features, see the basic class @ref KDialogBase.

 @author Mirko Boehm (mirko@kde.org) and Espen Sand (espensa@online.no)

 @short 
 A @ref KDialogBase with predefined main widget.
*/
@class KAboutContainer; 
@class QFrame; 

@interface KAboutDialog : KDialogBase 

/** 
 The standard Qt constructor (Constructor I).

 Add components with the following methods:
  @ref -setLogo, @ref -setAuthor, @ref -setMaintainer,
   @ref -addContributor, or @ref -setVersion.
 The dialog will be laid out automatically.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- init;

/** 
 The extended constructor. (Constructor II).

 Add components with the methods:
  @ref -setTitle, @ref -setImage, @ref -setImageBackgroundColor,
  @ref -setImageFrame, @ref -setProduct, @ref -addTextPage,
  @ref -addContainerPage, @ref -addContainer, or @ref -addPage.

    
*/
- initWithInt: (int)dialogLayout caption: (NSString *)caption buttonMask: (int)buttonMask defaultButton: (int)defaultButton parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal separator: (BOOL)separator user1: (NSString *)user1 user2: (NSString *)user2 user3: (NSString *)user3;
- initWithInt: (int)dialogLayout caption: (NSString *)caption buttonMask: (int)buttonMask defaultButton: (int)defaultButton ;

/** 
 Adjusts the dialog.

 You can call this method after you have set up all
 the contents but it is not required. It is done automatically when
 @ref -show is executed.
   
*/
- adjust;

/** 
 Makes a modeless (modal = false in constructor) dialog visible.

 If you reimplement this method make sure you run it
 in the new method (e.g., @ref -show). Reimplemented
 from @ref KDialogBase.
   
*/
- show;

/** 
 Makes a modeless (modal = false in constructor) dialog visible.

 If you reimplmement this method make sure you run it
 in the new method (i.e., @ref show( parent )).

*/
- show: (QWidget *)centerParent;

/** 
 (Constructor II only)
 Sets a title (not caption) in the uppermost area of the dialog.

*/
- setTitle: (NSString *)title;

/** 
 (Constructor II only)
 Define an image to be shown in the dialog. The position is dependent
 on the @p dialogLayout in the constructor

*/
- setImage: (NSString *)fileName;

/** 
 (Constructor II only)
 The image has a minimum size, but is centered within an area if the
 dialog box is enlarged by the user. You set the background color
 of the area with this method.

*/
- setImageBackgroundColor: (QColor *)color;

/** 
 (Constructor II only)
 Enables or disables a frame around the image. The frame is, by default,
 enabled in the constructor

*/
- setImageFrame: (BOOL)state;

/** 
 (Constructor II only)
 Prints the application name, KDE version, author, a copyright sign
 and a year string. To the left of the text the standard application
 icon is displayed.

*/
- setProduct: (NSString *)appName version: (NSString *)version author: (NSString *)author year: (NSString *)year;

/** 
 (Constructor II only)
 Adds a text page to a tab box. The text can be regular text or
 rich text. The rich text can contain URLs and mail links.

*/
- (QFrame*) addTextPage: (NSString *)title text: (NSString *)text richText: (BOOL)richText numLines: (int)numLines;
- (QFrame*) addTextPage: (NSString *)title text: (NSString *)text ;

/** 
 (Constructor II only)
 Adds a license page to a tab box.

*/
- (QFrame*) addLicensePage: (NSString *)title text: (NSString *)text numLines: (int)numLines;
- (QFrame*) addLicensePage: (NSString *)title text: (NSString *)text ;

/** 
 (Constructor II only)
 Adds a container to a tab box. You can add text and images to a
 container.

*/
- (KAboutContainer*) addContainerPage: (NSString *)title childAlignment: (int)childAlignment innerAlignment: (int)innerAlignment;
- (KAboutContainer*) addContainerPage: (NSString *)title ;

/** 
 (Constructor II only)
 Adds a container inside a QScrollView to a tab box. You can add text
 and images to a container.

*/
- (KAboutContainer*) addScrolledContainerPage: (NSString *)title childAlignment: (int)childAlignment innerAlignment: (int)innerAlignment;
- (KAboutContainer*) addScrolledContainerPage: (NSString *)title ;

/** 
 (Constructor II only)
 Adds a container. You can add text and images to a container.

*/
- (KAboutContainer*) addContainer: (int)childAlignment innerAlignment: (int)innerAlignment;

/** 
 (Constructor II only)
 Adds an empty page to a tab box.

*/
- (QFrame*) addPage: (NSString *)title;

/** 
 (Constructor I only)
 Sets the image as the application logo.
   
*/
- setLogo: (QPixmap *)arg1;

/** 
 (Constructor I only)
 Sets the author's name and email address.
   
*/
- setAuthor: (NSString *)name email: (NSString *)email url: (NSString *)url work: (NSString *)work;

/** 
 (Constructor I only)
 Sets the maintainer's name and email address.
   
*/
- setMaintainer: (NSString *)name email: (NSString *)email url: (NSString *)url work: (NSString *)work;

/** 
 (Constructor I only)
 Show this person as one of the major contributors.
   
*/
- addContributor: (NSString *)name email: (NSString *)email url: (NSString *)url work: (NSString *)work;

/** 
 (Constructor I only)
 Sets the text describing the version.
   
*/
- setVersion: (NSString *)name;

/** 
 Create a modal dialog with an image in the upper area with a
 URL link below.
   
*/
+ imageURL: (QWidget *)parent caption: (NSString *)caption path: (NSString *)path imageColor: (QColor *)imageColor url: (NSString *)url;

/** 
 Connected to -[widget sendEmail].
   
*/
- sendEmailSlot: (NSString *)name email: (NSString *)email;

/** 
 Open this URL.
   
*/
- openURLSlot: (NSString *)url;

/** 
 (Constructor II only)
 Tells the position of the mouse cursor when the left mouse button
 is pressed above an image
   
*/
- mouseTrackSlot: (int)mode e: (QMouseEvent*)e;
+ (int) AbtPlain;
+ (int) AbtTabbed;
+ (int) AbtTitle;
+ (int) AbtImageLeft;
+ (int) AbtImageRight;
+ (int) AbtImageOnly;
+ (int) AbtProduct;
+ (int) AbtKDEStandard;
+ (int) AbtAppStandard;
+ (int) AbtImageAndTitle;
@end

/** Override these methods in subclasses of KAboutDialog to customise event handling behaviour */
@protocol KAboutDialogEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
