/***************************************************************************
                            KAction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KACTION_H
#define KACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 The KAction class (and derived and super classes) provides a way to
 easily encapsulate a "real" user-selected action or event in your
 program.

 For instance, a user may want to @p paste the contents of
 the clipboard or @p scroll @p down a document or @p quit the
 application.  These are all @p actions -- events that the
 user causes to happen.  The KAction class allows the developer to
 deal with these actions in an easy and intuitive manner.

 Specifically, the KAction class encapsulated the various attributes
 to an event/action.  For instance, an action might have an icon
 that goes along with it (a clipboard for a "paste" action or
 scissors for a "cut" action).  The action might have some text to
 describe the action.  It will certainly have a method or function
 that actually @p executes the action!  All these attributes
 are contained within the KAction object.

 The advantage of dealing with Actions is that you can manipulate
 the Action without regard to the GUI representation of it.  For
 instance, in the "normal" way of dealing with actions like "cut",
 you would manually insert a item for Cut into a menu and a button
 into a toolbar.  If you want to disable the cut action for a moment
 (maybe nothing is selected), you woud have to hunt down the pointer
 to the menu item and the toolbar button and disable both
 individually.  Setting the menu item and toolbar item up uses very
 similar code - but has to be done twice!

 With the Action concept, you simply "plug" the Action into whatever
 GUI element you want.  The KAction class will then take care of
 correctly defining the menu item (with icons, accelerators, text,
 etc) or toolbar button.. or whatever.  From then on, if you
 manipulate the Action at all, the effect will propogate through all
 GUI representations of it.  Back to the "cut" example: if you want
 to disable the Cut Action, you would simply do
 '-[cutAction setEnabled]' and the menuitem and button would
 instantly be disabled!

 This is the biggest advantage to the Action concept -- there is a
 one-to-one relationship between the "real" action and @p all
 GUI representations of it.

 The steps to using actions are roughly as follows

 Here is an example of enabling a "New [document]" action
 <PRE>
 KAction *newAct = new KAction(i18n("&New"), "filenew",
                               -[KStdAccel shortcut](-[KStdAccel New]),
                               this, SLOT(-fileNew),
                               -actionCollection, "new");
 </PRE>
 This line creates our action.  It says that wherever this action is
 displayed, it will use "&New" as the text, the standard icon, and
 the standard shortcut.  It further says that whenever this action
 is invoked, it will use the -fileNew slot to execute it.

 <PRE>
 QPopupMenu *file = new QPopupMenu;
 -[newAct plug];
 </PRE>
 That just inserted the action into the File menu.  The point is, it's not
 important in which menu it is: all manipulation of the item is
 done through the newAct object.

 <PRE>
 -[newAct plug](-toolBar);
 </PRE>
 And this inserted the Action into the main toolbar as a button.

 That's it!

 If you want to disable that action sometime later, you can do so
 with
 <PRE>
 -[newAct setEnabled]
 </PRE>
 and both the menuitem in File and the toolbar button will instantly
 be disabled.

 Note: if you are using a "standard" action like "new", "paste",
 "quit", or any other action described in the KDE UI Standards,
 please use the methods in the @ref KStdAction class rather then
 defining your own.

 If you are using KAction within the context of the XML menu and
 toolbar building framework, then there are a few tiny changes.  The
 first is that you must insert your new action into an action
 collection.  The action collection (a @ref KActionCollection) is,
 logically enough, a central collection of all of the actions
 defined in your application.  The XML UI framework code in KXMLGUI
 classes needs access to this collection in order to build up the
 GUI (it's how the builder code knows which actions are valid and
 which aren't).

 Also, if you use the XML builder framework, then you do not ever
 have to plug your actions into containers manually.  The framework
 does that for you.

 @short Class to encapsulate user-driven action or event.
*/
@class KAccel; 
@class KActionCollection; 
@class KToolBar; 
@class QIconSet; 
@class QPixmap; 
@class QPopupMenu; 
@class QKeySequence;
@class KGuiItem;
@class KShortcut; 

@interface KAction : QObject 

/** 
 Constructs an action with text, potential keyboard
 shortcut, and a SLOT to call when this action is invoked by
 the user.

 If you do not want or have a keyboard shortcut,
 set the @p cut param to 0.

 This is the most common KAction used when you do not have a
 corresponding icon (note that it won't appear in the current version
 of the "Edit ToolBar" dialog, because an action needs an icon to be
 plugged in a toolbar...).

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot actionCollection: (KActionCollection*)parent name: (NSString *)name;

/** 
 Constructs an action with text, icon, potential keyboard
 shortcut, and a SLOT to call when this action is invoked by
 the user.

 If you do not want or have a keyboard shortcut, set the
 @p cut param to 0.

 This is the other common KAction used.  Use it when you
 @p do have a corresponding icon.

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot actionCollection: (KActionCollection*)parent name: (NSString *)name;

/** 
 Constructs an action with text, icon, potential keyboard
 shortcut, and a SLOT to call when this action is invoked by
 the user.  The icon is loaded on demand later based on where it
 is plugged in.

 If you do not want or have a keyboard shortcut, set the
 @p cut param to 0.

 This is the other common KAction used.  Use it when you
 @p do have a corresponding icon.

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot actionCollection: (KActionCollection*)parent name: (NSString *)name;

/** 
 The same as the above constructor, but with a KGuiItem providing
 the text and icon.

*/
- initWithGuiItem: (KGuiItem*)item cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (KActionCollection*)parent name: (NSString *)name;

/**  @obsolete 
*/
- initWithText: (NSString *)text cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text ;

/**  @obsolete 
*/
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/**  @obsolete 
*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix ;

/**  @obsolete 
*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix ;

/**  @obsolete 
*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/**  @obsolete 
*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/**  @obsolete 
*/
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;

/**  Standard destructor 
*/
- (void) dealloc;

/** 
 "Plug" or insert this action into a given widget.

 This will
 typically be a menu or a toolbar.  From this point on, you will
 never need to directly manipulate the item in the menu or
 toolbar.  You do all enabling/disabling/manipulation directly
 with your KAction object.

*/
- (int) plug: (QWidget *)w index: (int)index;
- (int) plug: (QWidget *)w ;

/** 
 "Plug" or insert this action into a given KAccel.

 It is sometimes useful to use the action paradigm for
 actions that are not associated with some widget (ie actions
 that are only activated by keyboard).

*/
- plugAccel: (KAccel*)accel configurable: (BOOL)configurable;
- plugAccel: (KAccel*)accel ;

/** 
 "Unplug" or remove this action from a given widget.

 This will typically be a menu or a toolbar.  This is rarely
 used in "normal" application.  Typically, it would be used if
 your application has several views or modes, each with a
 completely different menu structure.  If you simply want to
 disable an action for a given period, use @ref -setEnabled
 instead.

*/
- unplug: (QWidget *)w;

/** 
 Disconnect this action from the KAccel.
     
*/
- unplugAccel;

/** 
 returns whether the action is plugged into any container widget or not.
     
*/
- (BOOL) isPlugged;

/** 
 returns whether the action is plugged into the given container with the given, container specific, id (often
 menu or toolbar id ) .
     
*/
- (BOOL) isPlugged: (QWidget *)container identifier: (int)identifier;

/** 
 returns whether the action is plugged into the given container with the given, container specific, representative
 container widget item.
     
*/
- (BOOL) isPlugged: (QWidget *)container _representative: (QWidget *)_representative;
- (QWidget*) container: (int)index;
- (int) itemId: (int)index;
- (QWidget*) representative: (int)index;
- (int) containerCount;
- (QPixmap*) pixmap;
- (BOOL) hasIconSet;
- (NSString *) plainText;

/** 
 Get the text associated with this action.
     
*/
- (NSString *) text;

/** 
 Get the keyboard shortcut associated with this action.
     
*/
- (KShortcut*) shortcut;

/** 
 Get the default shortcut for this action.
     
*/
- (KShortcut*) shortcutDefault;
- (NSString *) shortcutText;
- setShortcutText: (NSString *)arg1;

/**  Returns true if this action is enabled. 
*/
- (BOOL) isEnabled;

/**  Returns true if this action's shortcut is configurable. 
*/
- (BOOL) isConfigurable;
- (NSString *) group;

/** 
 Get the What's this text for the action.
     
*/
- (NSString *) whatsThis;

/** 
 Get the tooltip text for the action.
     
*/
- (NSString *) toolTip;

/** 
 Get the QIconSet from which the icons used to display this action will
 be chosen.
     
*/
- (QIconSet*) iconSet;
- (NSString *) icon;
- (KActionCollection*) parentCollection;
- unplugAll;

/** 

 Get the keyboard accelerator associated with this action.
     
*/
- (int) accel;
- (NSString *) statusText;

/** 

 Sets the keyboard accelerator associated with this action.
     
*/
- setAccel: (int)key;

/** 

     
*/
- setStatusText: (NSString *)text;

/** 

     
*/
- (int) menuId: (int)i;

/** 
 Sets the text associated with this action. The text is used for menu
 and toolbar labels etc.
     
*/
- setText: (NSString *)text;

/** 
 Sets the keyboard shortcut associated with this action.
     
*/
- setShortcut: (KShortcut*)arg1;
- setGroup: (NSString *)arg1;

/** 
 Sets the What's this text for the action. This text will be displayed when
 a widget that has been created by plugging this action into a container
 is clicked on in What's this mode.

 The What's this text can include QML markup as well as raw text.
     
*/
- setWhatsThis: (NSString *)text;

/** 
 Sets the tooltip text for the action.
 This will be used as a tooltip for a toolbar button, as a
 statusbar help-text for a menu item, and it also appears
 in the toolbar editor, to describe the action.
     
*/
- setToolTip: (NSString *)arg1;

/** 
 Sets the QIconSet from which the icons used to display this action will
 be chosen.
     
*/
- setIconSet: (QIconSet*)iconSet;
- setIcon: (NSString *)icon;

/** 
 Enables or disables this action. All uses of this action (eg. in menus
 or toolbars) will be updated to reflect the state of the action.
     
*/
- setEnabled: (BOOL)enable;

/**  Indicate whether the user may configure the action's shortcut. 
*/
- setConfigurable: (BOOL)arg1;

/** 
 Emulate user's interaction programmatically, by activating the action.
 The implementation simply emits -activated.
     
*/
- activate;

/** 

 Generate a toolbar button id. Made public for reimplementations.
     
*/
+ (int) getToolButtonID;
- (KToolBar*) toolBar: (int)index;
- (QPopupMenu*) popupMenu: (int)index;
- removeContainer: (int)index;
- (int) findContainer: (QWidget *)widget;
- plugMainWindowAccel: (QWidget *)w;
- addContainer: (QWidget *)parent identifier: (int)identifier;
- addContainer: (QWidget *)parent representative: (QWidget *)representative;
- setShortcutWithId: (int)i;
- setShortcut: (QPopupMenu*)menu identifier: (int)identifier;
- setGroup: (int)identifier grp: (NSString *)grp;
- setText: (int)i text: (NSString *)text;
- setEnabled: (int)i enable: (BOOL)enable;
- setIconSet: (int)i iconSet: (QIconSet*)iconSet;
- setIcon: (int)i icon: (NSString *)icon;
- setToolTip: (int)identifier tt: (NSString *)tt;
- setWhatsThis: (int)i text: (NSString *)text;
- slotDestroyed;
- slotKeycodeChanged;
- slotActivated;
@end

/** Override these methods in subclasses of KAction to customise event handling behaviour */
@protocol KActionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
