/***************************************************************************
                            KDirSize.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDIRSIZE_H
#define KDIRSIZE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/Job.h>

/**

 Computes a directory size (similar to "du", but doesn't give the same results
 since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 
 @short 
 Computes a directory size (similar to "du", but doesn't give the same results
 since we simply sum up the dir and file sizes, whereas du speaks disk blocks)
 
*/

@class KURL;

@interface KDirSize : Job

/** 

*/
- (unsigned long) totalSize;

/** 
 Asynchronous method. Connect to the result signal.
 This one lists a single directory.
   
*/
+ (KDirSize*) dirSizeJobForURL: (KURL*)directory;

/** 
 Asynchronous method. Connect to the result signal.
 This one lists the items from @p lstItems.
 The reason we asks for items instead of just urls, is so that
 we directly know if the item is a file or a directory,
 and in case of a file, we already have its size.
   
*/
+ (KDirSize*) dirSizeJob: (NSArray *)lstItems;

/** 
 Synchronous method - you get the result as soon as
 the call returns.
   
*/
+ (unsigned long) dirSize: (KURL*)directory;
- initWithURL: (KURL*)directory;
- initWithArray: (NSArray *)lstItems;
- (void) dealloc;

/** 

   
*/
- setSync;
- startNextJob: (KURL*)url;
- slotResult: (Job*)job;
//- slotEntries: (Job*)arg1 udsentrylist: (UDSEntryList*)arg2;
- processList;
@end

/** Override these methods in subclasses of KDirSize to customise event handling behaviour */
@protocol KDirSizeEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
