/***************************************************************************
                            KPalette.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPALETTE_H
#define KPALETTE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Class for handling Palettes.

 This class makes it easy to handle palettes.
 A palette is a set of colors. This class can read
 and write palettes from and to a file.

 This class uses the "GIMP" palette file format.

 This class is totally unrelated to QPalette.

 @author Waldo Bastian (bastian@kde.org)

 @version $Id: KPalette.h,v 1.3 2002/03/15 02:12:21 rdale Exp $

 @short 
 Class for handling Palettes.
*/
@class QColor; 

@interface  KPalette : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 KPalette constructor. Creates a KPalette from a file
 the filename is derived from the name.

*/
- initWithText: (NSString *)name;
- init;

/** 
 KPalette copy constructor.

*/
- copyWithZone: (NSZone *) zone;

/** 
 KPalette destructor.

*/
- (void) dealloc;

/** 
 Save the palette

*/
- (BOOL) save;

/** 
 Get the description of the palette.

*/
- (NSString *) description;

/**    	
 Set the description of the palette.

*/
- setDescription: (NSString *)desc;

/** 
 Get the name of the palette. 

*/
- (NSString *) name;

/** 
 Set the name of the palette.

*/
- setName: (NSString *)name;

/** 
 Returns whether the palette may be edited.

*/
- (int) editable;

/** 
 Change whether the palette may be edited.

*/
- setEditable: (int)editable;

/** 
 Return the number of colors in the palette.

*/
- (int) nrColors;

/** 
 Find color by index.

*/
- (QColor*) color: (int)index;

/** 
 Find index by @p color.

*/
- (int) findColor: (QColor *)color;

/**  
 Find color name by @p index.

*/
- (NSString *) colorNameAtId: (int)index;

/** 
 Find color name by @p color.

*/
- (NSString *) colorName: (QColor *)color;

/** 
 Add a color.

*/
- (int) addColor: (QColor *)newColor newColorName: (NSString *)newColorName;
- (int) addColor: (QColor *)newColor ;

/** 
 Change a color.

*/
- (int) changeColorAtId: (int)index newColor: (QColor *)newColor newColorName: (NSString *)newColorName;
- (int) changeColorAtId: (int)index newColor: (QColor *)newColor ;

/** 
 Change a color.

*/
- (int) changeColor: (QColor *)oldColor newColor: (QColor *)newColor newColorName: (NSString *)newColorName;
- (int) changeColor: (QColor *)oldColor newColor: (QColor *)newColor ;

/** 
 Query which KDE palettes are installed.

*/
+ (NSArray *) getPaletteList;
+ (int) Yes;
+ (int) No;
+ (int) Ask;
@end

#endif
