/***************************************************************************
                            KProcess.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROCESS_H
#define KPROCESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 Child process invocation, monitoring and control.

This class allows a KDE application to start child processes without having
to worry about UN*X signal handling issues and zombie process reaping.

Basically, this class distinguishes three different ways of running
child processes:

Starting a  DontCare child process means that the application is
not interested in any notification to determine whether the
child process has already exited or not.

When the child process exits, the KProcess instance
corresponding to it emits the Qt signal @ref -processExited.

Since this signal is @em not emitted from within a UN*X
signal handler, arbitrary function calls can be made.

Be aware: When the KProcess objects gets destructed, the child
process will be killed if it is still running!
This means in particular, that you cannot use a KProcess on the stack
with -[KProcess NotifyOnExit].

KProcess also provides several functions for determining the exit status
and the pid of the child process it represents.

Furthermore it is possible to supply command-line arguments to the process
in a clean fashion (no null -- terminated stringlists and such...)

A small usage example:
<pre>
KProcess *proc = new KProcess;

*proc << "my_executable";
*proc << "These" << "are" << "the" << "command" << "line" << "args";
-[QApplication connect](proc, SIGNAL(processExited(KProcess *)),
                      pointer_to_my_object, SLOT(my_objects_slot(KProcess *)));
-[proc start];
</pre>

This will start "my_executable" with the commandline arguments "These"...

When the child process exits, the respective Qt signal will be emitted.

KProcess supports communication with the child process through
stdin/stdout/stderr.

The following functions are provided for getting data from the child
process or sending data to the child's stdin (For more information,
have a look at the documentation of each function):

 @author Christian Czezakte e9025461@student.tuwien.ac.at

 @short 
 Child process invocation, monitoring and control.
*/

@interface KProcess : QObject 

/**  Constructor 
*/
- init;

/** 
Destructor:

  If the process is running when the destructor for this class
  is called, the child process is killed with a SIGKILL, but
  only if the run mode is not of type @p DontCare.
  Processes started as @p DontCare keep running anyway.
  
*/
- (void) dealloc;

/** 

         The use of this function is now deprecated. -- Please use the
	 "operator<<" instead of "setExecutable".

	 Sets the executable to be started with this KProcess object.
	 Returns false if the process is currently running (in that
	 case the executable remains unchanged.)

  
*/
- (BOOL) setExecutable: (NSString *)proc;

/** 
 Clear a command line argument list that has been set by using
 the "operator<<".
  
*/
- clearArguments;

/** 
  Starts the process.
  For a detailed description of the
  various run modes and communication semantics, have a look at the
  general description of the KProcess class.

  The following problems could cause this function to
    return false:

*/
- (BOOL) start: (int)runmode comm: (int)comm;
- (BOOL) start;

/** 
 Stop the process (by sending it a signal).

*/
- (BOOL) kill: (int)signo;
//- (BOOL) kill;

/** 

*/
- (BOOL) isRunning;

/**  Returns the process id of the process.

 If it is called after
 the process has exited, it returns the process id of the last
  child process that was created by this instance of KProcess.

  Calling it before any child process has been started by this
  KProcess instance causes -pid to return 0.

*/
- (long) pid;

/** 
 Use -pid.

   
*/
- (long) getPid;

/** 
 Suspend processing of data from stdout of the child process.
   
*/
- suspend;

/** 
 Resume processing of data from stdout of the child process.
   
*/
- resume;

/** 

 Note that you should check @ref -[KProcess exitStatus] to determine
 whether the process completed its task successful or not.
   
*/
- (BOOL) normalExit;

/** 
 Returns the exit status of the process.

 Please use
 @ref -[KProcess normalExit] to check whether the process has exited
 cleanly (i.e., @ref -[KProcess normalExit] returns @p true) before calling
 this function because if the process did not exit normally,
 it does not have a valid exit status.
  
*/
- (int) exitStatus;

/** 
	 Transmit data to the child process's stdin.

 -[KProcess writeStdin]may return false in the following cases:

 Please note that the data is sent to the client asynchronously,
 so when this function returns, the data might not have been
 processed by the child process.

 If all the data has been sent to the client, the signal
 @ref -wroteStdin will be emitted.

 Please note that you must not free "buffer" or call @ref -writeStdin
 again until either a @ref -wroteStdin signal indicates that the
 data has been sent or a @ref -processHasExited signal shows that
 the child process is no longer alive...

*/
- (BOOL) writeStdin: (NSString *)buffer buflen: (int)buflen;

/** 
 This causes the stdin file descriptor of the child process to be
 closed indicating an "EOF" to the child.

*/
- (BOOL) closeStdin;

/** 
 This causes the stdout file descriptor of the child process to be
 closed.

*/
- (BOOL) closeStdout;

/** 
 This causes the stderr file descriptor of the child process to be
 closed.

*/
- (BOOL) closeStderr;

/** 
 Controls whether the started process should drop any
 setuid/segid privileges or whether it should keep them

 The default is @p false : drop privileges
   
*/
- setRunPrivileged: (BOOL)keepPrivileges;

/** 
 Returns whether the started process will drop any
 setuid/segid privileges or whether it will keep them
   
*/
- (BOOL) runPrivileged;

/** 
 Modifies the environment of the process to be started.
 This function must be called before starting the process.
   
*/
- setEnvironment: (NSString *)name value: (NSString *)value;

/** 
 Changes the current working directory (CWD) of the process 
 to be started.
 This function must be called before starting the process.
   
*/
- setWorkingDirectory: (NSString *)dir;

/** 
 Detaches KProcess from child process. All communication is closed.
 No exit notification is emitted any more for the child process.
 Deleting the KProcess will no longer kill the child process.
 Note that the current process remains the parent process of the
 child process.
   
*/
- detach;

/** 
     Sets up the environment according to the data passed via 
     setEnvironment(...)
  
*/
- setupEnvironment;

/** 
    This function is called from "-[KProcess start]" right before a "fork" takes
    place. According to
    the "comm" parameter this function has to initialize the "in", "out" and
    "err" data member of KProcess.

    This function should return 0 if setting the needed communication channels
    was successful.

    The default implementation is to create UNIX STREAM sockets for the communication,
    but you could overload this function and establish a TCP/IP communication for
    network communication, for example.
  
*/
- (int) setupCommunication: (int)comm;

/** 
     Called right after a (successful) fork on the parent side. This function
     will usually do some communications cleanup, like closing the reading end
     of the "stdin" communication channel.

     Furthermore, it must also create the QSocketNotifiers "innot", "outnot" and
     "errnot" and connect their Qt slots to the respective KProcess member functions.

     For a more detailed explanation, it is best to have a look at the default
     implementation of "setupCommunication" in kprocess.cpp.
  
*/
- (int) commSetupDoneP;

/** 
     Called right after a (successful) fork, but before an "exec" on the child
     process' side. It usually just closes the unused communication ends of
     "in", "out" and "err" (like the writing end of the "in" communication
     channel.
  
*/
- (int) commSetupDoneC;

/** 
     Immediately called after a process has exited. This function normally
     calls commClose to close all open communication channels to this
     process and emits the "processExited" signal (if the process was
     not running in the "DontCare" mode).
  
*/
- processHasExited: (int)state;

/** 
     Should clean up the communication links to the child after it has
     exited. Should be called from "processHasExited".
  
*/
- commClose;

/** 
     Called by "slotChildOutput" this function copies data arriving from the
     child process's stdout to the respective buffer and emits the signal
     "@ref receivedStderr".
  
*/
- (int) childOutput: (int)fdno;

/** 
     Called by "slotChildOutput" this function copies data arriving from the
     child process's stdout to the respective buffer and emits the signal
     "@ref receivedStderr"
  
*/
- (int) childError: (int)fdno;

/** 
   This slot gets activated when data from the child's stdout arrives.
   It usually calls "childOutput"
  
*/
- slotChildOutput: (int)fdno;

/** 
   This slot gets activated when data from the child's stderr arrives.
   It usually calls "childError"
  
*/
- slotChildError: (int)fdno;

/** 
	Called when another bulk of data can be sent to the child's
	stdin. If there is no more data to be sent to stdin currently
	available, this function must disable the QSocketNotifier "innot".
  
*/
- slotSendData: (int)dummy;
+ (int) NoCommunication;
+ (int) Stdin;
+ (int) Stdout;
+ (int) Stderr;
+ (int) AllOutput;
+ (int) All;
+ (int) NoRead;
+ (int) /***Theapplicationdoesnotreceivenotificationsfromthesubprocesswhen*itisfinishedoraborted.*/DontCare;
+ (int) /***Theapplicationisnotifiedwhenthesubprocessdies.*/NotifyOnExit;
+ (int) /***Theapplicationissuspendeduntilthestartedprocessisfinished.*/Block;
@end

/** Override these methods in subclasses of KProcess to customise event handling behaviour */
@protocol KProcessEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
