/***************************************************************************
                            KSeparator.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSEPARATOR_H
#define KSEPARATOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 Standard horizontal or vertical separator.

 @author Michael Roth <mroth@wirlweb.de>

 @version $Id: KSeparator.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short 
 Standard horizontal or vertical separator.
*/
@interface KSeparator : QFrame 

/** 
 Constructor.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;

/** 
 Constructor.

*/
- initWithInt: (int)orientation parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- initWithInt: (int)orientation ;

/** 
 Returns the orientation of the separator.

 Possible values are VLine and HLine.

*/
- (int) orientation;

/** 
 Set the orientation of the separator to @p orient

 Possible values are VLine and HLine.
   
*/
- setOrientation: (int)orient;

/** 
 The recommended height (width) for a horizontal (vertical) separator.

*/
- (QSize*) sizeHint;
- drawFrame: (QPainter *)arg1;
@end

/** Override these methods in subclasses of KSeparator to customise event handling behaviour */
@protocol KSeparatorEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
