/***************************************************************************
                            KService.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSERVICE_H
#define KSERVICE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KSycocaEntry.h>

/**

 Represent a service, i.e. an application bound to one or several mimetypes
 (or servicetypes) as written in its desktop entry file.

 A service may be a library, too.
 The starting point you need is often the static methods.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Represent a service, i.
*/
@class KDesktopFile; 
@class List; 
@class QDataStream; 
@class QPixmap; 
@class QVariant; 

@interface KService : KSycocaEntry 

/** 
 Construct a temporary service with a given name, exec-line and icon.
   
*/
- initWithText: (NSString *)_name _exec: (NSString *)_exec _icon: (NSString *)_icon;

/** 
 Construct a service and take all information from a config file.

*/
- initWithText: (NSString *)_fullpath;

/** 
 Construct a service and take all information from a desktop file.
   
*/
- initWithDesktopFile: (KDesktopFile*)config;

/** 

 Construct a service from a stream.
 The stream must already be positionned at the correct offset.
   
*/
- initWithDataStream: (QDataStream *)_str offset: (int)offset;
- (void) dealloc;

/** 

*/
- (NSString *) type;

/** 

*/
- (NSString *) name;

/** 

*/
- (NSString *) exec;

/** 

*/
- (NSString *) library;

/** 

*/
- (NSString *) init;

/** 

*/
- (NSString *) icon;

/** 

*/
- (QPixmap*) pixmap: (int)_group _force_size: (int)_force_size _state: (int)_state _path: (NSString *)_path;
- (QPixmap*) pixmap: (int)_group ;

/** 

*/
- (BOOL) terminal;

/** 

 The service must be a tty-oriented program.
   
*/
- (NSString *) terminalOptions;

/** 

*/
- (BOOL) substituteUid;

/** 

*/
- (NSString *) username;

/** 

 This is a relative path if the desktop entry was found in any
 of the locations pointed to by $KDEDIRS (e.g. "Internet/kppp.desktop")
 It is a full path if the desktop entry originates from another
 location.
   
*/
- (NSString *) desktopEntryPath;

/** 

*/
- (NSString *) desktopEntryName;

/** 

*/
- (int) DCOPServiceType;

/** 

*/
- (NSString *) path;

/** 

*/
- (NSString *) comment;

/** 

*/
- (NSArray *) keywords;

/** 

*/
- (NSArray *) serviceTypes;

/** 

*/
- (BOOL) hasServiceType: (NSString *)_service;

/** 

*/
- (BOOL) allowAsDefault;

/** 

*/
- (BOOL) allowMultipleFiles;

/** 
 What preference to associate with this service initially (before
 the user has had any chance to define a profile for it)
 The bigger the value, the most preferred the service is.
   
*/
- (int) initialPreference;

/** 

   
*/
- setInitialPreference: (int)i;

/** 
 Whether the entry should be suppressed in menus.
   
*/
- (BOOL) noDisplay;

/** 

         It depends upon the @ref -serviceTypes of this service which
         properties a service can have.

*/
- (QVariant*) property: (NSString *)_name;

/** 

*/
- (NSArray *) propertyNames;

/** 

*/
- (BOOL) isValid;

/** 

 Load the service from a stream.
   
*/
- load: (QDataStream *)arg1;

/** 

 Save the service to a stream.
   
*/
- save: (QDataStream *)arg1;

/** 
 Find a service by name, i.e. the translated Name field. You should
 really not use this method, since the name is translated.

*/
+ (void*) serviceByName: (NSString *)_name;

/** 
 Find a service by its relative path to the applnk or services
 directory, for instance "Internet/konqbrowser.desktop". Better not use
 it for menu entries though, since the user can move them.
 It's ok to use it for services though (e.g. "http_cache_cleaner.desktop")

*/
+ (void*) serviceByDesktopPath: (NSString *)_name;

/** 
 Find a service by the name of its desktop file, not depending on
 its actual location (as long as it's under the applnk or service
 directories). For instance "konqbrowser" or "kcookiejar". Note that
 the ".desktop" extension is implicit.

 This is the recommended method (safe even if the user moves stuff)
 but note that it assumes that no two entries have the same filename.

*/
+ (void*) serviceByDesktopName: (NSString *)_name;

/** 

  Useful for being able to
 to display them in a list box, for example.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
//+ (List) allServices;

/** 

 Only needed by "kcminit"
   
*/
//+ (List) allInitServices;
- init: (KDesktopFile*)config;
- (NSArray *) accessServiceTypes;
+ (int) DCOP_None;
+ (int) DCOP_Unique;
+ (int) DCOP_Multi;
+ (int) DCOP_Wait;
@end

#endif
