<?xml version="1.0" encoding="utf-8"?>
<!--
  ** Author: Marco Ladermann
  ** Date: Thu Jan 23 10:08:18 CET 2003 @422 /Internet Time/
  ** Purpose: Define some parameters and routines to check them
  ** Changed:
  **
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
    <xsl:param name="package" select="''"/><!-- package name of classes -->
    <xsl:param name="genabstract" select="'true'"/><!-- generate slots as abstract and not with a default implementation -->
    <xsl:param name="os" select="'unix'"/><!-- operating system, see $newline -->
    <xsl:param name="images" select="'images/'"/>
	<xsl:param name="kde" select="//widget[starts-with(@class, 'K')]"/>
    
    <xsl:variable name="abstract" select="$genabstract = 'true'"/>
    <xsl:variable name="newline">
        <xsl:choose>
            <xsl:when test="$os = 'unix'"><xsl:value-of select="'&#xA;'"/></xsl:when>
            <xsl:when test="$os = 'msdos'"><xsl:value-of select="'&#xD;&#xA;'"/></xsl:when>
            <xsl:when test="$os = 'mac'"><xsl:value-of select="'&#xD;'"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="'&#xA;'"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>

</xsl:stylesheet>

