/***************************************************************************
                            QSpinBox.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QSPINBOX_H
#define QSPINBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QRangeControl.h>
#include <qtobjc/QWidget.h>

@class QLineEdit; 
@class QValidator; 

@interface QSpinBox : QWidget 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- initWithInt: (int)minValue maxValue: (int)maxValue step: (int)step parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)minValue maxValue: (int)maxValue ;
- (void) dealloc;
- (NSString *) text;
- (NSString *) prefix;
- (NSString *) suffix;
- (NSString *) cleanText;
- setSpecialValueText: (NSString *)text;
- (NSString *) specialValueText;
- setWrapping: (BOOL)on;
- (BOOL) wrapping;
- setButtonSymbols: (int)arg1;
- (int) buttonSymbols;
- setValidator: (QValidator *)v;
- (QValidator*) validator;
- (QSize*) sizeHint;
- (QSize*) minimumSizeHint;
- (int) minValue;
- (int) maxValue;
- setMinValue: (int)arg1;
- setMaxValue: (int)arg1;
- (int) lineStep;
- setLineStep: (int)arg1;
- (int) value;
- (QRect*) upRect;
- (QRect*) downRect;
- setValue: (int)value;
- setPrefix: (NSString *)text;
- setSuffix: (NSString *)text;
- stepUp;
- stepDown;
- setEnabled: (BOOL)enabled;
- selectAll;
- (NSString *) mapValueToText: (int)value;
- (int) mapTextToValue: (int*)ok;
- (NSString *) currentValueText;
- updateDisplay;
- interpretText;
- (QLineEdit*) editor;
- valueChange;
- rangeChange;
- (BOOL) eventFilter: (QObject *)obj ev: (QEvent *)ev;
- styleChange: (QStyle*)arg1;
- textChanged;
+ (int) UpDownArrows;
+ (int) PlusMinus;
@end

@class QContextMenuEvent; 
@class QIMEvent; 
@class QLineEdit; 
@class QStyle; 
@class QTabletEvent; 
@class QValidator; 

@class QLineEdit; 
@class QValidator; 

@interface QSpinBox (QRangeControlImplementation) <QRangeControlInterface>
@end

/** Override these methods in subclasses of QSpinBox to customise event handling behaviour */
@protocol QSpinBoxEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) ev;
@end


#endif
