/***************************************************************************
                            QTable.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QTABLE_H
#define QTABLE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QScrollView.h>

@class QHeader;
@class QTableSelection;
@class QTableItem;

@class QColorGroup; 
@class QContextMenuEvent; 
@class QDragObject; 
@class QIMEvent; 
@class QPixmap; 
@class QTabletEvent; 

@interface QTable : QScrollView 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- initWithInt: (int)numRows numCols: (int)numCols parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)numRows numCols: (int)numCols ;
- (void) dealloc;
- (QHeader*) horizontalHeader;
- (QHeader*) verticalHeader;
- setSelectionMode: (int)mode;
- (int) selectionMode;
- setItem: (int)row col: (int)col item: (QTableItem*)item;
- setText: (int)row col: (int)col text: (NSString *)text;
- setPixmap: (int)row col: (int)col pix: (QPixmap *)pix;
- (QTableItem*) item: (int)row col: (int)col;
- (NSString *) text: (int)row col: (int)col;
- (QPixmap*) pixmap: (int)row col: (int)col;
- clearCell: (int)row col: (int)col;
- (QRect*) cellGeometry: (int)row col: (int)col;
- (int) columnWidth: (int)col;
- (int) rowHeight: (int)row;
- (int) columnPos: (int)col;
- (int) rowPos: (int)row;
- (int) columnAt: (int)x;
- (int) rowAt: (int)y;
- (int) numRows;
- (int) numCols;
- updateCell: (int)row col: (int)col;
- (BOOL) eventFilter: (QObject *)o event: (QEvent *)arg1;
- (int) currentRow;
- (int) currentColumn;
- ensureCellVisible: (int)row col: (int)col;
- (BOOL) isSelected: (int)row col: (int)col;
- (BOOL) isRowSelected: (int)row full: (BOOL)full;
- (BOOL) isRowSelected: (int)row ;
- (BOOL) isColumnSelected: (int)col full: (BOOL)full;
- (BOOL) isColumnSelected: (int)col ;
- (int) numSelections;
- (QTableSelection*) selection: (int)num;
- (int) addSelection: (QTableSelection*)s;
- removeSelection: (QTableSelection*)s;
- removeSelectionAt: (int)num;
- (int) currentSelection;
- (BOOL) showGrid;
- (BOOL) columnMovingEnabled;
- (BOOL) rowMovingEnabled;
- sortColumn: (int)col ascending: (BOOL)ascending wholeRows: (BOOL)wholeRows;
- sortColumn: (int)col ;
- (BOOL) sorting;
- takeItem: (QTableItem*)i;
- setCellWidget: (int)row col: (int)col e: (QWidget *)e;
- (QWidget*) cellWidget: (int)row col: (int)col;
- clearCellWidget: (int)row col: (int)col;
- (QRect*) cellRect: (int)row col: (int)col;
- paintCell: (QPainter *)p row: (int)row col: (int)col cr: (QRect*)cr selected: (BOOL)selected;
- paintCell: (QPainter *)p row: (int)row col: (int)col cr: (QRect*)cr selected: (BOOL)selected cg: (QColorGroup *)cg;
- paintFocus: (QPainter *)p r: (QRect*)r;
- (QSize*) sizeHint;
- (BOOL) isReadOnly;
- (BOOL) isRowReadOnly: (int)row;
- (BOOL) isColumnReadOnly: (int)col;
- setEnabled: (BOOL)b;
- repaintSelections;
- setFocusStyle: (int)fs;
- (int) focusStyle;
- setNumRows: (int)r;
- setNumCols: (int)r;
- setShowGrid: (BOOL)b;
- hideRow: (int)row;
- hideColumn: (int)col;
- showRow: (int)row;
- showColumn: (int)col;
- setColumnWidth: (int)col w: (int)w;
- setRowHeight: (int)row h: (int)h;
- adjustColumn: (int)col;
- adjustRow: (int)row;
- setColumnStretchable: (int)col stretch: (BOOL)stretch;
- setRowStretchable: (int)row stretch: (BOOL)stretch;
- (BOOL) isColumnStretchable: (int)col;
- (BOOL) isRowStretchable: (int)row;
- setSorting: (BOOL)b;
- swapRows: (int)row1 row2: (int)row2 swapHeader: (BOOL)swapHeader;
- swapRows: (int)row1 row2: (int)row2 ;
- swapColumns: (int)col1 col2: (int)col2 swapHeader: (BOOL)swapHeader;
- swapColumns: (int)col1 col2: (int)col2 ;
- swapCells: (int)row1 col1: (int)col1 row2: (int)row2 col2: (int)col2;
- setLeftMargin: (int)m;
- setTopMargin: (int)m;
- setCurrentCell: (int)row col: (int)col;
- clearSelection: (BOOL)repaint;
- clearSelection;
- setColumnMovingEnabled: (BOOL)b;
- setRowMovingEnabled: (BOOL)b;
- setReadOnly: (BOOL)b;
- setRowReadOnly: (int)row ro: (BOOL)ro;
- setColumnReadOnly: (int)col ro: (BOOL)ro;
- setDragEnabled: (BOOL)b;
- (BOOL) dragEnabled;
- insertRows: (int)row count: (int)count;
- insertRows: (int)row ;
- insertColumns: (int)col count: (int)count;
- insertColumns: (int)col ;
- removeRow: (int)row;
- removeColumn: (int)col;
- editCell: (int)row col: (int)col replace: (BOOL)replace;
- editCell: (int)row col: (int)col ;
- drawContents: (QPainter *)p cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
//- setEditMode: (int)mode row: (int)row col: (int)col;
- (QDragObject*) dragObject;
- startDrag;
- paintEmptyArea: (QPainter *)p cx: (int)cx cy: (int)cy cw: (int)cw ch: (int)ch;
- activateNextCell;
- (QWidget*) createEditor: (int)row col: (int)col initFromCell: (BOOL)initFromCell;
- setCellContentFromEditor: (int)row col: (int)col;
- (QWidget*) beginEdit: (int)row col: (int)col replace: (BOOL)replace;
- endEdit: (int)row col: (int)col accept: (BOOL)accept replace: (BOOL)replace;
- resizeData: (int)len;
- insertWidget: (int)row col: (int)col w: (QWidget *)w;
- (int) indexOf: (int)row col: (int)col;
- windowActivationChange: (BOOL)arg1;
- (BOOL) isEditing;
- (int) editMode;
- (int) currEditRow;
- (int) currEditCol;
- columnWidthChanged: (int)col;
- rowHeightChanged: (int)row;
- columnIndexChanged: (int)section fromIndex: (int)fromIndex toIndex: (int)toIndex;
- rowIndexChanged: (int)section fromIndex: (int)fromIndex toIndex: (int)toIndex;
- columnClicked: (int)col;
+ (int) Single;
+ (int) Multi;
+ (int) SingleRow;
+ (int) MultiRow;
+ (int) NoSelection;
+ (int) FollowStyle;
+ (int) SpreadSheet;
+ (int) NotEditing;
+ (int) Editing;
+ (int) Replacing;
@end

/** Override these methods in subclasses of QTable to customise event handling behaviour */
@protocol QTableEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) e;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- contentsMouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;
- contentsMousePressEvent:(QMouseEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
