/***************************************************************************
                            QUrlOperator.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QURLOPERATOR_H
#define QURLOPERATOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>
#include <qtobjc/QUrl.h>

@class QNetworkOperation; 
@class QUrlInfo; 

@interface QUrlOperator : QObject 
- init;
- initWithText: (NSString *)urL;
- copyWithZone: (NSZone *) zone;
- initWithUrlOperator: (QUrlOperator*)url relUrl: (NSString *)relUrl checkSlash: (BOOL)checkSlash;
- initWithUrlOperator: (QUrlOperator*)url relUrl: (NSString *)relUrl ;
- (void) dealloc;
- setPath: (NSString *)path;
- (BOOL) cdUp;
- (QNetworkOperation*) listChildren;
- (QNetworkOperation*) mkdir: (NSString *)dirname;
- (QNetworkOperation*) remove: (NSString *)filename;
- (QNetworkOperation*) rename: (NSString *)oldname newname: (NSString *)newname;
- (QNetworkOperation*) get: (NSString *)location;
- (QNetworkOperation*) get;
- (QNetworkOperation*) put: (QByteArray*)data location: (NSString *)location;
- (QNetworkOperation*) put: (QByteArray*)data ;
- copy: (NSArray *)files dest: (NSString *)dest move: (BOOL)move;
- copy: (NSArray *)files dest: (NSString *)dest ;
- (BOOL) isDir: (int*)ok;
- (BOOL) isDir;
- setNameFilter: (NSString *)nameFilter;
- (NSString *) nameFilter;
- (QUrlInfo*) info: (NSString *)entry;
- stop;
- reset;
- (BOOL) parseURL: (NSString *)url;
- (BOOL) checkValid;
- clearEntries;
- getNetworkProtocol;
- deleteNetworkProtocol;
@end

@class QNetworkOperation; 
@class QUrlInfo; 

@interface QUrlOperator (QUrlImplementation) <QUrlInterface>
@end

/** Override these methods in subclasses of QUrlOperator to customise event handling behaviour */
@protocol QUrlOperatorEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
