namespace Binge.Bits
{
	using System;
	using System.Text;

	public class Indentation: Binge.Bits.Object
	{
		public int Depth;
		public char Tab;

		public Indentation ()
		{
			Depth = 0;
			Tab = '\t';
		}

		public void Indent ()
		{
			Depth++;
		}

		public void Dedent ()
		{
			Depth--;
		}

		public static Indentation operator + (Indentation indent, int count)
		{
			indent.Depth += count;
			return indent;
		}

		public static Indentation operator - (Indentation indent, int count)
		{
			indent.Depth -= count;
			return indent;
		}

		public static Indentation operator ++ (Indentation indent)
		{
			indent.Depth++;
			return indent;
		}

		public static Indentation operator -- (Indentation indent)
		{
			indent.Depth--;
			return indent;
		}

		public override string ToString ()
		{
			StringBuilder sb = new StringBuilder ();

			for (int i = 0; i < Depth; i++)
				sb.Append (Tab);

			return sb.ToString ();
		}
	}
}
