//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QUrlInterface;
import java.util.ArrayList;
import org.kde.qt.QUrl;

/**

 Represents and parses a URL.
 A prototypical URL looks like:
 <pre>
   protocol://user:password\@hostname:port/path/to/file.ext#reference
 </pre>
 KURL handles escaping of URLs. This means that the specification
 of a full URL will differ from the corresponding string that would specify a
 local file or directory in file-operations like fopen. This is because an URL
 doesn't allow certain characters and escapes them. (e.g. '#'."%23", space."%20")
 (In a URL the hash-character '#' is used to specify a "reference", i.e. the position
 within a document).
 The constructor KURL(String) expects a string properly escaped,
 or at least non-ambiguous.
 For instance a local file or directory "/bar/#foo#" would have the URL
 file:///bar/%23foo%23.
 If you have the absolute path and need the URL-escaping you should create
 KURL via the default-constructor and then call setPath(String).
 <pre>
     KURL kurl;
     kurl.setPath("/bar/#foo#");
     String url = kurl.url();    // . "file:///bar/%23foo%23"
 </pre>
 If you have the URL of a local file or directory and need the absolute path,
 you would use path().
 <pre>
    KURL url( "file:///bar/%23foo%23" );
    ...
    if ( url.isLocalFile() )
       String path = url.path();       // . "/bar/#foo#"
 </pre>
 The other way round: if the user can enter a string, that can be either a
 path or a URL, then you need to use KURL.fromPathOrURL() to build a KURL.
 This must also be considered, when you have separated directory and file
 strings and need to put them together.
 While you can simply concatenate normal path strings, you must take care if
 the directory-part is already an escaped URL.
 (This might be needed if the user specifies a relative path, and your
 program supplies the rest from elsewhere.)
 Wrong:
 <pre>
    String dirUrl = "file:///bar/";
    String fileName = "#foo#";
    String invalidURL = dirUrl + fileName;   // . "file:///bar/#foo#" won't behave like you would expect.
 </pre>
 Instead you should use addPath():
 Right:
 <pre>
    KURL url( "file:///bar/" );
    String fileName = "#foo#";
    url.addPath( fileName );
    String validURL = url.url();    // . "file:///bar/%23foo%23"
 </pre>
 Also consider that some URLs contain the password, but this shouldn't be
 visible. Your program should use prettyURL() every time it displays a
 URL, whether in the GUI or in debug output or...
 <pre>
    KURL url( "ftp://name:password@ftp.faraway.org/bar/%23foo%23");
    String visibleURL = url.prettyURL(); // . "ftp://name@ftp.faraway.org/bar/%23foo%23"
 </pre>
 Note that prettyURL() doesn't change the character escapes (like "%23").
 Otherwise the URL would be invalid and the user wouldn't be able to use it in another
 context.
 KURL has some restrictions regarding the path
 encoding. KURL works internally with the decoded path and
 and encoded query. For example,
 <pre>
 http://localhost/cgi-bin/test%20me.pl?cmd=Hello%20you
 </pre>
 would result in a decoded path "/cgi-bin/test me.pl"
 and in the encoded query "?cmd=Hello%20you".
 Since path is internally always encoded you may <b>not</b> use
 "%00" in the path, although this is OK for the query.
		@author Torben Weis <weis@kde.org>
 
		@short    Represents and parses a URL.

*/
public class KURL implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KURL(Class dummy){}

	public static final int NoAdjustements = 0;
	public static final int StripFileProtocol = 1;

	/**	
		 Defines the type of URI we are processing.
		   		@short    Defines the type of URI we are processing.
	*/
	public static final int Auto = 0;
	public static final int Invalid = 1;
	public static final int RawURI = 2;
	public static final int URL = 3;
	public static final int Mailto = 4;

	/**	
		 Options for queryItems. Currently, only one option is
		 defined:
			@param CaseInsensitiveKeys normalize query keys to lowercase.
				@short    Options for queryItems.
	*/
	public static final int CaseInsensitiveKeys = 1;

	/**	
		 Constructs an empty URL.
		   		@short    Constructs an empty URL.
	*/
	public KURL() {
		newKURL();
	}
	private native void newKURL();
	/**	
		 Usual constructor, to construct from a string.
			@param url A URL, not a filename. If the URL does not have a protocol
		             part, "file:" is assumed.
		             It is dangerous to feed unix filenames into this function,
		             this will work most of the time but not always.
		             For example "/home/Torben%20Weis" will be considered a URL
		             pointing to the file "/home/Torben Weis" instead of to the
		             file "/home/Torben%20Weis".
		             This means that if you have a usual UNIX like path you
		             should not use this constructor.
		             Instead create an empty url and set the path by using
		 setPath().
			@param encoding_hint MIB of original encoding of URL.
				@short    Usual constructor, to construct from a string.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public KURL(String url, int encoding_hint) {
		newKURL(url,encoding_hint);
	}
	private native void newKURL(String url, int encoding_hint);
	public KURL(String url) {
		newKURL(url);
	}
	private native void newKURL(String url);
	/**	
		 Copy constructor.
			@param u the KURL to copy
		   		@short    Copy constructor.
	*/
	public KURL(KURL u) {
		newKURL(u);
	}
	private native void newKURL(KURL u);
	/**	
		 Converts from a QUrl.
			@param u the QUrl
		   		@short    Converts from a QUrl.
	*/
	public KURL(QUrlInterface u) {
		newKURL(u);
	}
	private native void newKURL(QUrlInterface u);
	/**	
		 Constructor allowing relative URLs.
			@param _baseurl The base url.
			@param _rel_url A relative or absolute URL.
		 If this is an absolute URL then <code>_baseurl</code> will be ignored.
		 If this is a relative URL it will be combined with <code>_baseurl.</code>
		 Note that _rel_url should be encoded too, in any case.
		 So do NOT pass a path here (use setPath or addPath instead).
			@param encoding_hint MIB of original encoding of URL.
				@short    Constructor allowing relative URLs.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public KURL(KURL _baseurl, String _rel_url, int encoding_hint) {
		newKURL(_baseurl,_rel_url,encoding_hint);
	}
	private native void newKURL(KURL _baseurl, String _rel_url, int encoding_hint);
	public KURL(KURL _baseurl, String _rel_url) {
		newKURL(_baseurl,_rel_url);
	}
	private native void newKURL(KURL _baseurl, String _rel_url);
	/**	
		 Returns the protocol for the URL (i.e., file, http, etc.).
				@return the protocol of the URL, does not include the colon. If the
         URL is malformed, null will be returned.

		@short    Returns the protocol for the URL (i.
	*/
	public native String protocol();
	/**	
		 Sets the protocol for the URL (i.e., file, http, etc.)
			@param _txt the new protocol of the URL (without colon)
				@short    Sets the protocol for the URL (i.
	*/
	public native void setProtocol(String _txt);
	/**	
		 Returns the URI processing mode for the URL.
				@return the URI processing mode set for this URL.

		@short    Returns the URI processing mode for the URL.
	*/
	public native int uriMode();
	/**	
		 Returns the decoded user name (login, user id, ...) included in the URL.
				@return the user name or null if there is no user name

		@short    Returns the decoded user name (login, user id, .
	*/
	public native String user();
	/**	
		 Sets the user name (login, user id, ...) included in the URL.
			 Special characters in the user name will appear encoded in the URL.
			@param _txt the name of the user or null to remove the user
				@short    Sets the user name (login, user id, .
	*/
	public native void setUser(String _txt);
	/**	
		 Test to see if this URL has a user name included in it.
				@return true if the URL has an non-empty user name

		@short    Test to see if this URL has a user name included in it.
	*/
	public native boolean hasUser();
	/**	
		 Returns the decoded password (corresponding to user()) included in the URL.
				@return the password or null if it does not exist

		@short    Returns the decoded password (corresponding to user()) included in the URL.
	*/
	public native String pass();
	/**	
		 Sets the password (corresponding to user()) included in the URL.
			 Special characters in the password will appear encoded in the URL.
		 Note that a password can only appear in a URL string if you also set
		 a user.
			@param _txt the password to set or null to remove the password
				@short    Sets the password (corresponding to user()) included in the URL.
		@see #setUser
		@see #hasUser
	*/
	public native void setPass(String _txt);
	/**	
		 Test to see if this URL has a password included in it.
				@return true if there is a non-empty password set

		@short    Test to see if this URL has a password included in it.
	*/
	public native boolean hasPass();
	/**	
		 Returns the decoded hostname included in the URL.
				@return the name of the host or null if no host is set

		@short    Returns the decoded hostname included in the URL.
	*/
	public native String host();
	/**	
		 Sets the hostname included in the URL.
			 Special characters in the hostname will appear encoded in the URL.
			@param _txt the new name of the host or null to remove the host
				@short    Sets the hostname included in the URL.
	*/
	public native void setHost(String _txt);
	/**	
		 Test to see if this URL has a hostname included in it.
				@return true if the URL has a host

		@short    Test to see if this URL has a hostname included in it.
	*/
	public native boolean hasHost();
	/**	
		 Returns the port number included in the URL.
				@return the port number. If there is no port number specified in the
         URL, returns 0.

		@short    Returns the port number included in the URL.
	*/
	public native short port();
	/**	
		 Sets the port number included in the URL.
			@param _p the new port number or 0 to have no port number
				@short    Sets the port number included in the URL.
	*/
	public native void setPort(short _p);
	/**	
		 Returns the current decoded path. This does <b>not</b> include the query.
				@return the path of the URL (without query), or null if no
         path set.
   
		@short    Returns the current decoded path.
	*/
	public native String path();
	/**	
			@param _trailing May be ( -1, 0 +1 ). -1 strips a trailing '/', +1 adds
		                  a trailing '/' if there is none yet and 0 returns the
		                  path unchanged. If the URL has no path, then no '/' is added
		                  anyway. And on the other side: If the path is "/", then this
		                  character won't be stripped. Reason: "ftp://weis\@host" means something
		                  completely different than "ftp://weis\@host/". So adding or stripping
		                  the '/' would really alter the URL, while "ftp://host/path" and
		                  "ftp://host/path/" mean the same directory.
				@return The current decoded path. This does not include the query. Can
         be null if no path is set.
   
		@short
	*/
	public native String path(int _trailing);
	/**	
		 Sets the path of the URL. The query is not changed by this function.
			@param path The new path. This is considered to be decoded. This
		             means: %3f does not become decoded
		             and the ? does not indicate the start of the query part.
		             Can be null to delete the path.
		   		@short    Sets the path of the URL.
	*/
	public native void setPath(String path);
	/**	
		 Test to see if this URL has a path is included in it.
				@return true if there is a path

		@short    Test to see if this URL has a path is included in it.
	*/
	public native boolean hasPath();
	/**	
		 Resolves "." and ".." components in path.
		 Some servers seem not to like the removal of extra '/'
		 even though it is against the specification in RFC 2396.
			@param cleanDirSeparator if true, occurrences of consecutive
		 directory separators (e.g. /foo//bar) are cleaned up as well.
		   		@short    Resolves ".
	*/
	public native void cleanPath(boolean cleanDirSeparator);
	public native void cleanPath();
	/**	
		 Add or remove a trailing slash to/from the path.
			@param _trailing May be ( -1, 0 +1 ). -1 strips a trailing '/', +1 adds
		                  a trailing '/' if there is none yet and 0 returns the
		                  path unchanged. If the URL has no path, then no '/' is added
		                  anyway. And on the other side: If the path is "/", then this
		                  character won't be stripped. Reason: "ftp://weis\@host" means something
		                  completely different than "ftp://weis\@host/". So adding or stripping
		                  the '/' would really alter the URL, while "ftp://host/path" and
		                  "ftp://host/path/" mean the same directory.
		   		@short    Add or remove a trailing slash to/from the path.
	*/
	public native void adjustPath(int _trailing);
	/**	
		 This is useful for HTTP. It looks first for '?' and decodes then.
		 The encoded path is the concatenation of the current path and the query.
			@param _txt the new path and query.
			@param encoding_hint MIB of original encoding of <code>_txt</code> .
				@short    This is useful for HTTP.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public native void setEncodedPathAndQuery(String _txt, int encoding_hint);
	public native void setEncodedPathAndQuery(String _txt);
	/**	
		 Sets the (already encoded) path
			@param _txt the new path
			@param encoding_hint MIB of original encoding of <code>_txt</code> .
				@short    Sets the (already encoded) path 
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public native void setEncodedPath(String _txt, int encoding_hint);
	public native void setEncodedPath(String _txt);
	/**	
		 Returns the encoded path and the query.
			@param _trailing May be ( -1, 0 +1 ). -1 strips a trailing '/', +1 adds
		                  a trailing '/' if there is none yet and 0 returns the
		                  path unchanged. If the URL has no path, then no '/' is added
		                  anyway. And on the other side: If the path is "/", then this
		                  character won't be stripped. Reason: "ftp://weis\@host" means something
		                  completely different than "ftp://weis\@host/". So adding or stripping
		                  the '/' would really alter the URL, while "ftp://host/path" and
		                  "ftp://host/path/" mean the same directory.
			@param _no_empty_path If set to true then an empty path is substituted by "/".
			@param encoding_hint MIB of desired encoding of URL.
			   		@return The concatenation if the encoded path , '?' and the encoded query.

		@short    Returns the encoded path and the query.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public native String encodedPathAndQuery(int _trailing, boolean _no_empty_path, int encoding_hint);
	public native String encodedPathAndQuery(int _trailing, boolean _no_empty_path);
	public native String encodedPathAndQuery(int _trailing);
	public native String encodedPathAndQuery();
	/**	
			@param _txt This is considered to be encoded. This has a good reason:
		 The query may contain the 0 character.
			 The query should start with a '?'. If it doesn't '?' is prepended.
			@param encoding_hint Reserved, should be 0.
				@short   
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public native void setQuery(String _txt, int encoding_hint);
	public native void setQuery(String _txt);
	/**	
		 Returns the query of the URL.
		 The query may contain the 0 character.
		 If a query is present it always starts with a '?'.
		 A single '?' means an empty query.
		 An empty string means no query.
				@return The encoded query, or null if there is none.
   
		@short    Returns the query of the URL.
	*/
	public native String query();
	/**	
		 The reference is <b>never</b> decoded automatically.
				@return the undecoded reference, or null if there is none
   
		@short    The reference is @em never decoded automatically.
	*/
	public native String ref();
	/**	
		 Sets the reference part (everything after '#').
			@param _txt The encoded reference (or null to remove it).
		   		@short    Sets the reference part (everything after '#').
	*/
	public native void setRef(String _txt);
	/**	
		 Checks whether the URL has a reference part.
				@return true if the URL has a reference part. In a URL like
         http://www.kde.org/kdebase.tar#tar:/README it would
         return true, too.
   
		@short    Checks whether the URL has a reference part.
	*/
	public native boolean hasRef();
	/**	
		 Returns the HTML reference (the part of the URL after "#").
				@return The HTML-style reference.

		@short    Returns the HTML reference (the part of the URL after "#").
		@see #split
		@see #hasSubURL
		@see #encodedHtmlRef
	*/
	public native String htmlRef();
	/**	
		 Returns the HTML reference (the part of the URL after "#") in
		 encoded form.
				@return The HTML-style reference in its original form.
   
		@short    Returns the HTML reference (the part of the URL after "#") in  encoded form.
	*/
	public native String encodedHtmlRef();
	/**	
		 Sets the HTML-style reference.
			@param _ref The new reference. This is considered to be <b>not</b> encoded in
		         contrast to setRef(). Use null to remove it.
				@short    Sets the HTML-style reference.
		@see #htmlRef
	*/
	public native void setHTMLRef(String _ref);
	/**	
		 Checks whether there is a HTML reference.
				@return true if the URL has an HTML-style reference.

		@short    Checks whether there is a HTML reference.
		@see #htmlRef
	*/
	public native boolean hasHTMLRef();
	/**	
		 Checks whether the URL is well formed.
				@return false if the URL is malformed. This function does @em not test
         whether sub URLs are well-formed, too.
   
		@short    Checks whether the URL is well formed.
	*/
	public native boolean isValid();
	/**	
		 Checks whether the file is local.
				@return true if the file is a plain local file and has no filter protocols
         attached to it.
   
		@short    Checks whether the file is local.
	*/
	public native boolean isLocalFile();
	/**	
		 Adds encoding information to url by adding a "charset" parameter. If there
		 is already a charset parameter, it will be replaced.
			@param encoding the encoding to add or null to remove the
		                 encoding.
		   		@short    Adds encoding information to url by adding a "charset" parameter.
	*/
	public native void setFileEncoding(String encoding);
	/**	
		 Returns encoding information from url, the content of the "charset"
		 parameter.
				@return An encoding suitable for QTextCodec.codecForName()
         or null if not encoding was specified.
   
		@short    Returns encoding information from url, the content of the "charset"  parameter.
	*/
	public native String fileEncoding();
	/**	
		 Checks whether the URL has any sub URLs. See split()
		 for examples for sub URLs.
				@return true if the file has at least one sub URL.

		@short    Checks whether the URL has any sub URLs.
		@see #split
	*/
	public native boolean hasSubURL();
	/**	
		 Adds to the current path.
		 Assumes that the current path is a directory. <code>_txt</code> is appended to the
		 current path. The function adds '/' if needed while concatenating.
		 This means it does not matter whether the current path has a trailing
		 '/' or not. If there is none, it becomes appended. If <code>_txt</code>
		 has a leading '/' then this one is stripped.
			@param txt The text to add. It is considered to be decoded.
		   		@short    Adds to the current path.
	*/
	public native void addPath(String txt);
	/**	
		 call the function below with encoding_hint = 0
		 (will be merged for KDE4)
		   		@short    call the function below with encoding_hint = 0  (will be merged for KDE4)
	*/
	public native String queryItem(String item);
	/**	
		 Returns the value of a certain query item.
			@param item Item whose value we want
			@param encoding_hint MIB of encoding of query.
				@return the value of the given query item name or null if the
 specified item does not exist.
   
		@short    Returns the value of a certain query item.
	*/
	public native String queryItem(String item, int encoding_hint);
	/**	
			   		@short
	*/
	// QMap<QString, QString> queryItems(int arg1); >>>> NOT CONVERTED
	// QMap<QString, QString> queryItems(); >>>> NOT CONVERTED
	/**	
		 Returns the list of query items as a map mapping keys to values.
			@param options any of QueryItemsOptions <em>or</em>ed together.
			@param encoding_hint MIB of encoding of query.
				@return the map of query items or the empty map if the url has no
 query items.

		@short    Returns the list of query items as a map mapping keys to values.
	*/
	// QMap<QString, QString> queryItems(int arg1,int arg2); >>>> NOT CONVERTED
	/**	
		 Add an additional query item.
		 To replace an existing query item, the item should first be
		 removed with removeQueryItem()
			@param _item Name of item to add
			@param _value Value of item to add
			@param encoding_hint MIB of encoding to use for _value.
				@short    Add an additional query item.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public native void addQueryItem(String _item, String _value, int encoding_hint);
	public native void addQueryItem(String _item, String _value);
	/**	
		 Remove an item from the query.
			@param _item Item to be removed
		   		@short    Remove an item from the query.
	*/
	public native void removeQueryItem(String _item);
	/**	
		 Sets the filename of the path.
		 In comparison to addPath() this function does not assume that the current
		 path is a directory. This is only assumed if the current path ends with '/'.
			 Any reference is reset.
			@param _txt The filename to be set. It is considered to be decoded. If the
		             current path ends with '/' then <code>_txt</code> int just appended, otherwise
		             all text behind the last '/' in the current path is erased and
		             <code>_txt</code> is appended then. It does not matter whether <code>_txt</code> starts
		             with '/' or not.
		   		@short    Sets the filename of the path.
	*/
	public native void setFileName(String _txt);
	/**	
		 Returns the filename of the path.
			@param _ignore_trailing_slash_in_path This tells whether a trailing '/' should
		        be ignored. This means that the function would return "torben" for
		        <tt>file:///hallo/torben/</tt> and <tt>file:///hallo/torben</tt>.
		        If the flag is set to false, then everything behind the last '/'
		        is considered to be the filename.
				@return The filename of the current path. The returned string is decoded. Null
         if there is no file (and thus no path).
   
		@short    Returns the filename of the path.
	*/
	public native String fileName(boolean _ignore_trailing_slash_in_path);
	public native String fileName();
	/**	
		 Returns the directory of the path.
			@param _strip_trailing_slash_from_result tells whether the returned result should end with '/' or not.
		                                          If the path is empty or just "/" then this flag has no effect.
			@param _ignore_trailing_slash_in_path means that <tt>file:///hallo/torben</tt> and
		                                       <tt>file:///hallo/torben/"</tt> would both return <tt>/hallo/</tt>
		                                       or <tt>/hallo</tt> depending on the other flag
				@return The directory part of the current path. Everything between the last and the second last '/'
         is returned. For example <tt>file:///hallo/torben/</tt> would return "/hallo/torben/" while
         <tt>file:///hallo/torben</tt> would return "hallo/". The returned string is decoded. null is returned when there is no path.
   
		@short    Returns the directory of the path.
	*/
	public native String directory(boolean _strip_trailing_slash_from_result, boolean _ignore_trailing_slash_in_path);
	public native String directory(boolean _strip_trailing_slash_from_result);
	public native String directory();
	/**	
		 Set the directory to <code>dir</code>, leaving the filename empty.
		   		@short    Set the directory to <code>dir</code>, leaving the filename empty.
	*/
	public native void setDirectory(String dir);
	/**	
		 Changes the directory by descending into the given directory.
		 It is assumed the current URL represents a directory.
		 If <code>dir</code> starts with a "/" the
		 current URL will be "protocol://host/dir" otherwise <code>_dir</code> will
		 be appended to the path. <code>_dir</code> can be ".."
		 This function won't strip protocols. That means that when you are in
		 file:///dir/dir2/my.tgz#tar:/ and you do cd("..") you will
		 still be in file:///dir/dir2/my.tgz#tar:/
			@param _dir the directory to change to
				@return true if successful
   
		@short    Changes the directory by descending into the given directory.
	*/
	public native boolean cd(String _dir);
	/**	
		 Returns the URL as string, with all escape sequences intact,
		 encoded in a given charset.
		 This is used in particular for encoding URLs in UTF-8 before using them
		 in a drag and drop operation.
		 Please note that the string returned by url() will include
		 the password of the URL. If you want to show the URL to the
		 user, use prettyURL().
			@param _trailing This may be ( -1, 0 +1 ). -1 strips a trailing '/' from the path, +1 adds
		                  a trailing '/' if there is none yet and 0 returns the
		                  path unchanged.
			@param encoding_hint MIB of encoding to use.
				@return The complete URL, with all escape sequences intact, encoded
 in a given charset.

		@short    Returns the URL as string, with all escape sequences intact,  encoded in a given charset.
		@see org.kde.qt.QTextCodec#mibEnum
		@see #prettyURL
	*/
	public native String url(int _trailing, int encoding_hint);
	public native String url(int _trailing);
	public native String url();
	/**	
		 Returns the URL as string in human-friendly format.
		 Example:
		 <pre>
		 http://localhost:8080/test.cgi?test=hello world&name=fred
		 </pre>
			@param _trailing -1 to strip a trailing '/' from the path, +1 adds
		                  a trailing '/' if there is none yet and 0 returns the
		                  path unchanged.
				@return A human readable URL, with no non-necessary encodings/escaped
 characters. Password will not be shown.

		@short    Returns the URL as string in human-friendly format.
		@see #url
	*/
	public native String prettyURL(int _trailing);
	public native String prettyURL();
	/**	
		 Returns the URL as string in human-friendly format.
		 Example:
		 <pre>
		 http://localhost:8080/test.cgi?test=hello world&name=fred
		 </pre>
			@param _trailing -1 to strip a trailing '/' from the path, +1 adds
		                  a trailing '/' if there is none yet and 0 returns the
		                  path unchanged.
			@param _flags if StripFileProtocol, file:// will be stripped. The use of this
		 method is now discouraged, better use pathOrURL().
				@return A human readable URL, with no non-necessary encodings/escaped
 characters. Password will not be shown.
   
		@short    Returns the URL as string in human-friendly format.
	*/
	public native String prettyURL(int _trailing, int _flags);
	/**	
		 Return the URL as a string, which will be either the URL (as prettyURL
		 would return) or, when the URL is a local file without query or ref,
		 the path.
		 Use this method, together with its opposite, fromPathOrURL(),
		 to display and even let the user edit URLs.
			@param text the string representation of the URL to convert
				@return the new KURL

		@short    Return the URL as a string, which will be either the URL (as prettyURL  would return) or, when the URL is a local file without query or ref,  the path.
	*/
	public native String pathOrURL();
	/**	
		 Returns the URL as string, escaped for HTML.
				@return A human readable URL, with no non-necessary encodings/escaped
 characters which is html encoded for safe inclusion in html or
 rich text. Password will not be shown.
   
		@short    Returns the URL as string, escaped for HTML.
	*/
	public native String htmlURL();
	/**	
		 Test to see if the KURL is empty.
				@return true if the URL is empty

		@short    Test to see if the KURL is empty.
	*/
	public native boolean isEmpty();
	/**	
		 This function is useful to implement the "Up" button in a file manager for example.
		 cd() never strips a sub-protocol. That means that if you are in
		 file:///home/x.tgz#gzip:/#tar:/ and hit the up button you expect to see
		 file:///home. The algorithm tries to go up on the right-most URL. If that is not
		 possible it strips the right most URL. It continues stripping URLs.
				@return a URL that is a level higher
   
		@short    This function is useful to implement the "Up" button in a file manager for example.
	*/
	public native KURL upURL();
	public native boolean op_lt(KURL _u);
	public native boolean op_equals(KURL _u);
	public native boolean op_equals(String _u);
	public native boolean op_not_equals(KURL _u);
	public native boolean op_not_equals(String _u);
	/**	
		 Compares this url with <code>u.</code>
			@param u the URL to compare this one with.
			@param ignore_trailing set to true to ignore trailing '/' characters.
				@return true if both urls are the same

		@short    Compares this url with <code>u.</code>
		@see #operator==#
		@see This
		@see #function
		@see #should
		@see #be
		@see #used
		@see #if
		@see #you
		@see #want
		@see #to
		@see #ignore
		@see #trailing
		@see #characters#
	*/
	public native boolean equals(KURL u, boolean ignore_trailing);
	public native boolean equals(KURL u);
	/**	
		 Checks whether the given URL is parent of this URL.
		 For instance, ftp://host/dir/ is a parent of ftp://host/dir/subdir/subsubdir/.
				@return true if this url is a parent of <code>u</code> (or the same URL as <code>u</code>)
   
		@short    Checks whether the given URL is parent of this URL.
	*/
	public native boolean isParentOf(KURL u);
	/**	
		 Splits nested URLs like file:///home/weis/kde.tgz#gzip:/#tar:/kdebase
		 A URL like http://www.kde.org#tar:/kde/README.hml#ref1 will be split in
		 http://www.kde.org and tar:/kde/README.html#ref1.
		 That means in turn that "#ref1" is an HTML-style reference and not a new sub URL.
		 Since HTML-style references mark
		 a certain position in a document this reference is appended to every URL.
		 The idea behind this is that browsers, for example, only look at the first URL while
		 the rest is not of interest to them.
			@param _url The URL that has to be split.
				@return An empty list on error or the list of split URLs.

		@short    Splits nested URLs like file:///home/weis/kde.
		@see #hasSubURL
	*/
	public static native ArrayList split(String _url);
	/**	
		 Splits nested URLs like file:///home/weis/kde.tgz#gzip:/#tar:/kdebase
		 A URL like http://www.kde.org#tar:/kde/README.hml#ref1 will be split in
		 http://www.kde.org and tar:/kde/README.html#ref1.
		 That means in turn that "#ref1" is an HTML-style reference and not a new sub URL.
		 Since HTML-style references mark
		 a certain position in a document this reference is appended to every URL.
		 The idea behind this is that browsers, for example, only look at the first URL while
		 the rest is not of interest to them.
			@param _url The URL that has to be split.
				@return An empty list on error or the list of split URLs.

		@short    Splits nested URLs like file:///home/weis/kde.
		@see #hasSubURL
	*/
	public static native ArrayList split(KURL _url);
	/**	
		 Reverses split(). Only the first URL may have a reference. This reference
		 is considered to be HTML-like and is appended at the end of the resulting
		 joined URL.
			@param _list the list to join
				@return the joined URL
   
		@short    Reverses split().
	*/
	public static native KURL join(ArrayList _list);
	/**	
		 Creates a KURL object from a String representing either an absolute path
		 or a real URL. Use this method instead of
		 <pre>
		 String someDir = ...
		 KURL url = someDir;
		 </pre>
			 Otherwise some characters (e.g. the '#') won't be encoded properly.
			@param text the string representation of the URL to convert
				@return the new KURL

		@short    Creates a KURL object from a String representing either an absolute path  or a real URL.
	*/
	public static native KURL fromPathOrURL(String text);
	/**	
		 Convenience function.
			 Convert unicoded string to local encoding and use %-style
		 encoding for all common delimiters / non-ascii characters.
			@param str String to encode (can be null).
			@param encoding_hint MIB of encoding to use.
				@return the encoded string

		@short    Convenience function.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public static native String encode_string(String str, int encoding_hint);
	public static native String encode_string(String str);
	/**	
		 Convenience function.
			 Convert unicoded string to local encoding and use %-style
		 encoding for all common delimiters / non-ascii characters
		 as well as the slash '/'.
			@param str String to encode
			@param encoding_hint MIB of encoding to use.
				@short    Convenience function.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public static native String encode_string_no_slash(String str, int encoding_hint);
	public static native String encode_string_no_slash(String str);
	/**	
		 Convenience function.
			 Decode %-style encoding and convert from local encoding to unicode.
			 Reverse of encode_string()
			@param str String to decode (can be null).
			@param encoding_hint MIB of original encoding of <code>str</code> .
				@short    Convenience function.
		@see org.kde.qt.QTextCodec#mibEnum
	*/
	public static native String decode_string(String str, int encoding_hint);
	public static native String decode_string(String str);
	/**	
		 Convenience function.
			 Returns whether '_url' is likely to be a "relative" URL instead of
		 an "absolute" URL.
			@param _url URL to examine
				@return true when the URL is likely to be "relative", false otherwise.
   
		@short    Convenience function.
	*/
	public static native boolean isRelativeURL(String _url);
	/**	
		 Convenience function
			 Returns a "relative URL" based on <code>base_url</code> that points to <code>url.</code>
			 If no "relative URL" can be created, e.g. because the protocol
		 and/or hostname differ between <code>base_url</code> and <code>url</code> an absolute
		 URL is returned.
		 Note that if <code>base_url</code> represents a directory, it should contain
		 a trailing slash.
			@param base_url the URL to derive from
			@param url new URL
			@param encoding_hint MIB of original encoding of <code>str</code> .
				@short    Convenience function 
		@see org.kde.qt.QTextCodec#mibEnum
		@see #adjustPath
	*/
	public static native String relativeURL(KURL base_url, KURL url, int encoding_hint);
	public static native String relativeURL(KURL base_url, KURL url);
	/**	
		 Convenience function
			 Returns a relative path based on <code>base_dir</code> that points to <code>path.</code>
			@param base_dir the base directory to derive from
			@param path the new target directory
			@param isParent A pointer to a booleanean which, if provided, will be set to reflect
		 whether <code>path</code> has <code>base_dir</code> is a parent dir.
		   		@short    Convenience function
	*/
	public static native String relativePath(String base_dir, String path, boolean[] isParent);
	public static native String relativePath(String base_dir, String path);
	/**	
		 Determine which URI mode is suitable for processing URIs of a given protocol.
			@param protocol The protocol name.
				@short    Determine which URI mode is suitable for processing URIs of a given protocol.
	*/
	public static native int uriModeForProtocol(String protocol);
	protected native void reset();
	protected native void parseURL(String _url, int encoding_hint);
	protected native void parseURL(String _url);
	protected native void parseRawURI(String _url, int encoding_hint);
	protected native void parseRawURI(String _url);
	protected native void parseMailto(String _url, int encoding_hint);
	protected native void parseMailto(String _url);
	protected native void parse(String _url, int encoding_hint);
	protected native void parse(String _url);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
