/* This file is part of the KDE project
   Copyright (C) 2002 Carsten Pfeiffer <pfeiffer@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include <qlayout.h>

#include <kaboutdata.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kgenericfactory.h>

#include "kcmkmrml.h"
#include <dcopclient.h>

#include "mainpage.h"
#include <version.h>

using namespace KMrmlConfig;

static const int COL_FILENAME = 1;

typedef KGenericFactory<KCMKMrml, QWidget> MrmlFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kmrml, MrmlFactory("kmrml") )

KCMKMrml::KCMKMrml(QWidget *parent, const char *name, const QStringList & ):
    KCModule(MrmlFactory::instance(), parent, name)
{
    QVBoxLayout *layout = new QVBoxLayout( this );
    layout->setSpacing( KDialog::spacingHint() );
    m_mainPage = new MainPage( this, "main page" );

    layout->addWidget( m_mainPage );

    connect( m_mainPage, SIGNAL( changed( bool ) ), SIGNAL( changed( bool )));

    load();
}

KCMKMrml::~KCMKMrml()
{
}


void KCMKMrml::defaults()
{
    if (KMessageBox::warningContinueCancel(this,
         i18n("Do you really want the configuration to be reset "
              "to the defaults?"), i18n("Are you sure?"), i18n("Continue"))
        != KMessageBox::Continue)
        return;

    m_mainPage->resetDefaults();

    emit changed( true );
}

void KCMKMrml::load()
{
    m_mainPage->load();

    emit changed( true );
}

void KCMKMrml::save()
{
    m_mainPage->save();

    emit changed( false );
}

QString KCMKMrml::quickHelp() const
{
    return i18n("<h1>Image Index</h1>"
                "KDE can make use of the GNU Image Finding Tool (GIFT) to "
                "perform queries based not just on filenames, but on "
                "file content."
                "<p>E.g. you can search for an image by giving an example "
                "image, that looks similar to the one you are looking for.</p>"
                "<p>For that to work, your image directories need to be "
                "indexed by the GIFT server, for example.</p>"
                "<p>Here you can configure the servers (you can also query "
                "remote servers) and the directories to index.</p>"
        );
}

const KAboutData *KCMKMrml::aboutData() const
{
    static KAboutData* ab = 0;

    if(!ab)
    {
        ab = new KAboutData(
            "kcmkmrml",
            I18N_NOOP("KCMKMrml"),
            KMRML_VERSION,
            I18N_NOOP("Advanced Search Control Module"),
            KAboutData::License_GPL,
            I18N_NOOP( "Copyright 2002, Carsten Pfeiffer" ),
            0,
            "http://devel-home.kde.org/~pfeiffer/kmrml/" );
        ab->addAuthor( "Carsten Pfeiffer", 0, "pfeiffer@kde.org" );
    }

    return ab;
}

#include "kcmkmrml.moc"
