/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmnormal.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmnormaledit.h"
#include "pmlistpattern.h"
#include "pmpattern.h"

#include <klocale.h>

const double bumpSizeDefault = 0.0;
const double accuracyDefault = 0.02;

PMDefinePropertyClass( PMNormal, PMProperty );

PMMetaObject* PMNormal::s_pMetaObject = 0;
PMObject* createNewNormal( PMPart* part )
{
   return new PMNormal( part );
}

PMNormal::PMNormal( PMPart* part )
      : Base( part )
{
   m_enableBumpSize = false;
   m_bumpSize = bumpSizeDefault;
   m_accuracy = accuracyDefault;
}

PMNormal::PMNormal( const PMNormal& n )
      : Base( n )
{
   m_enableBumpSize = n.m_enableBumpSize;
   m_bumpSize = n.m_bumpSize;
   m_accuracy = n.m_accuracy;
}

PMNormal::~PMNormal( )
{
}

PMMetaObject* PMNormal::metaObject( ) const
{
   if( !s_pMetaObject )
   {
      s_pMetaObject = new PMMetaObject( "Normal", Base::metaObject( ),
                                        createNewNormal );
      s_pMetaObject->addProperty(
         new PMProperty( "bumpSize", &PMNormal::setBumpSize, &PMNormal::bumpSize ) );
      s_pMetaObject->addProperty(
         new PMProperty( "bumpSizeEnabled", &PMNormal::enableBumpSize, &PMNormal::isBumpSizeEnabled ) );
      s_pMetaObject->addProperty(
         new PMProperty( "accuracy", &PMNormal::setAccuracy, &PMNormal::accuracy ) );
   }
   return s_pMetaObject;
}

void PMNormal::cleanUp( ) const
{
   if( s_pMetaObject )
   {
      delete s_pMetaObject;
      s_pMetaObject = 0;
   }
   Base::cleanUp( );
}

QString PMNormal::description( ) const
{
   return i18n( "normal" );
}

void PMNormal::serialize( QDomElement& e, QDomDocument& doc ) const
{
   Base::serialize( e, doc );
   e.setAttribute( "enable_bump_size", m_enableBumpSize );
   e.setAttribute( "bump_size", m_bumpSize );
   e.setAttribute( "accuracy", m_accuracy );
}

void PMNormal::readAttributes( const PMXMLHelper& h )
{
   Base::readAttributes( h );
   m_enableBumpSize = h.boolAttribute( "enable_bump_size", false );
   m_bumpSize = h.doubleAttribute( "bump_size", bumpSizeDefault );
   m_accuracy = h.doubleAttribute( "accuracy", accuracyDefault );
}

PMDialogEditBase* PMNormal::editWidget( QWidget* parent ) const
{
   return new PMNormalEdit( parent );
}

void PMNormal::enableBumpSize( bool c )
{
   if( c != m_enableBumpSize )
   {
      if( m_pMemento )
         m_pMemento->addData( s_pMetaObject, PMEnableBumpSizeID, m_enableBumpSize );
      m_enableBumpSize = c;
   }
}

void PMNormal::setBumpSize( double c )
{
   if( c != m_bumpSize )
   {
      if( m_pMemento )
         m_pMemento->addData( s_pMetaObject, PMBumpSizeID, m_bumpSize );
      m_bumpSize = c;
   }
}

void PMNormal::setAccuracy( double c )
{
   if( c!= m_accuracy )
   {
      if ( m_pMemento )
         m_pMemento->addData( s_pMetaObject, PMAccuracyID, m_accuracy );
      m_accuracy = c;
   }
}

void PMNormal::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == s_pMetaObject )
      {
         switch( data->valueID( ) )
         {
            case PMEnableBumpSizeID:
               enableBumpSize( data->boolData( ) );
               break;
            case PMBumpSizeID:
               setBumpSize( data->doubleData( ) );
               break;
            case PMAccuracyID:
               setAccuracy( data->doubleData( ) );
            default:
               kdError( PMArea ) << "Wrong ID in PMNormal::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}

