/***************************************************************************
                          stuff.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "stuff.h"
#include <qdir.h>
#include <qfile.h>
#include <qstringlist.h>
#include <arts/artsflow.h>
#include <arts/connect.h>
#include <arts/iomanager.h>
#include <arts/referenceclean.h>
#include <iostream>
#include <string>
#include <klocale.h>
#include <kprocio.h>
#include <kdebug.h>
#include <qstring.h>
#include <arpa/inet.h>

extern "C" {
#include <iwlib.h>
}

int operator == (const deviceinfo & eins, const deviceinfo & zwei) {

/*	There are several levels of difference, enumerated with integers:
	0		no difference
	1		strength different
    2		status different
	4		operation mode different
	8		connection speed different
*/
  int result = 0;
  if (eins.bitrate.value != zwei.bitrate.value)
    result += 8;
  if ((eins.has_mode != zwei.has_mode) || (eins.mode != zwei.mode))
    result += 4;
  char stupid[255];
  if ((eins.essid != zwei.essid) || (iw_pr_ether (stupid,(unsigned char *) eins.ap_addr.sa_data) != iw_pr_ether (stupid,(unsigned char *) zwei.ap_addr.sa_data)) || (eins.freq != zwei.freq) || (eins.ip_addr != zwei.ip_addr) || (eins.has_key !=zwei.has_key) || (eins.key_size!=zwei.key_size)||(eins.key_flags!=zwei.key_flags))
    result += 2;
  if ((eins.qual.qual != zwei.qual.qual) || (eins.has_freq != zwei.has_freq))
    result += 1;
  return result;
}

Interface_Talker::Interface_Talker(QString iface){
    device_information.has_frequency=false;
    device_information.frequency=0.;
    device_information.has_mode=false;
    device_information.mode=0;
    device_information.has_key=0;
    device_information.key="";
    device_information.key_size=0;
    device_information.key_flags=0;
    device_information.essid="";
    device_information.access_point_address="";
    device_information.ip_address="";
    device_information.bitrate=0.;
    device_information.interface_name=iface;
    device_information.socket=-1;
    device_information.has_range=false;
    for (int i=0;i<MAX_HISTORY;i++) {
      statistical_data.sigLevel[i]=0;
      statistical_data.noiseLevel[i]=0;
      statistical_data.qual[i]=0;
      statistical_data.valid[i]=false;
      statistical_data.current=0;
    }
}

int Interface_Talker_wirelessextensions::open_device_socket() {
  device_information.socket = iw_sockets_open();
  return device_information.socket;
}

void Interface_Talker_wirelessextensions::poll_device_info(){
  kdDebug() << "unimplemented\n";
}

bool Interface_Talker_wirelessextensions::give_device_freq(float &freq){
  kdDebug() << "unimplemented\n";
  return false;
}

bool Interface_Talker_wirelessextensions::give_mode(int &mode){
  kdDebug() << "unimplemented\n";
  return false;
}

bool Interface_Talker_wirelessextensions::give_key(QString &key,int size,int flags){
  kdDebug() << "unimplemented\n";
  return false;
}

QString Interface_Talker_wirelessextensions::give_essid(){
  kdDebug() << "unimplemented\n";
  return "";
}

bool Interface_Talker_wirelessextensions::give_AP_info(QString &mac, QString &ip){
  kdDebug() << "unimplemented\n";
  return false;
}

double Interface_Talker_wirelessextensions::give_bitrate(){
  kdDebug() << "unimplemented\n";
  return 0.;
}

QString Interface_Talker_wirelessextensions::give_interface_name(){
  kdDebug() << "unimplemented\n";
  return "";
}

bool Interface_Talker_wirelessextensions::give_current_quality(int &sig, int &noi, int &qua){
  kdDebug() << "unimplemented\n";
  return false;
}

void
sinus_wave (double frequency)
{
  using namespace Arts;
  StdIOManager *limiter = new StdIOManager;
  Dispatcher dispatcher (limiter);
  MyTimeNotify *zeit = new MyTimeNotify (&dispatcher);
  Synth_FREQUENCY freq;
  Synth_WAVE_SIN sin;
  Synth_PLAY play;
  setValue (freq, frequency);
  connect (freq, sin);
  connect (sin, play, "invalue_left");
  freq.start ();
  sin.start ();
  play.start ();
  limiter->addTimer (250, zeit);
  dispatcher.run ();
  play.stop ();
  sin.stop ();
  freq.stop ();
}

void
MyTimeNotify::notifyTime ()
{
  test->terminate ();
}

QString
whois (char *MAC_ADR, QStringList APList)
{
  for (QStringList::Iterator it = APList.begin (); it != APList.end (); (it++)++)
    {
      if ((*it) == (QString) MAC_ADR)
	return *(++it);
    }
  return i18n ("UNKNOWN");
}
