#ifndef KBB_BUGJOB_H
#define KBB_BUGJOB_H

#include <kio/jobclasses.h>

#include "bugserver.h"

class BugJob : public KIO::Job
{
    Q_OBJECT
  public:
    BugJob( BugServer * );
    virtual ~BugJob();

    BugServer *server() const { return mServer; }

  signals:
    void infoMessage( const QString &text );
    void infoPercent( unsigned long percent );
    void error( const QString &text );
    void jobEnded( BugJob * );

  protected:
    void start( const KUrl &url /*, const KParts::URLArgs &args = KParts::URLArgs()*/ );

    virtual void process( const QByteArray &data ) = 0;

  private slots:
    void ioResult( KJob *job );

    void ioData( KIO::Job *job, const QByteArray &data );

    void ioInfoMessage( KJob *job, const QString &text, const QString & );

    void ioInfoPercent( KJob *job, unsigned long percent );

  private:
    QByteArray m_data;
    BugServer *mServer;
};

#endif
/*
 * vim:sw=4:ts=4:et
 */
