#include "prefsDialog.h"
#include "prefdialogdata.h"
#include "serviceconfigdata.h"

#include <qimage.h>

#include <kfiledialog.h>
#include <klineedit.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kfontdialog.h>
#include <klocale.h>
#include <knuminput.h>
#include <kurlrequester.h>
#include <qvbox.h>
#include <kiconloader.h>
#include <kurlrequester.h>
#include <kpushbutton.h>
#include <klistbox.h>
#include <qbuttongroup.h>
#include <qstringlist.h>
#include <dcopclient.h>
#include <dcopref.h>

prefsDialog::prefsDialog (QWidget* parent, const char* name)
	:KDialogBase(IconList, i18n("KWeather Preferences"),
		Help|Ok|Cancel, Ok, parent, name, false, true)
{
	setHelp( "kweather/index.html", QString::null ); // When Help is pressed
	centerOnScreen( this );

//	setMainWidget(view);
	QVBox *page = addVBoxPage( i18n("Display"),
		i18n("Display Setup"), BarIcon("configure"));
		view = new prefsDialogData(page);
	page = addVBoxPage(i18n("Weather Service"),
		i18n("Weather Service Setup"), BarIcon("connect_creating"));
		wsView =  new wsPrefs(page);

	connect(view->ICAOlink, SIGNAL(leftClickedURL(const QString&)), 
        SLOT(processURL(const QString&)));
	connect(view->m_enableLog, SIGNAL(toggled(bool)), 
        SLOT(enableLogWidgets(bool)));
	connect(view->m_viewMode, SIGNAL(released(int)), SLOT(changeView(int)));

	connect(wsView->add, SIGNAL(released()), SLOT(addStation()));
	connect(wsView->remove, SIGNAL(released()), SLOT(removeStation()));

	connect(wsView->update, SIGNAL(released()), SLOT(updateStations()));
	connect(wsView->exit, SIGNAL(released()), SLOT( exitWS()));

	scanStations();
}

prefsDialog::~prefsDialog()
{
}

void prefsDialog::changeView(int _mode)
{
	mode = _mode;
}

/** Get the report location string. */
QString prefsDialog::reportLocation() const {
    return view->m_reportLocation->text();
}


int prefsDialog::viewMode() const {
	kdDebug() << "mode " << mode << endl;
    return mode;
}

void prefsDialog::setViewMode(int _mode)
{
	view->m_viewMode->setButton(_mode);
	changeView(_mode);
}

QString prefsDialog::logFile() const {
    return view->m_logFile->url();
}

/** Set the pref box file name to the current prefs file name. */
void prefsDialog::setLogFile( QString s ){
    view->m_logFile->setURL(s);
}

/** The current report location */
void prefsDialog::setReportLocation( QString s ){
   view->m_reportLocation->setText( s );
}

/** Open Konqueror to this link. */
void prefsDialog::processURL(const QString& url){
    kapp->invokeBrowser( url );
}

void prefsDialog::enableLogWidgets(bool b)
{
    view->m_logFile->setEnabled(b);
    view->m_labelLogFile->setEnabled(b);
}

bool prefsDialog::enableLog() const
{
    return view->m_enableLog->isChecked();
}

void prefsDialog::setEnableLog(bool b)
{
    view->m_enableLog->setChecked ( b );
    enableLogWidgets( b );
}

bool prefsDialog::dcopActive()
{
	QString error;
	QCString appID;
	bool isGood = true;
	DCOPClient *client = kapp->dcopClient();
	kdDebug( 12004 ) << "Looking for dcop service..." << endl;
	if (!client->isApplicationRegistered("KWeatherService"))
	{
		kdDebug( 12004 ) << "Could not find service so I am starting it..." << endl;
		if(KApplication::startServiceByDesktopName("kweatherservice",QStringList(), &error, &appID ))
		{
			kdDebug( 12004 ) << "Starting dcopservice failed with message: " << error << endl;
			isGood = false;
		}
	}

	return isGood;
}

void prefsDialog::addStation()
{
	if (dcopActive())
	{
		DCOPRef service("KWeatherService", "WeatherService");
		service.call("addStation(QString )",wsView->station->text() );
		wsView->station->clear();
		scanStations();
	}
}

void prefsDialog::removeStation()
{
	if (dcopActive())
	{
		DCOPRef service("KWeatherService", "WeatherService");
		service.call("removeStation(QString)", wsView->stationList->currentText() );
		scanStations();
	}
}

void prefsDialog::updateStations()
{
	if (dcopActive())
	{
		DCOPRef service("KWeatherService", "WeatherService");
		service.call("updateAll()" );
		scanStations();
	}
}

void prefsDialog::exitWS()
{
	if (dcopActive())
	{
		DCOPRef service("KWeatherService", "WeatherService");
		service.call("exit()" );
	}
}

void prefsDialog::scanStations()
{
	if (dcopActive())
	{
		DCOPRef service("KWeatherService", "WeatherService");
		QStringList lst = service.call("listStations()");
		wsView->stationList->clear();
		for( unsigned int idx = 0; idx < lst.size(); idx++)
		{
			QPixmap pix = service.call("icon(QString)", lst[idx]);
			QImage img = pix.convertToImage();
			img = img.smoothScale( 22, 22 );
			pix.convertFromImage( img );
			wsView->stationList->insertItem(pix, lst[idx]);
		}
	}
}
#include "prefsDialog.moc"
