/***************************************************************************
                           colourinversion.cpp
                           -------------------
    begin                : Sat Jul 31 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * Colour Inversion algorithm taken from DScaler.
 * Copyright (c) 2000 TM. All rights reserved.
 *
 * Ported by: Dirk Ziegelmeier
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>

#include "colourinversion.h"
#include "kdetvimagefilter.h"
#include "kdetvimagefiltercontext.h"

class ColourInversionImageFilter : public KdetvImageFilter
{
public:
    ColourInversionImageFilter()
        : KdetvImageFilter(i18n("ColorInversion"))
    {
    }

    virtual ~ColourInversionImageFilter()
    {
    }

    virtual KdetvImageFilterContext* operator<< (KdetvImageFilterContext* ctx)
    {
        short* Pixels;
        int fieldHeight = ctx->out->size().height();
        int Cycles      = ctx->out->bytesPerLine() / 2;
        int inputPitchH = (ctx->out->bytesPerLine() + ctx->out->stride()) / 2;

        for (int y=0; y<fieldHeight; ++y) {
            Pixels = (short*)ctx->out->buffer() + y*inputPitchH;
            for (int x=0; x<Cycles; x++) {
                *Pixels = 255 - *Pixels;
                Pixels++;
            }
        }

        return ctx;
    }

    virtual KdetvImage::ImageFormat inputFormats()
    {
        return KdetvImage::FORMAT_YUYV;
    };
};

// -----------------------------------------------------------------------

ColourInversionPlugin::ColourInversionPlugin(Kdetv *ktv, const QString& cfgkey, QObject *parent, const char* name)
    : KdetvFilterPlugin(ktv, cfgkey, parent, name)
{
    _filter = new ColourInversionImageFilter();
}

ColourInversionPlugin::~ColourInversionPlugin()
{
    delete _filter;
}

extern "C" {
    ColourInversionPlugin* create_colourinversion(Kdetv* ktv)
    {
        return new ColourInversionPlugin(ktv, "colourinversion", 0, "ColourInversion");
    }
}

#include "colourinversion.moc"
