/*
 * Copyright <year> Milian Wolff <mail@milianw.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License or (at your option) version 3 or any later version
 * accepted by the membership of KDE e.V. (or its successor approved
 * by the membership of KDE e.V.), which shall act as a proxy
 * defined in Section 14 of version 3 of the license.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "quickopentestbase.h"

#include <tests/autotestshell.h>
#include <tests/testcore.h>
#include <tests/testplugincontroller.h>
#include <tests/testproject.h>
#include <interfaces/idocumentcontroller.h>
#include <language/interfaces/quickopenfilter.h>

using namespace KDevelop;

QuickOpenTestBase::QuickOpenTestBase(Core::Setup setup_, QObject* parent)
: QObject(parent)
, core(nullptr)
, setup(setup_)
, projectController(nullptr)
{
    qRegisterMetaType<QModelIndex>("QModelIndex");
}

void QuickOpenTestBase::initTestCase()
{
    AutoTestShell::init();
    core = new TestCore;
    TestPluginController* pluginController = new TestPluginController(core);
    core->setPluginController(pluginController);
    TestCore::initialize(setup);
    projectController = new TestProjectController(core);
    delete core->projectController();
    core->setProjectController(projectController);
}

void QuickOpenTestBase::cleanupTestCase()
{
    TestCore::shutdown();
}

void QuickOpenTestBase::cleanup()
{
    projectController->closeAllProjects();
    core->documentController()->closeAllDocuments();
}

TestProject* getProjectWithFiles(int files)
{
    TestProject* project = new TestProject;
    ProjectFolderItem* foo = createChild<ProjectFolderItem>(project->projectItem(), QStringLiteral("foo"));
    ProjectFolderItem* bar = createChild<ProjectFolderItem>(foo, QStringLiteral("bar"));
    for(int i = 0; i < files; ++i) {
        createChild<ProjectFileItem>(bar, QString::number(i) + QLatin1String(".txt"));
    }
    return project;
}

QStringList items(const ProjectFileDataProvider& provider)
{
    QStringList list;
    for(uint i = 0; i < provider.itemCount(); ++i) {
        list << provider.data(i)->text();
    }
    return list;
}
