#include "configdialogprivate.h"

ConfigDialogPrivate::ConfigDialogPrivate(QWidget *parent)
    :QDialog(parent)
{
    QVBoxLayout *l = new QVBoxLayout(this);
    setSizePolicy(QSizePolicy(QSizePolicy::MinimumExpanding,
                QSizePolicy::MinimumExpanding));
    setMinimumWidth(400); // TODO no magic numbers
    setMinimumHeight(400);
    hide();
    configWidget = new XsldbgConfigImpl(this);
    Q_CHECK_PTR( configWidget );
    l->addWidget(configWidget);
    QDialogButtonBox *bb = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel,
            Qt::Horizontal, this);
    l->addWidget(bb);
    connect(bb, SIGNAL(accepted()), this, SLOT(apply()));
    connect(bb, SIGNAL(rejected()), this, SLOT(cancel()));
}


void ConfigDialogPrivate::apply()
{
    if (isVisible()) {
        configWidget->slotApply();
        hide();
    }
}



void ConfigDialogPrivate::cancel()
{
    if (isVisible()) {
        configWidget->slotCancel();
        hide();
    }
}

ConfigDialogPrivate::~ConfigDialogPrivate()
{
}

void ConfigDialogPrivate::show()
{
    QDialog::show();
    configWidget->setModel(optionDataModel());
    configWidget->show();
}

#include "configdialogprivate.moc"
