/**
   File : qxsldbgdoc.cpp
   Author : Keith Isdale
   Date : 19th April 2002
   Description : The document to handle source and breakpoints
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ************************************************************************* */

#include "qxsldbgdoc.h"
#include <ktexteditor/markinterface.h>
#include <ktexteditor/editorchooser.h>
#include <QFile>
#include <QDir>
#include <QTextStream>

QXsldbgDoc::QXsldbgDoc(QWidget *parent, KUrl url)
    : QObject(0L), kDoc(0L), locked(false) 
{
	KTextEditor::Editor *editor = KTextEditor::EditorChooser::editor();


    kDoc = editor->createDocument( 0L);
    connect(kDoc, SIGNAL(started(KIO::Job *)), this, SLOT(lockDoc()));
    connect(kDoc, SIGNAL(completed()), this, SLOT(unlockDoc()));
    if (kDoc){
	(void*)kDoc->createView(parent);// "QXsldbgDocView");
	KUrl cleanUrl;
	// convert paths relative to PWD into a absolute path
	QString relUrl = url.prettyUrl();
	if (!relUrl.contains(":/")){
	    if (!(relUrl.left(1) == "/"))
		relUrl.prepend(QDir::currentPath() + '/');
	    cleanUrl.setFileName(relUrl); 
	}else{
	    cleanUrl = url; 
	}
	kDoc->openUrl(cleanUrl);
    }
}

KTextEditor::View *QXsldbgDoc::kateView()
{
    if (kDoc)
        return kDoc->activeView();
    else 
        return 0;
}

void QXsldbgDoc::close()
{
    /*
    if (kDoc){
        kDoc->closeUrl(false);	
        delete kDoc;
        kDoc = 0;
    }
    */
}

QXsldbgDoc::~QXsldbgDoc()
{
   close();
}

void QXsldbgDoc::slotResult( KJob *job )
{
    if ( job->error() != 0 ){
    }else{
    }
    emit docChanged();
}

KUrl QXsldbgDoc::url() const
{
    if (kDoc)
	return kDoc->url();
    else
	return KUrl();
}

void QXsldbgDoc::refresh()
{
    if (kDoc){
	KUrl lastUrl = kDoc->url();	
	kDoc->closeUrl(false);
	kDoc->openUrl(lastUrl);
    }
}


void QXsldbgDoc::enableBreakPoint(uint lineNumber, bool state)
{
    if (locked)
	return;

    KTextEditor::MarkInterface *markIf =qobject_cast<KTextEditor::MarkInterface*>(kDoc);
    if (markIf){
	if (state){
	    markIf->removeMark(lineNumber, KTextEditor::MarkInterface::BreakpointDisabled);
	    markIf->addMark(lineNumber, KTextEditor::MarkInterface::BreakpointActive);
	}else{
	    markIf->removeMark(lineNumber, KTextEditor::MarkInterface::BreakpointActive);
	    markIf->addMark(lineNumber, KTextEditor::MarkInterface::BreakpointDisabled);
	}
    }
}

void QXsldbgDoc::addBreakPoint(uint lineNumber)
{
    enableBreakPoint(lineNumber, true);    
}

void QXsldbgDoc::deleteBreakPoint(uint lineNumber)
{
    if (locked)
	return;

    KTextEditor::MarkInterface *markIf =qobject_cast<KTextEditor::MarkInterface*>(kDoc);
    if (markIf){
	    markIf->removeMark(lineNumber, KTextEditor::MarkInterface::BreakpointDisabled);
	    markIf->removeMark(lineNumber, KTextEditor::MarkInterface::BreakpointActive);
    }
}


void QXsldbgDoc::selectBreakPoint(uint lineNumber)
{
    if (locked)
	return;

    lineNumber--;
    KTextEditor::MarkInterface *markIf =qobject_cast<KTextEditor::MarkInterface*>(kDoc);
    if (markIf && kateView()){
	int oldLineNo = kateView()->cursorPosition().line();
	markIf->removeMark(oldLineNo, KTextEditor::MarkInterface::Execution);
	markIf->addMark(lineNumber, KTextEditor::MarkInterface::Execution);
    }
}

void QXsldbgDoc::lockDoc()
{
    locked = true;
}

void QXsldbgDoc::unlockDoc()
{
    locked = false;
}
#include "qxsldbgdoc.moc"
