/**
   File : xsldbginspector.h
   Author : Keith Isdale
   Date : 30th March 2002
   Description : Dialog to inspect stylesheet using xsldbg. Based on
                  file created by uic
*/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ************************************************************************* */

#ifndef XSLDBGINSPECTOR_H
#define XSLDBGINSPECTOR_H

#include <QVariant>
#include <QDialog>
class QBoxLayout;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QListBox;
class QListBoxItem;
class QPushButton;
class QTabWidget;
class QWidget;
class KPushButton;

class XsldbgDebugger;
class XsldbgBreakpointsImpl;
class XsldbgVariablesImpl;
class XsldbgCallStackImpl;
class XsldbgTemplatesImpl;
class XsldbgSourcesImpl;
class XsldbgEntitiesImpl;

class XsldbgInspector : public QDialog
{
    Q_OBJECT

public:
    explicit XsldbgInspector( XsldbgDebugger *debugger, QWidget* parent = 0, bool modal = false);
    ~XsldbgInspector();

    QTabWidget* tabWidget;
    KPushButton* buttonOk;
    KPushButton* buttonCancel;


public slots:
   void accept();
   void reject();
   void refresh();
   void show();
   void refreshBreakpoints();
   void refreshVariables();


protected:
    QGridLayout* XsldbgInspectorLayout;
    QBoxLayout* Layout1;
    XsldbgDebugger *debugger;
    XsldbgBreakpointsImpl *breakpointWidget;
    XsldbgVariablesImpl *variablesWidget;
    XsldbgCallStackImpl *callStackWidget;
    XsldbgTemplatesImpl *templateWidget;
    XsldbgSourcesImpl *sourceWidget;
    XsldbgEntitiesImpl *entityWidget;
};

#endif // XSLDBGINPECTOR_H
