/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DCANVASITEM_H
#define _DCANVASITEM_H

#include <qcanvas.h>
#include <qmap.h>

#include "DDataControl.h"
#include "DItem.h"
#include "DGuiItem.h"

class DDataItem;
class QPoint;
class QPainter;
class DCanvasView;
class DCanvasLink;
class DCanvasPos;
class DCanvasRef;
class DCanvasFlag;
class DRefRecord;
/**
 * This class handles the canvas view for the mindmap items
 *
 * @short Mindmap item view
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DCanvasItem : public QCanvasRectangle, public DGuiItem
{
	public:
		DCanvasItem(DCanvasView *, int id);
		virtual ~DCanvasItem();	

		void setOffset(const QPoint &);

		bool onWidget(const QPoint & p);
		bool displayChildIdx() const;

		void setDisplayIdx(bool);
		void setSelected(bool b = true);

		void setSize( int , int );

		void move(double, double);
		void moveOffset(const QPoint &);

		virtual void updatePos();
		void updateLink();
		void updateRefs();
		void loadPos();

		// order of the item related to its parent
		int numChild();

		// expand the tree
		void expandSubtree(double aStart, double aEnd);
		void setPosition(int x, int y, bool side);

		int rtti() const;
		static const int Rtti_DCanvasItem = 31337;

		int m_vecX;
		int m_vecY;
		int sizeH();

		// backup the old position
		int m_xbackup;
		int m_ybackup;

		void addRef(int dest);
		void rmRef(int dest);

		const DDataControl* control();

		static void updateRefColor();

	private:
		QPoint m_pressOffset;

		DCanvasView* m_canvasview;
		DCanvasLink* m_link;
		DCanvasPos* m_pos;
		bool m_displaychildidx;

		double m_angle;
		int m_lastupdate;

		QMap<int, DCanvasFlag*> m_flagmap;

	protected:
		virtual void drawShape(QPainter &p);
		void updateFlagPos();

		QValueList<DCanvasRef*> m_references;

		static QValueList<DRefRecord*> s_allreferences;

		QPixmap m_displayedpix;
		//int m_pressXOffset, m_pressYOffset;
		//int m_oldX, m_oldY;
};

#endif // _DCANVASITEM_H

