/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <kiconloader.h>
#include <klocale.h>

#include "settings.h"
#include "DCanvasView.h"
#include "DCanvasPopup.h"
#include "DDataControl.h"

DCanvasPopup::DCanvasPopup(QWidget *parent) : KPopupMenu(parent)
{
	m_canvas = (DCanvasView*) parent;

	// new object on the canvas / canvas manipulation
	insertItem(i18n("New item"), e_item);

	// edit actions
	if ( m_canvas->itemsAreSelected() )
	{
		insertSeparator();
		insertItem(i18n("Delete"), e_delete);

		insertSeparator();
	}

	// disconnect actions
	KPopupMenu *disc_pop = new KPopupMenu(this, i18n("Disconnect"));

	// disc_pop ~ disconnect popup :)

	disc_pop->insertItem(i18n("Parent"), e_discon_parent);
	disc_pop->insertItem(i18n("Object(s)"), e_discon_obj);
	disc_pop->insertItem(i18n("Subtree"), e_discon_subtree);
	if (m_canvas->selectedRef())
		disc_pop->insertItem(i18n("Reference"), e_discon_link);
	else if (m_canvas->selectedLink())
		disc_pop->insertItem(i18n("Link"), e_discon_link);

	insertItem( i18n("Disconnect"), disc_pop);

	if (disc_pop)
		connect(disc_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	if (m_canvas->oneItemIsSelected())
	{
		DDataItem *item = m_canvas->dataTree()->singleSelection();
		if (item) setItemEnabled(e_discon_parent, item->Parent() != DItem::NOITEM );
	}
	setItemEnabled(e_discon_subtree, m_canvas->oneItemIsSelected());
	setItemEnabled(e_discon_obj, m_canvas->itemsAreSelected());

	disc_pop->setEnabled( m_canvas->itemsAreSelected() || m_canvas->selectedRef() || m_canvas->selectedLink() );

	insertSeparator();

	// tydy actions

	KPopupMenu *tidy_pop = new KPopupMenu(this, i18n("Tidy"));

	tidy_pop->insertItem(i18n("Quick reorganization"), e_tidy_clean);
	tidy_pop->insertItem(i18n("Smart reorganization (tm)"), e_tidy_all);
	tidy_pop->insertItem(i18n("Unclutter the mindmap"), e_tidy_unclutter);


	insertItem( i18n("Tidy"), tidy_pop);
	connect(tidy_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	tidy_pop->setEnabled(true);
	//tidy_pop->setItemEnabled(e_tidy_unclutter, false);
	insertSeparator();

	//insertItem(i18n("Colors"), e_color);
	//setItemEnabled(e_color, m_canvas->itemsAreSelected() );

	KPopupMenu *col_pop = new KPopupMenu(this, i18n("Colors"));

	col_pop->insertItem(i18n("Default color"), Settings::EnumColorMode::default_);
	if (Settings::annotation(Settings::EnumColorMode::theme1_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme1_), Settings::EnumColorMode::theme1_);
	else
		col_pop->insertItem(i18n("Theme 1"), Settings::EnumColorMode::theme1_);

	if (Settings::annotation(Settings::EnumColorMode::theme2_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme2_), Settings::EnumColorMode::theme2_);
	else
		col_pop->insertItem(i18n("Theme 2"), Settings::EnumColorMode::theme2_);

	if (Settings::annotation(Settings::EnumColorMode::theme3_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme3_), Settings::EnumColorMode::theme3_);
	else
		col_pop->insertItem(i18n("Theme 3"), Settings::EnumColorMode::theme3_);

	if (Settings::annotation(Settings::EnumColorMode::theme4_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme4_), Settings::EnumColorMode::theme4_);
	else
		col_pop->insertItem(i18n("Theme 4"), Settings::EnumColorMode::theme4_);

	if (Settings::annotation(Settings::EnumColorMode::theme5_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme5_), Settings::EnumColorMode::theme5_);
	else
		col_pop->insertItem(i18n("Theme 5"), Settings::EnumColorMode::theme5_);

	if (Settings::annotation(Settings::EnumColorMode::theme6_).length())
		col_pop->insertItem(Settings::annotation(Settings::EnumColorMode::theme6_), Settings::EnumColorMode::theme6_);
	else
		col_pop->insertItem(i18n("Theme 6"), Settings::EnumColorMode::theme6_);

	col_pop->insertSeparator();
	col_pop->insertItem(i18n("Custom..."), Settings::EnumColorMode::custom_);

	if (m_canvas->oneItemIsSelected())
	{
		DDataItem *item = m_canvas->dataTree()->singleSelection();
		if (item) col_pop->setItemChecked( item->colorScheme(), true);
	}

	connect(col_pop, SIGNAL(activated(int)), this, SIGNAL(activated(int)));

	insertItem( i18n("Colors"), col_pop);		
	col_pop->setEnabled( m_canvas->itemsAreSelected() );
	//setItemEnabled(col_pop, m_canvas->itemsAreSelected() );

	insertItem(i18n("Font properties"), e_font);
	setItemEnabled(e_font, m_canvas->itemsAreSelected() );
}
