/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <kdebug.h>

#include <qstring.h>

#include "settings.h"
#include "DDataControl.h"
#include "DDelta.h"

DDeltaCreate::DDeltaCreate(DDataControl* ctrl, int id, bool remove) : DDelta(ctrl)
{ 
	m_type=e_deltacreate;

	m_remove = remove;
	m_itemid = id;

	if (m_remove) copyFromItem();
}

void DDeltaCreate::applyUndo()
{
	kdDebug()<<"DDeltaCreate::applyUndo with item of id "<<m_itemid<<endl;
	if (!m_remove)
	{
		copyFromItem();
		m_ctrl->removeItem( m_itemid );
	}
	else
	{
		m_ctrl->createItem( DItem::NOITEM, m_itemid );
		copyToItem();
	}
}

void DDeltaCreate::applyRedo()
{
	kdDebug()<<"DDeltaCreate::applyRedo with item of id "<<m_itemid<<endl;
	if (!m_remove)
	{
		m_ctrl->createItem( DItem::NOITEM, m_itemid );
		copyToItem();
	}
	else
	{
		m_ctrl->removeItem( m_itemid );
	}
}

void DDeltaCreate::copyFromItem()
{
	DDataItem *item = (DDataItem*) m_ctrl->Item(m_itemid);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaMove::copyFromItem"<<endl;
		return;
	}

	m_defaultFont = item->m_defaultFont;
	m_text = item->m_text;
	m_summary = item->m_summary;
	m_comment = item->m_comment;
	//if (!m_pixtb.isNull())
	{
		m_pix = item->m_pix;
		m_pixtb = item->m_pixtb;
	}
	m_piccaption = item->m_piccaption;
	m_picurl = item->m_picurl;
	m_picfilename = item->m_picfilename;

	kdDebug()<<"previous color scheme "<<m_colorscheme<<endl;
	kdDebug()<<"color read from the item is "<<item->m_colorscheme<<endl;
	
	m_colorscheme = item->m_colorscheme;
	m_fillcolor = item->realFillColor();

	QValueList<URLObject>::iterator it = item->m_urllist.begin();
	QValueList<URLObject>::iterator end = item->m_urllist.end();
	for (; it != end; ++it)
	{
		m_urllist.append( *it );
	}

	QValueList<int>::iterator mit = item->m_flags.begin();
	QValueList<int>::iterator mend = item->m_flags.end();
	for (; mit != mend; ++mit)
	{
		m_flags.append( *mit );
	}

	m_lastchild = item->m_lastchild;
	m_x = item->x();
	m_y = item->y();
}

void DDeltaCreate::copyToItem()
{
	DDataItem *item = (DDataItem*) m_ctrl->Item(m_itemid);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaMove::copyToItem"<<endl;
		return;
	}

	item->m_defaultFont = m_defaultFont;
	item->m_text = m_text;
	item->m_summary = m_summary;
	item->m_comment = m_comment;
	item->m_pix = m_pix;
	item->m_pixtb = m_pixtb;
	item->m_piccaption = m_piccaption;
	item->m_picurl = m_picurl;
	item->m_picfilename = m_picfilename;

	item->m_colorscheme = m_colorscheme;
	item->m_fillcolor = m_fillcolor;

	/*if (m_colorscheme == Settings::EnumColorMode::custom_)
		item->setCustomColors( m_fillcolor, QColor( Qt::black ), QColor( Qt::black ) );
	else
		item->setColorScheme( m_colorscheme );*/

	QValueList<URLObject>::iterator it = m_urllist.begin();
	QValueList<URLObject>::iterator end = m_urllist.end();
	for (; it != end; ++it)
	{
		item->m_urllist.append( *it );
	}

	QValueList<int>::iterator mit = m_flags.begin();
	QValueList<int>::iterator mend = m_flags.end();
	for (; mit != mend; ++mit)
	{
		item->m_flags.append( *mit );
	}


	item->m_lastchild = m_lastchild;
	item->setXY( m_x, m_y );

	item->setChanged();
}

DDeltaMove::DDeltaMove(DDataControl* ctrl, int id, int oldx, int oldy, int newx, int newy) :
	DDelta(ctrl)
{
	m_type=e_deltamove;

	m_id = id;
	m_oldx = oldx;
	m_oldy = oldy;
	m_newx = newx;
	m_newy = newy;
}

void DDeltaMove::applyUndo()
{
	kdDebug()<<"DDeltaMove::applyUndo with item of id "<<m_id<<endl;

	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaMove::applyUndo"<<endl;
		return;
	}
	item->setXY(m_oldx, m_oldy);
	item->setChanged();
	m_ctrl->notifyChildren( m_id );
}

void DDeltaMove::applyRedo()
{
	kdDebug()<<"DDeltaMove::applyRedo with item of id "<<m_id<<endl;

	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaMove::applyRedo"<<endl;
		return;
	}
	item->setXY(m_newx, m_newy);
	item->setChanged();
	m_ctrl->notifyChildren( m_id );
}

DDeltaLink::DDeltaLink(DDataControl* ctrl, int id, int parentid, bool remove, bool isref) :
	DDelta( ctrl )
{
	m_type=e_deltalink;

	m_id = id;
	m_parentid = parentid;
	m_remove = remove;
	m_isref = isref;
}

void DDeltaLink::applyUndo()
{
	kdDebug()<<"DDeltaLink::applyUndo with item of id "<<m_id<<endl;

	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaLink::applyRedo"<<endl;
		return;
	}

	if (!m_isref)
	{
		if (m_remove)
		{
			m_ctrl->linkItems( m_parentid, m_id );
		}
		else
		{
			m_ctrl->unlinkItems( m_parentid, m_id );
		}
	}
	else
	{
		if (m_remove)
		{
			m_ctrl->requestRefChange(m_id, m_parentid, true, true);
		}
		else
		{
			m_ctrl->requestRefChange(m_id, m_parentid, false, true);
		}
	}
}

void DDeltaLink::applyRedo()
{
	kdDebug()<<"DDeltaLink::applyRedo with item of id "<<m_id<<endl;

	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaLink::applyRedo"<<endl;
		return;
	}

	if (!m_isref)
	{
		if (m_remove)
		{
			m_ctrl->unlinkItems( m_parentid, m_id );
		}
		else
		{
			m_ctrl->linkItems( m_parentid, m_id );
		}
	}
	else
	{
		if (m_remove)
		{
			m_ctrl->requestRefChange(m_id, m_parentid, false, true);
		}
		else
		{
			m_ctrl->requestRefChange(m_id, m_parentid, true, true);
		}
	}
}

DDeltaColor::DDeltaColor(DDataControl* ctrl, int id, int oldc, int newc, QColor mocust, QColor mncust) :
	DDelta( ctrl )
{
	m_type=e_deltacolor;

	m_id = id;
	m_oldcolor = oldc;
	m_newcolor = newc;
	m_new_customcolor = mncust;
	m_old_customcolor = mocust;
}

void DDeltaColor::applyUndo()
{
	kdDebug()<<"DDeltaColor::applyUndo with item of id "<<m_id<<endl;
	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaColor::applyUndo"<<endl;
		return;
	}

	if (m_oldcolor == Settings::EnumColorMode::custom_)
		item->setCustomColors( m_old_customcolor, QColor( Qt::black ), QColor( Qt::black ) );
	else
		item->setColorScheme( m_oldcolor );
	item->setChanged();
}

void DDeltaColor::applyRedo()
{
	kdDebug()<<"DDeltaMove::applyRedo with item of id "<<m_id<<endl;
	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaColor::applyRedo"<<endl;
		return;
	}

	if (m_newcolor == Settings::EnumColorMode::custom_)
		item->setCustomColors( m_new_customcolor, QColor( Qt::black ), QColor( Qt::black ) );
	else
		item->setColorScheme( m_newcolor );
	item->setChanged();
}

DDeltaFlag::DDeltaFlag(DDataControl* ctrl, int id, int flag, bool add) :
	DDelta( ctrl )
{
	m_type=e_deltaflag;

	m_id = id;
	m_flag = flag;
	m_add = add;
}

void DDeltaFlag::applyUndo()
{
	kdDebug()<<"DDeltaFlag::applyUndo with item of id "<<m_id<<endl;
	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaFlag::applyRedo"<<endl;
		return;
	}
	if (m_add)
	{
		item->setFlag(m_flag, false);
	}
	else
	{
		item->setFlag(m_flag, true);
	}
	item->setChanged();
}

void DDeltaFlag::applyRedo()
{
	kdDebug()<<"DDeltaFlag::applyRedo with item of id "<<m_id<<endl;
	DDataItem *item = (DDataItem*) m_ctrl->Item(m_id);
	if (!item)
	{
		kdDebug()<<"BUG: DDeltaFlag::applyRedo"<<endl;
		return;
	}
	if (m_add)
	{
		item->setFlag(m_flag, true);
	}
	else
	{
		item->setFlag(m_flag, false);
	}
	item->setChanged();
}

void DDeltaList::applyRedo()
{
	kdDebug()<<"----- DDeltaList::applyRedo ---------"<<endl;
	DDelta *d;
	for (d=m_deltalist.first(); d; d=m_deltalist.next())
	{
		d->applyRedo();
	}
}

void DDeltaList::applyUndo()
{
	kdDebug()<<"----- DDeltaList::applyUndo ---------"<<endl;
	DDelta *d;
	for (d=m_deltalist.last(); d; d=m_deltalist.prev())
	{
		d->applyUndo();
	}
}

void DDeltaList::insertDelta( DDelta* d )
{
	m_deltalist.append( d );
}

