/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef BOXURL_H
#define BOXURL_H

#include <klistview.h>

#include "DDataItem.h"

class linksPopup;

class BoxURL : public KListView
{
	Q_OBJECT

	public:
		BoxURL( QWidget* parent );
		~BoxURL() {}

	public slots:
		void setCurrentItem(DDataItem*);
		void requestAddURL();
		void requestChangeURL();
		
		void addSingleURL( const QString & url );
		void updateFromItem();

		void launchSelectedURL();
		
	signals:
		void datachanged();

	private:
		DDataItem* m_item;
		void addItem(URLObject& obj);
		linksPopup* m_popup;

		void launchURL(const QString &);

	private slots:
		void popupmenu(KListView*l, QListViewItem*i, const QPoint&p);
		void popupMenuSel(int val);
		void updateItem();

	protected:
		virtual void dragEnterEvent(QDragEnterEvent *event);
		virtual void dropEvent(QDropEvent *event);
};

class BoxURLItem : public KListViewItem
{
	public:
		BoxURLItem(BoxURL* par) : KListViewItem((QListView*) par) { }
		~BoxURLItem() { }
		void updateCaption();

		URLObject m_object;
};

#endif // BOXURL_H
