import re
import SCons.Node.FS
import SCons.Sig
import SCons.Util
class _Null:
    pass
_null=_Null
def Scanner(function, *args, **kw):
    """ """
    if SCons.Util.is_Dict(function):
        return apply(Selector, (function,) + args, kw)
    else:
        return apply(Base, (function,) + args, kw)
class FindPathDirs:
    """ """
    def __init__(self, variable, fs):
        self.variable=variable
        self.fs=fs
    def __call__(self, env, dir, argument=None):
        try:
            path=env[self.variable]
        except KeyError:
            return ()
        return tuple(self.fs.Rsearchall(env.subst_path(path),
                                        must_exist=0,
                                        clazz=SCons.Node.FS.Dir,
                                        cwd=dir))
class Base:
    """ """
    def __init__(self,
                 function,
                 name="NONE",
                 argument=_null,
                 skeys=[],
                 path_function=None,
                 node_class=SCons.Node.FS.Entry,
                 node_factory=SCons.Node.FS.default_fs.File,
                 scan_check=None,
                 recursive=None):
        """ """
        self.function=function
        self.path_function=path_function
        self.name=name
        self.argument=argument
        self.skeys=skeys
        self.node_class=node_class
        self.node_factory=node_factory
        self.scan_check=scan_check
        self.recursive=recursive
    def path(self, env, dir=None):
        if not self.path_function:
            return ()
        if not self.argument is _null:
            return self.path_function(env, dir, self.argument)
        else:
            return self.path_function(env, dir)
    def __call__(self, node, env, path=()):
        """ """
        if self.scan_check and not self.scan_check(node, env):
            return []
        if not self.argument is _null:
            list=self.function(node, env, path, self.argument)
        else:
            list=self.function(node, env, path)
        kw={}
        if hasattr(node, 'dir'):
            kw['directory']=node.dir
        nodes=[]
        for l in list:
            if self.node_class and not isinstance(l, self.node_class):
                l=apply(self.node_factory, (l,), kw)
            nodes.append(l)
        return nodes
    def __cmp__(self, other):
        return cmp(self.__dict__, other.__dict__)
    def __hash__(self):
        return hash(repr(self))
    def add_skey(self, skey):
        """ """
        self.skeys.append(skey)
    def get_skeys(self, env=None):
        if SCons.Util.is_String(self.skeys):
            return env.subst_list(self.skeys)[0]
        return self.skeys
    def select(self, node):
        return self
class Selector(Base):
    """ """
    def __init__(self, dict, *args, **kw):
        Base.__init__(self, (None,)+args, kw)
        self.dict=dict
    def __call__(self, node, env, path=()):
        return self.select(node)(node, env, path)
    def select(self, node):
        try:
            return self.dict[node.scanner_key()]
        except KeyError:
            return None
    def add_scanner(self, skey, scanner):
        self.dict[skey]=scanner
class Current(Base):
    """ """
    def __init__(self, *args, **kw):
        def current_check(node, env):
            c=not node.has_builder() or node.current(env.get_calculator())
            return c
        kw['scan_check']=current_check
        apply(Base.__init__, (self,) + args, kw)
class Classic(Current):
    """ """
    def __init__(self, name, suffixes, path_variable, regex,
                 fs=SCons.Node.FS.default_fs, *args, **kw):
        self.cre=re.compile(regex, re.M)
        self.fs=fs
        def _scan(node, env, path, self=self, fs=fs):
            return self.scan(node, env, path)
        kw['function']=_scan
        kw['path_function']=FindPathDirs(path_variable, fs)
        kw['recursive']=1
        kw['skeys']=suffixes
        kw['name']=name
        apply(Current.__init__, (self,) + args, kw)
    def find_include(self, include, source_dir, path):
        n=SCons.Node.FS.find_file(include, (source_dir,) + path, self.fs.File)
        return n, include
    def scan(self, node, env, path=()):
        node=node.rfile()
        if not node.exists():
            return []
        if node.includes != None:
            includes=node.includes
        else:
            includes=self.cre.findall(node.get_contents())
            node.includes=includes
        nodes=[]
        source_dir=node.get_dir()
        for include in includes:
            n, i=self.find_include(include, source_dir, path)
            if not n is None:
                nodes.append(n)
            else:
                SCons.Warnings.warn(SCons.Warnings.DependencyWarning,
                                    "No dependency generated for file: %s (included from: %s) -- file not found" % (i, node))
        def st(List, Metric):
            def pairing(element, M=Metric):
                return (M(element), element)
            def stripit(pair):
                return pair[1]
            paired=map(pairing, List)
            paired.sort()
            return map(stripit, paired)
        def normalize(node):
            return SCons.Node.FS._my_normcase(str(node))
        transformed=st(nodes, normalize)
        return transformed
class ClassicCPP(Classic):
    """ """
    def find_include(self, include, source_dir, path):
        if include[0]=='"':
            n=SCons.Node.FS.find_file(include[1],
                                        (source_dir,) + path,
                                        self.fs.File)
        else:
            n=SCons.Node.FS.find_file(include[1],
                                        path + (source_dir,),
                                        self.fs.File)
        return n, include[1]
