/*
 * Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

// $Id: qtraylabel.h,v 1.20 2005/02/09 03:34:06 cs19713 Exp $

#ifndef _QTRAYLABEL_H
#define _QTRAYLABEL_H

#include <qlabel.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qtextstream.h>
#include <qsettings.h>
#include <qevent.h>
#include <qsize.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include <sys/types.h>
#include <unistd.h>

class QMouseEvent;
class QDragEnterEvent;
class QPoint;

class QTrayLabel : public QLabel
{
  Q_OBJECT

public:
  QTrayLabel(Window w, QWidget* p = 0, const QString& text = QString::null);
  QTrayLabel(const QStringList& argv, pid_t pid, QWidget* parent = 0);
  virtual ~QTrayLabel();

  // Accessors
  Window dockedWindow(void) const { return mDockedWindow; }
  int balloonTimeout(void) const { return mBalloonTimeout; }
  bool isSkippingTaskbar(void) const { return mSkippingTaskbar; }
  bool isWithdrawn(void) const { return mWithdrawn; }
  bool isDockWhenMinimized(void) const { return mDockWhenMinimized; }

  QString appName(void) const { return mProgName[0]; }
  virtual void setAppName(const QString& prog) { mProgName[0] = prog; }
  QString appClass(void) const { return mClass; }
  QString appTitle(void) const { return mTitle; }
  QPixmap appIcon(void) const  { return mAppIcon;  }

  // Pass on all events through this interface
  bool x11EventFilter(XEvent * event);

  // Session Management
  virtual bool saveState(QSettings& settings);
  virtual bool restoreState(QSettings& settings);

public slots:
  void dock(void);              // puts us in the system tray
  void undock(void);            // removes us from the system tray
  void map(void);               // maps the window that we are docking
  void withdraw(void);          // withdraws the window that we are docking
  void toggleShow(void)         // convenience slot
        { if (mWithdrawn) map(); else withdraw(); }
  void close(void);             // close the docked window
  void setTrayIcon(const QString& icon);  // sets custom icon

  // and some property setters
  virtual void setSkipTaskbar(bool skip);  // skip the taskbar
  virtual void setBalloonTimeout(int msecs) { mBalloonTimeout = msecs; }
  virtual void setDockWhenMinimized(bool dwm)  { mDockWhenMinimized = dwm; }

protected slots:
  void scanClients(void);       // scans existing client connections
 
signals:
  void clicked(const ButtonState&, const QPoint&);
  void docked(QTrayLabel *);   // emitted when we get docked
  void docked(void);           // emitted when we get docked
  void undocked(QTrayLabel *); // emitted when we get undocked
  void undocked(void);         // emitted when we get undock
                               // window are monitoring dies
  void sysTrayDestroyed(void); // emitted when the system tray disappears

protected:
  // reimplement these event handlers in subclass as needed
  virtual void mouseReleaseEvent(QMouseEvent *event);
  virtual void dragEnterEvent(QDragEnterEvent *event);
  
  // the events that follow are events of the docked window (NOT QTrayLabel)
  virtual void updateIcon(void);   // updates the icon
  virtual void updateTitle(void);  // sets the tooltip
  virtual void balloonText(void);  // balloons text
  virtual void obscureEvent(void) { }
  virtual void mapEvent(void)  {  }
  virtual void unmapEvent(void) { }
  virtual void minimizeEvent(void);
  virtual void destroyEvent(void);
 
  // needs to return if we can unsubscribe for root
  virtual bool canUnsubscribeFromRoot(void) { return true; } 
  // needs to return if we can dock a candidate window
  virtual bool canDockWindow(Window) { return true; }
  virtual void processDead(void) { }

  void propertyChangeEvent(Atom);
  void setDockedWindow(Window w); // set docked window to anything you want

private slots:
  void realityCheck(void);
  void showOnAllDesktops(void);
  void toggleDockWhenMinimized(void) 
                { mDockWhenMinimized = !mDockWhenMinimized; }
 void skipTaskbar(void);

private:
  // Helpers
  void initialize(void);
  void handleTitleChange(void);
  void handleIconChange(void);
  const char *me(void) const;

  // Member variables
  long mDesktop;      // desktop on which the window is being shown
  QLabel *mBalloon;		// tooltip text simulator
  QString mCustomIcon;		// CustomIcon of the docked application
  Window mDockedWindow;	// the window which is being docked
	int mBalloonTimeout;
  bool mDocked, mWithdrawn, mSkippingTaskbar;
  bool mDockWhenMinimized;

  QString mTitle, mClass;	// Title and hint of mDockedWindow
  QPixmap mAppIcon;       // The current app icon (may not be same as pixmap())
  XSizeHints mSizeHint;		// SizeHint of mDockedWindow

  QTimer mRealityMonitor;  // Helps us sync up with reality
  QStringList mProgName;   // The program whose window we are docking
  pid_t mPid;              // The PID of program whose window we are docking

  Window mSysTray;    // System tray window id
};

#endif // _QTRAYLABEL_H
