/* 
 *  Copyright (C) 2004 Girish Ramakrishnan All Rights Reserved.
 *	
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 */

// $Id: traylabelmgr.h,v 1.3 2005/01/07 12:16:07 cs19713 Exp $

#ifndef _TRAYLABELMGR_H
#define _TRAYLABELMGR_H

#include <qobject.h>
#include <qptrlist.h>
#include <qvaluelist.h>
#include <qstringlist.h>

#include "customtraylabel.h"

class CustomTrayLabel;

class TrayLabelMgr : public QObject
{
  Q_OBJECT

public:
  static TrayLabelMgr* instance();
  static QString options(void) { return QString(mOptionString); }

  ~TrayLabelMgr();

  QString saveSession();

  bool x11EventFilter(XEvent *);
  bool processCommand(const QStringList& argv);
  int  hiddenLabelsCount(void) const;
  int  dockedLabelsCount(void) const;
  bool isWindowDocked(Window w);
 
public slots:
  void about();
  void undockAll();
  void dockAnother();

private slots:
  void startup();
  void trayLabelDestroyed(QObject *);
  void sysTrayDestroyed(void);
  void notifySysTrayAbsence();

private:
  TrayLabelMgr();
  bool processCommand(int argc, char** argv);
  void manageTrayLabel(QTrayLabel *l);
  bool restoreSession(const QString& sessionId);
  
  QTrayLabel *dockApplication(char *argv[]);
  QTrayLabel *selectAndDock(Window w = None, bool checkNormality = true);

  QPtrList<QTrayLabel> mTrayLabels;
  QValueList<QStringList> mRequestQ;
  bool mReady;
  int mHiddenLabelsCount;
  
  static const char *mOptionString;
  static TrayLabelMgr *gTrayLabelMgr;
};

#endif // _TRAYLABELMGR_H

