/***************************************************************************
                       confdialog.cpp  -  description
                           -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002-2003 by Aurelien Jarno
    email                : aurelien@aurel32.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// application specific includees
#include "confdialog.h"

// includes files for Qt
#include <qbuttongroup.h>
#include <qvbuttongroup.h>
#include <qhbuttongroup.h>
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

// includes files for KDE
#include <kapp.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kaudioplayer.h>

// Pics
#include "pics/play.xpm"

ConfDialog::ConfDialog(QWidget* parent, const char* name, bool modal, WFlags fl)
  : QDialog(parent, name, modal, fl)
{
  QWidget *widget;
  QGroupBox *groupBox;
  QButtonGroup *buttonGroup;
  QBoxLayout *boxLayout, *confLayout;
  QGridLayout *gridLayout;
  QSpacerItem *spacer;
  
  setCaption(i18n("KeybLED Preferences"));
  setSizeGripEnabled(FALSE);
  
  confLayout = new QVBoxLayout(this); 
  confLayout->setSpacing(6);
  confLayout->setMargin(11);
  
  tabWidget = new QTabWidget(this);
  confLayout->addWidget(tabWidget);

  // Display tab
  widget = new QWidget(tabWidget);
  tabWidget->insertTab(widget, i18n("&Display"));
  
  boxLayout = new QVBoxLayout(widget); 
  boxLayout->setSpacing(6);
  boxLayout->setMargin(11);

  buttonGroup = new QVButtonGroup(i18n("Panel"), widget);
  boxLayout->addWidget(buttonGroup);

  numLedEnabled = new QCheckBox(i18n("Show &NUM.LOCK LED"), buttonGroup);
  QToolTip::add(numLedEnabled, i18n("Shows the NUM.LOCK LED on the applet"));
  QWhatsThis::add(numLedEnabled, i18n("If this option is checked, the NUM.LOCK LED will be shown on the applet."));

  capsLedEnabled = new QCheckBox(i18n("Show CA&PS.LOCK LED"), buttonGroup);
  QToolTip::add(capsLedEnabled, i18n("Shows the CAPS.LOCK LED on the applet"));
  QWhatsThis::add(capsLedEnabled, i18n("If this option is checked, the CAPS.LOCK LED will be shown on the applet."));

  scrollLedEnabled = new QCheckBox(i18n("Show SC&ROLL.LOCK LED"), buttonGroup);
  QToolTip::add(scrollLedEnabled, i18n("Shows the SCROLL.LOCK LED on the applet"));
  QWhatsThis::add(scrollLedEnabled, i18n("If this option is checked, the SCROLL.LOCK LED will be shown on the applet."));
  
  buttonGroup = new QVButtonGroup(i18n("Others parameters"), widget);
  boxLayout->addWidget(buttonGroup);
  
  tooltipsEnabled = new QCheckBox(i18n("Enable tool t&ips"), buttonGroup);
  QToolTip::add(tooltipsEnabled, i18n("Enables tool tips"));
  QWhatsThis::add(tooltipsEnabled, i18n("If this option is checked, when the mouse goes over a LED, a tool tip indicating the LED name will be displayed. It also enabled tool tips in the Preferences Dialog."));

  popupEnabled = new QCheckBox(i18n("Enable pop&up"), buttonGroup);
  QToolTip::add(popupEnabled, i18n("Enables popup"));
  QWhatsThis::add(popupEnabled, i18n("If this option is checked, it is possible to bring up a popup telling the states of any of the LEDs by left-clicking on the applet."));

  mouseToggle = new QCheckBox(i18n("LEDs can be toggled with the &mouse"), buttonGroup);
  QToolTip::add(mouseToggle, i18n("LEDs can be toggled with the mouse"));
  QWhatsThis::add(mouseToggle, i18n("If this option is checked and if your X-server supports it, it is possible to toggle a LED by left-clicking on it."));

  spacer = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);
  boxLayout->addItem(spacer);


  // LEDs tab
  widget = new QWidget(tabWidget);
  tabWidget->insertTab(widget, i18n("&LEDs"));

  boxLayout = new QVBoxLayout(widget); 
  boxLayout->setSpacing(6);
  boxLayout->setMargin(11);

  groupBox = new QHGroupBox(i18n("S&ize"), widget);
  boxLayout->addWidget(groupBox);
  
  ledSize = new QSlider(groupBox);
  ledSize->setMinValue(2);
  ledSize->setMaxValue(6);
  ledSize->setLineStep(1);
  ledSize->setPageStep(1);
  ledSize->setOrientation(QSlider::Horizontal);
  ledSize->setTickmarks(QSlider::Both);
  QToolTip::add(ledSize, i18n("Sets the size of the LEDs"));
  QWhatsThis::add(ledSize, i18n("Sets the size of the LEDs."));

  buttonGroup = new QHButtonGroup(i18n("Orientation"), widget);
  boxLayout->addWidget(buttonGroup);

  ledVertical = new QRadioButton(i18n("&Vertical"), buttonGroup);
  QToolTip::add(ledVertical, i18n("Sets the orientation of the LEDs to vertically"));
  QWhatsThis::add(ledVertical, i18n("Sets the orientation of the LEDs (and also of the labels) to vertically."));

  ledHorizontal = new QRadioButton(i18n("Hori&zontal"), buttonGroup);
  QToolTip::add(ledHorizontal, i18n("Sets the orientation of the LEDs to horizontally"));
  QWhatsThis::add(ledHorizontal, i18n("Sets the orientation of the LEDs (and also of the labels) to horizontally."));

  buttonGroup = new QHButtonGroup(i18n("Shape"), widget);
  boxLayout->addWidget(buttonGroup);
  
  ledRectangular = new QRadioButton(i18n("Rectan&gular"), buttonGroup);
  QToolTip::add(ledRectangular, i18n("Sets the LEDs shape to rectangular"));
  QWhatsThis::add(ledRectangular, i18n("If this option is selected the LEDs are rectangular."));

  ledCircular = new QRadioButton(i18n("Circ&ular"), buttonGroup);
  QToolTip::add(ledCircular, i18n("Sets the LEDs shape to circular"));
  QWhatsThis::add(ledCircular, i18n("If this option is selected the LEDs are rectangular."));

  buttonGroup = new QHButtonGroup(i18n("Look"), widget);
  boxLayout->addWidget(buttonGroup);

  ledFlat = new QRadioButton(i18n("&Flat"), buttonGroup);
  QToolTip::add(ledFlat, i18n("Sets the LEDs look to flat"));
  QWhatsThis::add(ledFlat, i18n("If this option is selected the LEDs are flat."));

  ledRaised = new QRadioButton(i18n("Raise&d"), buttonGroup);
  QToolTip::add(ledRaised, i18n("Sets the LEDs look to raised"));
  QWhatsThis::add(ledRaised, i18n("If this option is selected the LEDs are raised."));

  ledSunken = new QRadioButton(i18n("Sun&ken"), buttonGroup);
  QToolTip::add(ledSunken, i18n("Sets the LEDs look to sunken"));
  QWhatsThis::add(ledSunken, i18n("If this option is selected the LEDs are sunken."));

  groupBox = new QHGroupBox(i18n("Colo&r"), widget);
  boxLayout->addWidget(groupBox);

  ledColor = new KColorButton(groupBox);
  QToolTip::add(ledColor, i18n("Define the color of the LEDs"));
  QWhatsThis::add(ledColor, i18n("Define the color of the LEDs. When clicking on this button, a color dialog appears which let you choosing the desired color for the LEDs."));
  
  spacer = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);
  boxLayout->addItem(spacer);


  // Labels
  widget = new QWidget(tabWidget);
  tabWidget->insertTab(widget, i18n("La&bels"));

  boxLayout = new QVBoxLayout(widget); 
  boxLayout->setSpacing(6);
  boxLayout->setMargin(11);

  labelsEnabled = new QCheckBox(i18n("Sho&w labels"), widget);
  QToolTip::add(labelsEnabled, i18n("Shows labels on the applet"));
  QWhatsThis::add(labelsEnabled, i18n("If this option is checked, labels are display in addition to the LEDs. It is useful to locate LEDs when you do not want to display the threes. "));
  boxLayout->addWidget(labelsEnabled);

  groupBox = new QHGroupBox(i18n("S&ize"), widget);
  groupBox->setEnabled(false); // Disabled by default
  boxLayout->addWidget(groupBox);
  connect(labelsEnabled, SIGNAL(toggled(bool)), groupBox, SLOT(setEnabled(bool)));

  labelSize = new QSlider(groupBox);
  labelSize->setMinValue(2);
  labelSize->setMaxValue(6);
  labelSize->setLineStep(1);
  labelSize->setPageStep(1);
  labelSize->setOrientation(QSlider::Horizontal);
  labelSize->setTickmarks(QSlider::Both);
  QToolTip::add(labelSize, i18n("Sets the size of the labels"));
  QWhatsThis::add(labelSize, i18n("Sets the size of the labels."));

  groupBox = new QVGroupBox(i18n("Position"), widget);
  groupBox->setEnabled(false); // Disabled by default
  boxLayout->addWidget(groupBox);
  connect(labelsEnabled, SIGNAL(toggled(bool)), groupBox, SLOT(setEnabled(bool)));
  
  buttonGroup = new QHButtonGroup(i18n("If LEDs are oriented horizontally:"), groupBox);
  buttonGroup->setFrameShape(QButtonGroup::NoFrame);

  labelTop = new QRadioButton(i18n("To&p"), buttonGroup);
  QToolTip::add(labelTop, i18n("Positions the labels at the top of the applet"));
  QWhatsThis::add(labelTop, i18n("If LEDs are oriented horizontally, positions the labels at the top of the applet."));

  labelBottom = new QRadioButton(i18n("Botto&m"), buttonGroup);
  QToolTip::add(labelBottom, i18n("Positions the labels at the bottom of the applet"));
  QWhatsThis::add(labelBottom, i18n("If LEDs are oriented horizontally, positions the labels at the bottom of the applet."));

  buttonGroup = new QHButtonGroup(i18n("If LEDs are oriented vertically:"), groupBox);
  buttonGroup->setFrameShape(QButtonGroup::NoFrame);
  
  labelLeft = new QRadioButton(i18n("Le&ft"), buttonGroup);
  QToolTip::add(labelLeft, i18n("Positions the labels on the left of the applet"));
  QWhatsThis::add(labelLeft, i18n("If LEDs are oriented vertically, positions the labels on the left of the applet."));

  labelRight = new QRadioButton(i18n("Ri&ght"), buttonGroup);
  QToolTip::add(labelRight, i18n("Positions the labels on the right of the applet"));
  QWhatsThis::add(labelRight, i18n("If LEDs are oriented vertically, positions the labels on the right of the applet."));

  spacer = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);
  boxLayout->addItem(spacer);


  // Startup
  widget = new QWidget(tabWidget);
  tabWidget->insertTab(widget, i18n("S&tartup"));

  boxLayout = new QVBoxLayout(widget); 
  boxLayout->setSpacing(6);
  boxLayout->setMargin(11);
   
  groupBox = new QGroupBox(i18n("Startup"), widget);
  boxLayout->addWidget(groupBox);
  groupBox->setColumnLayout(0, Qt::Vertical);
  gridLayout = new QGridLayout(groupBox->layout());
  gridLayout->setSpacing(6);
  
  numLedStartupLabel = new QLabel(i18n("&NUM.LOCK"), groupBox);
  gridLayout->addWidget(numLedStartupLabel, 0, 0);
  numLedStartup = new QComboBox(FALSE, groupBox);
  numLedStartup->insertItem(i18n("Leave unchanged"));
  numLedStartup->insertItem(i18n("Turn on"));
  numLedStartup->insertItem(i18n("Turn off"));
  numLedStartupLabel->setBuddy(numLedStartup);
  QToolTip::add(numLedStartup, i18n("Change here the state of the NUM.LOCK LED on startup"));
  QWhatsThis::add(numLedStartup, i18n("Choose here the state of the NUM.LOCK LED you want ot have when the applet starts. It is useful when you have set up KeybLED to start automatically on KDE startup since by default all LEDs are disabled."));
  gridLayout->addWidget(numLedStartup, 0, 1);

  capsLedStartupLabel = new QLabel(i18n("CA&PS.LOCK"), groupBox);
  gridLayout->addWidget(capsLedStartupLabel, 1, 0);
  capsLedStartup = new QComboBox(FALSE, groupBox);
  capsLedStartup->insertItem(i18n("Leave unchanged"));
  capsLedStartup->insertItem(i18n("Turn on"));
  capsLedStartup->insertItem(i18n("Turn off"));
  capsLedStartupLabel->setBuddy(capsLedStartup);
  QToolTip::add(capsLedStartup, i18n("Change here the state of the CAPS.LOCK LED on startup"));
  QWhatsThis::add(capsLedStartup, i18n("Choose here the state of the CAPS.LOCK LED you want ot have when the applet starts. It is useful when you have set up KeybLED to start automatically on KDE startup since by default all LEDs are disabled."));
  gridLayout->addWidget(capsLedStartup, 1, 1);

  scrollLedStartupLabel = new QLabel(i18n("SC&ROLL.LOCK"), groupBox);
  gridLayout->addWidget(scrollLedStartupLabel, 2, 0);
  scrollLedStartup = new QComboBox(FALSE, groupBox);
  scrollLedStartup->insertItem(i18n("Leave unchanged"));
  scrollLedStartup->insertItem(i18n("Turn on"));
  scrollLedStartup->insertItem(i18n("Turn off"));
  scrollLedStartupLabel->setBuddy(scrollLedStartup);
  QToolTip::add(scrollLedStartup, i18n("Change here the state of the SCROLL.LOCK LED on startup"));
  QWhatsThis::add(scrollLedStartup, i18n("Choose here the state of the SCROLL.LOCK LED you want ot have when the applet starts. It is useful when you have set up KeybLED to start automatically on KDE startup since by default all LEDs are disabled."));
  gridLayout->addWidget(scrollLedStartup, 2, 1);

  spacer = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);
  boxLayout->addItem(spacer);


  // Sounds
  widget = new QWidget(tabWidget);
  tabWidget->insertTab(widget, i18n("&Sounds"));

  boxLayout = new QVBoxLayout(widget); 
  boxLayout->setSpacing(6);
  boxLayout->setMargin(11);

  QPixmap play_icon((const char**) play_icon_data);
  
  soundsEnabled = new QCheckBox(i18n("&Enable sounds"), widget);
  QToolTip::add(soundsEnabled, i18n("Plays a sound when a LED is toggled"));
  QWhatsThis::add(soundsEnabled, i18n("If this option is enable, a sound is played each time a LED is toggled."));
  boxLayout->addWidget(soundsEnabled);

  groupBox = new QGroupBox(i18n("Sounds"), widget);
  boxLayout->addWidget(groupBox);
  groupBox->setColumnLayout(0, Qt::Vertical);
  gridLayout = new QGridLayout(groupBox->layout());
  gridLayout->setSpacing(6);
  groupBox->setEnabled(false); // Disabled by default
  connect(soundsEnabled, SIGNAL(toggled(bool)), groupBox, SLOT(setEnabled(bool)));


  numLedSoundLabel = new QLabel(i18n("&NUM.LOCK"), groupBox);
  gridLayout->addWidget(numLedSoundLabel, 0, 0);
  
  numLedSoundURL = new KURLRequester(groupBox);
  QToolTip::add(numLedSoundURL, i18n("NUM.LOCK's sound"));
  QWhatsThis::add(numLedSoundURL, i18n("Select here the sound to play when the NUM.LOCK LED is toggled."));
  gridLayout->addWidget(numLedSoundURL, 0, 1);
  numLedSoundURL->fileDialog()->setMode(static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly | KFile::ExistingOnly));
  connect(numLedSoundURL, SIGNAL(openFileDialog(KURLRequester *)), SLOT(slotRequesterClicked(KURLRequester *)));

  numLedSoundPlay = new QPushButton(groupBox);
  numLedSoundPlay->setPixmap(play_icon);
  numLedSoundPlay->setFixedSize(numLedSoundURL->button()->size());
  QToolTip::add(numLedSoundPlay, i18n("Play the given sound"));
  gridLayout->addWidget(numLedSoundPlay, 0, 2);
  connect(numLedSoundPlay, SIGNAL(clicked()), SLOT(slotNumPlaySound()));
  numLedSoundLabel->setBuddy(numLedSoundURL);

  capsLedSoundLabel = new QLabel(i18n("CA&PS.LOCK"), groupBox);
  gridLayout->addWidget(capsLedSoundLabel, 1, 0);
  
  capsLedSoundURL = new KURLRequester(groupBox);
  QToolTip::add(capsLedSoundURL, i18n("CAPS.LOCK's sound"));
  QWhatsThis::add(capsLedSoundURL, i18n("Select here the sound to play when the CAPS.LOCK LED is toggled."));
  gridLayout->addWidget(capsLedSoundURL, 1, 1);
  capsLedSoundURL->fileDialog()->setMode(static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly | KFile::ExistingOnly));
  connect(capsLedSoundURL, SIGNAL(openFileDialog(KURLRequester *)), SLOT(slotRequesterClicked(KURLRequester *)));

  capsLedSoundPlay = new QPushButton(groupBox);
  capsLedSoundPlay->setPixmap(play_icon);
  capsLedSoundPlay->setFixedSize(capsLedSoundURL->button()->size());
  QToolTip::add(capsLedSoundPlay, i18n("Play the given sound"));
  gridLayout->addWidget(capsLedSoundPlay, 1, 2);
  connect(capsLedSoundPlay, SIGNAL(clicked()), SLOT(slotCapsPlaySound()));
  capsLedSoundLabel->setBuddy(capsLedSoundURL);


  scrollLedSoundLabel = new QLabel(i18n("SC&ROLL.LOCK"), groupBox);
  gridLayout->addWidget(scrollLedSoundLabel, 2, 0);
  
  scrollLedSoundURL = new KURLRequester(groupBox);
  QToolTip::add(scrollLedSoundURL, i18n("SCROLL.LOCK's sound"));
  QWhatsThis::add(scrollLedSoundURL, i18n("Select here the sound to play when the SCROLL.LOCK LED is toggled."));
  gridLayout->addWidget(scrollLedSoundURL, 2, 1);
  scrollLedSoundURL->fileDialog()->setMode(static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly | KFile::ExistingOnly));
  connect(scrollLedSoundURL, SIGNAL(openFileDialog(KURLRequester *)), SLOT(slotRequesterClicked(KURLRequester *)));
  scrollLedSoundLabel->setBuddy(scrollLedSoundURL);

  scrollLedSoundPlay = new QPushButton(groupBox);
  scrollLedSoundPlay->setPixmap(play_icon);
  scrollLedSoundPlay->setFixedSize(scrollLedSoundURL->button()->size());
  QToolTip::add(scrollLedSoundPlay, i18n("Play the given sound"));
  gridLayout->addWidget(scrollLedSoundPlay, 2, 2);
  connect(scrollLedSoundPlay, SIGNAL(clicked()), SLOT(slotScrollPlaySound()));


  spacer = new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding);
  boxLayout->addItem(spacer);


  // Bottom buttons
  boxLayout = new QHBoxLayout(); 
  boxLayout->setSpacing(6);
  boxLayout->setMargin(0);
  confLayout->addLayout(boxLayout);

  buttonHelp = new QPushButton(this, "buttonHelp");
  buttonHelp->setText(i18n("&Help"));
  buttonHelp->setAutoDefault(TRUE);
  QWhatsThis::add(buttonHelp, i18n("Invoke help."));
  boxLayout->addWidget(buttonHelp);
  spacer = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
  boxLayout->addItem(spacer);
  connect(buttonHelp, SIGNAL(clicked()), this, SLOT(slotHelpClicked()));

  buttonApply = new QPushButton(i18n("&Apply"), this);
  buttonApply->setAutoDefault(TRUE);
  QWhatsThis::add(buttonApply, i18n("Apply all changes."));
  boxLayout->addWidget(buttonApply);
  connect(buttonApply, SIGNAL(clicked()), this, SLOT(slotApplyClicked()));

  buttonOk = new QPushButton(i18n("&OK"), this);
  buttonOk->setAutoDefault(TRUE);
  buttonOk->setDefault(TRUE);
  QWhatsThis::add(buttonOk, i18n("Close dialog and apply all changes."));
  boxLayout->addWidget(buttonOk);
  connect(buttonOk, SIGNAL(clicked()), this, SLOT(slotOkClicked()));

  buttonCancel = new QPushButton(i18n("&Cancel"), this);
  buttonCancel->setAutoDefault(TRUE);
  QWhatsThis::add(buttonCancel, i18n("Close dialog and discard all changes."));
  boxLayout->addWidget(buttonCancel);
  connect(buttonCancel, SIGNAL(clicked()), this, SLOT(slotCancelClicked()));
} 

void ConfDialog::setNumEnabled(bool enabled)
{
  numLedEnabled->setEnabled(enabled);
  numLedStartup->setEnabled(enabled);
  numLedStartupLabel->setEnabled(enabled);
  numLedSoundLabel->setEnabled(enabled);
  numLedSoundURL->setEnabled(enabled);
  numLedSoundPlay->setEnabled(enabled);
}

void ConfDialog::setCapsEnabled(bool enabled)
{
  capsLedEnabled->setEnabled(enabled);
  capsLedStartup->setEnabled(enabled);
  capsLedStartupLabel->setEnabled(enabled);
  capsLedSoundLabel->setEnabled(enabled);
  capsLedSoundURL->setEnabled(enabled);
  capsLedSoundPlay->setEnabled(enabled);
}

void ConfDialog::setScrollEnabled(bool enabled)
{
  scrollLedEnabled->setEnabled(enabled);
  scrollLedStartup->setEnabled(enabled);
  scrollLedStartupLabel->setEnabled(enabled);
  scrollLedSoundLabel->setEnabled(enabled);
  scrollLedSoundURL->setEnabled(enabled);
  scrollLedSoundPlay->setEnabled(enabled);
}

void ConfDialog::slotRequesterClicked(KURLRequester *requester)
{
  static bool init = true;
  if ( !init )
    return;

  init = false;

  KFileDialog *fileDialog = requester->fileDialog();
  fileDialog->setCaption( i18n("Select Sound File"));
  QStringList filters;
  filters.append("audio/x-wav");
  filters.append("audio/x-mp3");
  filters.append("application/x-ogg");
  filters.append("audio/x-adpcm");
  fileDialog->setMimeFilter(filters);

  // find the first "sound"-resource that contains files
  QStringList soundDirs = KGlobal::dirs()->resourceDirs("sound");
  if (!soundDirs.isEmpty()) 
  {
    KURL soundURL;
    QDir dir;
    dir.setFilter(QDir::Files | QDir::Readable);
    QStringList::Iterator it = soundDirs.begin();

    if ( !soundDirs.isEmpty()) 
    {
      while (it != soundDirs.end()) 
      {
        dir = (*it + "keybled/");
        if (dir.isReadable()) 
        {
          soundURL.setPath(dir.path());
	  requester->fileDialog()->setURL(soundURL);
	  break;
        }
        ++it;
      }	
    }      
  }
}

void ConfDialog::slotOkClicked()
{
  if (testSoundFiles())
    emit okClicked();
  else
    tabWidget->setCurrentPage(4);
}

void ConfDialog::slotApplyClicked()
{
  if (testSoundFiles())
    emit applyClicked();
  else
    tabWidget->setCurrentPage(4);
}

void ConfDialog::slotCancelClicked()
{
  close();
}

void ConfDialog::slotHelpClicked()
{
  KApplication *app = (KApplication*) KGlobal::instance();
  switch (tabWidget->currentPageIndex())
  {
   case 0: app->invokeHelp("preferences-display", "keybled"); break;
   case 1: app->invokeHelp("preferences-leds", "keybled"); break;
   case 2: app->invokeHelp("preferences-labels", "keybled"); break;
   case 3: app->invokeHelp("preferences-startup", "keybled"); break;
   case 4: app->invokeHelp("preferences-sounds", "keybled"); break;
  }
}

void ConfDialog::slotNumPlaySound()
{
  if (!numLedSoundURL->url().isNull()) KAudioPlayer::play(numLedSoundURL->url());
}

void ConfDialog::slotCapsPlaySound()
{
  if (!capsLedSoundURL->url().isNull()) KAudioPlayer::play(capsLedSoundURL->url());
}

void ConfDialog::slotScrollPlaySound()
{
  if (!scrollLedSoundURL->url().isNull()) KAudioPlayer::play(scrollLedSoundURL->url());
}

bool ConfDialog::testSoundFiles()
{
  if (numLedSoundURL->isEnabled() &&
      !numLedSoundURL->url().isEmpty() && 
      !QFile::exists(numLedSoundURL->url()))
    if (KMessageBox::warningContinueCancel(this, 
	i18n("The sound file you specified for NUM.LOCK does not exist (or is not readable).\n"
	     "You can continue if you want to, or you can click Cancel to select a new "
             "sound file."),
	i18n("NUM.LOCK's sound file not found!")) == KMessageBox::Cancel) 
	
      return false;

  if (capsLedSoundURL->isEnabled() &&
      !capsLedSoundURL->url().isEmpty() && 
      !QFile::exists(capsLedSoundURL->url()))
    if (KMessageBox::warningContinueCancel(this, 
	i18n("The sound file you specified for CAPS.LOCK does not exist (or is not readable).\n"
	     "You can continue if you want to, or you can click Cancel to select a new "
             "sound file."),
	i18n("CAPS.LOCK's sound file not found!")) == KMessageBox::Cancel) 
      return false;
      
  if (scrollLedSoundURL->isEnabled() &&
      !scrollLedSoundURL->url().isEmpty() && 
      !QFile::exists(scrollLedSoundURL->url()))
    if (KMessageBox::warningContinueCancel(this, 
	i18n("The sound file you specified for SCROLL.LOCK does not exist (or is not readable).\n"
	     "You can continue if you want to, or you can click Cancel to select a new "
             "sound file."),
	i18n("SCROLL.LOCK's sound file not found!")) == KMessageBox::Cancel) 
      return false;

  return true;
}
