/*---------------------------------------------------------------------------------
Name               : gui.h
Author             : Marvin Raaijmakers
Description        : Contains macros and structures for accessing GUI widgets
Date of last change: 08-Jul-2007
                     08-Jul-2007 Created this file

    Copyright (C) 2007 Marvin Raaijmakers

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    You can contact me at: marvinr(at)users(dot)sf(dot)net
    (replace (at) by @ and (dot) by .)
-----------------------------------------------------------------------------------*/
#ifndef INCLUDE_GUI
#define INCLUDE_GUI

#include <gtk/gtk.h>

/* Macro's for accessing objects of the GUI: */
#define KTGUI_main_window()       (keytouch_keyboard_gui.main_window)
#define KTGUI_keyboard_treeview() (keytouch_keyboard_gui.keyboard_treeview)
#define KTGUI_ok_button()         (keytouch_keyboard_gui.ok_button)

/*
 * This structure contains pointers to the objects in the GUI used by
 * the code in callbacks.c and setdata.c:
 */
typedef struct {
	GtkWidget   *main_window;
	GtkTreeView *keyboard_treeview;
	GtkButton   *ok_button;
} KTGUI_type;

extern KTGUI_type keytouch_keyboard_gui;

#endif
