#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>

#include <kdebug.h>

#include "pref.h"

#include "configdlg.h"

configDlg::configDlg(QWidget *parent, const char *name, bool modal, WFlags fl)
          : configDlgUI(parent, name, modal, fl)
{
    fishNameComboBox -> setText(kfishPref::prefs() ->getName());
    numOfBubblesSpinBox -> setValue(kfishPref::prefs() ->getBubblesNumber());
    widthSizeSpinBox -> setValue(kfishPref::prefs() ->getWidth());
    animationTimerSpinBox -> setValue (kfishPref::prefs() -> getTimeInAnimation());
    animationTimerSpinBox -> setMinValue( 2 );
    
    animationCheckBox -> setChecked ( (kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::None) ? 0 : 1 );
    if (kfishPref::prefs() -> getTypeOfAnimation() != kfishPref::None)
    {
        AnimationButtonGroup -> setButton( ((kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::Timer ) ? 0 : 1) );
        if (kfishPref::prefs() -> getTypeOfAnimation() == kfishPref::Mouse)
            animationTimerSpinBox -> setEnabled( false );
    }
    else
        AnimationButtonGroup -> setEnabled(false);
    
    QDictIterator<QString> it( *(kfishPref::prefs() -> getFishList()) );
    for( ; it.current(); ++it ) {
        fishPicComboBox -> insertItem( it. currentKey() );
        if ( *(it.current()) == kfishPref::prefs() -> getFile() )
            fishPicComboBox -> setCurrentText( it. currentKey() );
    }
    
    connect(okButton, SIGNAL(clicked()), this, SLOT(slotOk()));
    connect(applyButton, SIGNAL( clicked() ), SLOT ( slotApply() ));
    connect(cancelButton, SIGNAL( clicked() ), SLOT ( slotCancel() ));
    connect(animationCheckBox, SIGNAL( toggled(bool) ), SLOT( slotAnimCheckBox() ));
}

configDlg::~configDlg()
{
}

void configDlg::slotOk()
{
    slotApply();
    kfishPref::prefs() -> write();
	done(1);
}

void configDlg::slotApply()
{
    kfishPref::prefs() -> setName(fishNameComboBox -> text());
    // Find the key to know the name of the pic file  
    QDictIterator<QString> it( *(kfishPref::prefs() -> getFishList()) );
    for( ; it.current(); ++it ) {
        if ( it.currentKey() == fishPicComboBox -> currentText() )
            kfishPref::prefs() -> setFile( *(it.current()) );
    }
    kfishPref::prefs() -> setBubbleNumber(numOfBubblesSpinBox -> value());
    kfishPref::prefs() -> setWidth(widthSizeSpinBox -> value());
    kfishPref::prefs() -> setTimeInAnimation(animationTimerSpinBox -> value());
    if (animationCheckBox -> isChecked()) {
        if (animationTimeRadioButton -> isChecked())
            kfishPref::prefs() -> setTypeOfAnimation( kfishPref::Timer );
        else
            kfishPref::prefs() -> setTypeOfAnimation( kfishPref::Mouse );
    }
    else
        kfishPref::prefs() -> setTypeOfAnimation( kfishPref::None );
        
    kfishPref::prefs() -> emitChangePref();
}

void configDlg::slotCancel()
{
    kfishPref::prefs() -> load();
	done(0);
}

void configDlg::slotAnimCheckBox()
{
    kdDebug(1210) << "void configDlg::slotAnimCheckBox():" << AnimationButtonGroup -> selected() << endl;
    if (AnimationButtonGroup -> selected() == 0)
    {
        kfishPref::prefs() -> setTypeOfAnimation(kfishPref::Mouse);
        AnimationButtonGroup -> setButton( 1 );
		animationTimerSpinBox -> setEnabled( false );
    }
//    animationCheckBox -> setChecked ( 0 );
//    kfishPref::prefs() -> setTypeOfAnimation(kfishPref::Mouse);
}
