/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005,2008 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#ifndef UPLOADDLG_H
#define UPLOADDLG_H

#include <QDialog>
#include <QPixmap>

//#include <kio/job.h>
//
//class KIO::Job;

/**
 * Implements a simple upload dialog that will be used to provide
 * the user with some indication as to what is happening during
 * an upload.
 * @short Upload progress information dialog
 * @author M. Asselstine <asselsm@gmail.com>
 */
class UploadDlg : public QDialog
{
  Q_OBJECT

public:
  /** Constructor.
   *  @param parent Pointer to parent widget
   */
  UploadDlg(QWidget* parent);

  /** Destructor. */
  ~UploadDlg();

  /** Set the pixmap to display
   *  @param pixmap Reference to the new pixmap to display
   */
  void setPixmap(const QPixmap& pixmap);

  /** Set the number of photos being uploaded. Used to
   *  calibrate the overall progress bar.
   *  @param total The number of photos being uploaded
   */
  void setNumPhotos(int total);

  /** Set the number of completed photos. Used to update
   *  the overall progress bar.
   *  @param num Number of completed photos
   */
  void setNumCompleted(int num);

  /** Advance the overall progress bar
   *  @param amount Amount to advance
   */
  void advance(int amount);

private:
  class PrivateData;
  PrivateData& d;
};

#endif // UPLOADDLG_H
