/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */
#include "uploadprogress.h"

#include <qlabel.h>
#include <kprogress.h>
#include <qpushbutton.h>

#include <qapplication.h>


UploadProgress::UploadProgress(QWidget* parent, const char* name)
    :UploadProgressUI(parent, name, TRUE)
    , m_overall(-1)
{
    // Initialize widgets
    m_overallProgress->setValue(0);
    m_pixmap->setScaledContents(false);

    connect(m_cancel, SIGNAL(clicked()), SIGNAL(cancelClicked()));
}


UploadProgress::~UploadProgress()
{
}

void UploadProgress::setPixmap(const QPixmap& pixmap)
{
    m_pixmap->setPixmap(pixmap);
}

void UploadProgress::setNumPhotos(int total)
{
    m_overallProgress->setTotalSteps(total);
}

void UploadProgress::setNumCompleted(int num)
{
    m_overall = num;
    m_overallProgress->setProgress(m_overall);
}

void UploadProgress::advance(int amount)
{
    m_overall += amount;
    m_overallProgress->setProgress(m_overall);
}
