(       Title:  Complex Word Set Tests
         File:  complex-test.4th
       Author:  David N. Williams
      Version:  0.9.2
      License:  LGPL
Last revision:  March 5, 2003
)
\ Copyright (C) 2002, 2003 David N. Williams
(
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or at your option any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
MA 02111-1307 USA.

Version 0.9.2
27Apr04  * Restored DNW's original 0.9.2 code for kForth 1.2.x;
           conditional tests have been restored and some tests previously
           commented out have been uncommented. -- KM
 5Mar03  * Removed signed zero and branch cut tests.  Now
           they're in complex-szero-test.fs.
14May03  * Ported to kForth by K. Myneni:
           -- This version has been modified for integrated fp/data 
               stack Forths.
           -- The flag PRINCIPAL-ARG is assumed to be true and
              all conditional tests for PRINCIPAL-ARG have been
              commented out. The inverse functions are tested
              by default.

Version 0.9.1
21Feb03  * Added principal branch cut definitions and tests.
28Feb03  * Rearranged conditional includes.

Version 0.9.0
12Dec02  * Start.
18Feb03  * Release.

This code tests our modifications to Julian V. Noble's complex
arithmetic lexicon, and its port to pfe.

It is intended to test for formal correctness, not high
accuracy.

"Gauge functions" are functions that we test against.  They are
defined independently here, sometimes in terms of already tested
functions.

Except for DEFER and IS, this code is compatible with ANS Forth,
with an environmental dependence on lower case.
)

include ans-words
include ftester
true verbose !

\ complex.4th defines PRINCIPAL-ARG. It should be set to TRUE
\   to perform all tests, including tests on the inverse functions.

include complex.4th

cr testing complex.4th

decimal

s" [UNDEFINED]" pad c! pad char+ pad c@ move 
pad find nip 0=
[IF]
: [UNDEFINED]  ( "name" -- flag )
  bl word find nip 0= ; immediate
[THEN]

s" [DEFINED]" pad c! pad char+ pad c@ move 
pad find nip 0=
[IF]
: [DEFINED]  postpone [UNDEFINED] 0= ; immediate
[THEN]

[UNDEFINED] \\ [IF]
  : \\   BEGIN  10 word  drop  refill 0= UNTIL ; [THEN]



: near-defaults  ( -- )
  1e-14 abs-near f!
  1e-14 rel-near f! ;

 0.7853981633974483096157e0 fconstant  pi/4
-0.7853981633974483096157e0 fconstant -pi/4
 0.5497787143782138167310e1 fconstant  7pi/4
[UNDEFINED] pi/2 [IF]
 0.1570796326794896619231e1 fconstant  pi/2
[THEN]
-0.1570796326794896619231e1 fconstant -pi/2
 0.4712388980384689857694e1 fconstant  3pi/2

 0.2356194490192344928847e1 fconstant  3pi/4
-0.2356194490192344928847e1 fconstant -3pi/4
 0.3926990816987241548078e1 fconstant  5pi/4

[UNDEFINED] pi [IF]
 0.3141592653589793238463e1 fconstant  pi
[THEN]
[UNDEFINED] -pi [IF]
-0.3141592653589793238463e1 fconstant -pi
[THEN]

 0.2718281828459045235360e1 fconstant  e
-0.2718281828459045235360e1 fconstant -e
 0.3678794411714423215955e0 fconstant  1/e
-0.3678794411714423215955e0 fconstant -1/e

[UNDEFINED] ln2 [IF]
 0.6931471805599453094172e0 fconstant  ln2
[THEN]
-0.6931471805599453094172e0 fconstant -ln2
 0.1414213562373095048802e1 fconstant  rt2
-0.1414213562373095048802e1 fconstant -rt2
 0.7071067811865475244008e0 fconstant  1/rt2
-0.7071067811865475244008e0 fconstant -1/rt2

\ only two choices
cr PRINCIPAL-ARG [IF]
testing uses arg output with -pi < arg <= pi
  -3pi/4 fconstant 225arg
  -pi/2  fconstant 270arg
  -pi/4  fconstant 315arg
[ElSE]
testing uses arg output with 0 <= arg < 2pi
   5pi/4 fconstant 225arg
   3pi/2 fconstant 270arg
   7pi/4 fconstant 315arg
[THEN]

: f{{    f{ ( {) ;
: }}f    ( }) }f ;
: ->}}f  ( ->) }}f ;

defer gauge
defer func
defer inverse

\ ZVARIABLE, Z!, and Z@ have to be tested before the next 3
\ words are used.

zvariable zatemp   zvariable zbtemp

: ?gauge  ( z -- )
(
Compare the functions whose xt's are in FUNC and GAUGE.
) 
  zdup zatemp z! gauge   f->   zatemp z@ func  ( ->) ;

: ?2gauge  ( z1 z2 -- )
(
Same as above with 2 complex arguments.
) 
  zbtemp z! zatemp z!
  zatemp z@ zbtemp z@ gauge f-> zatemp z@ zbtemp z@ func ( ->) ;

: ?inverse  ( z -- )
(
Check that INVERSE FUNCT, i.e., func[inverse], is the identity
mapping.
)
  zdup zatemp z! inverse func   f->   zatemp z@   ( ->) ;

: -z   znegate ;

\ *** NONSTANDARD FP WORDS

testing  S>F  F-ROT or -FROT  FNIP  FTUCK  1/F  F^2  F2*  F2/

set-exact 
f{{    0 s>f f->    0e ->}}f
f{{  137 s>f f->  137e ->}}f
f{{ -137 s>f f-> -137e ->}}f

[DEFINED] f-rot [IF]
f{{ 1e1 2e1 3e1 f-rot f-> 3e1 1e1 2e1 ->}}f
[THEN]
[DEFINED] -frot [IF]
f{{ 1e1 2e1 3e1 -frot f-> 3e1 1e1 2e1 ->}}f
[THEN]
f{{ 1e1 2e1     fnip  f-> 2e1         ->}}f
f{{ 1e1 2e1     ftuck f-> 2e1 1e1 2e1 ->}}f

f{{  2e 1/f f->  0.5e ->}}f
f{{ -2e 1/f f-> -0.5e ->}}f

f{{  0e f^2 f-> 0e ->}}f
f{{  2e f^2 f-> 4e ->}}f
f{{ -2e f^2 f-> 4e ->}}f

f{{     0e   f2* f->     0e ->}}f
f{{   128e   f2* f->   256e ->}}f
f{{ -12.8e   f2* f-> -25.6e ->}}f

set-near
f{{  1/rt2   f2* f->  rt2 ->}}f
f{{ -1/rt2   f2* f-> -rt2 ->}}f

set-exact
f{{     0e f2/ f->     0e   ->}}f
f{{   256e f2/ f->   128e   ->}}f
f{{ -25.6e f2/ f-> -12.8e   ->}}f

set-near
f{{  rt2   f2/ f->  1/rt2 ->}}f
f{{ -rt2   f2/ f-> -1/rt2 ->}}f

\ testing  FPI  F0.0  F1.0
\ testing  F0.0  F1.0

set-exact 
\ f{{   fpi f-> pi ->}}f
\ f{{  f0.0 f-> 0e ->}}f
\ f{{  f1.0 f-> 1e ->}}f

\ *** COMPLEX CONSTANTS AND VARIABLES

testing  ZCONSTANT  ZVARIABLE  Z@  Z!

set-exact
f{{ 1e 2e zconstant 1+i2 f->       ->}}f
f{{ 1+i2                 f-> 1e 2e ->}}f
f{{ : equ zconstant ;    f->       ->}}f
f{{ 1+i2 equ z=(1+i2)    f->       ->}}f
f{{ z=(1+i2)             f-> 1+i2  ->}}f

f{{ zvariable zv1 f->      ->}}f
f{{ 1+i2 zv1 z!   f->      ->}}f
f{{ zv1 z@        f-> 1+i2 ->}}f

\ *** COMPLEX STACK MANIPULATION

testing  Z=0  Z=1  Z=I

set-exact
f{{  z=0 f-> 0e 0e ->}}f
f{{  z=1 f-> 1e 0e ->}}f
f{{  z=i f-> 0e 1e ->}}f

testing  ZDROP  ZDUP  ZSWAP  ZOVER  ZNIP  ZTUCK  ZROT  Z-ROT

set-exact
f{{ z=0         zdrop f->             ->}}f
f{{ z=1         zdup  f-> z=1 z=1     ->}}f
f{{ z=0 z=1     zswap f-> z=1 z=0     ->}}f
f{{ z=0 z=1     zover f-> z=0 z=1 z=0 ->}}f
f{{ z=0 z=1     znip  f-> z=1         ->}}f
f{{ z=0 z=1     ztuck f-> z=1 z=0 z=1 ->}}f
[DEFINED] zrot [IF]
f{{ z=0 z=1 z=i zrot  f-> z=1 z=i z=0 ->}}f
[THEN]
[DEFINED] z-rot [IF]
f{{ z=0 z=1 z=i z-rot f-> z=i z=0 z=1 ->}}f
[THEN]

\ *** COMPLEX ALGEBRA

testing  REAL IMAG  CONJG  Z*F   Z/F  Z*  Z/  Z+  Z-

set-exact
f{{ z=1     real  f-> 1e      ->}}f
f{{ z=i     imag  f-> 1e      ->}}f
f{{ 1e  2e  conjg f-> 1e -2e  ->}}f

set-near  \ true also works in pfe
f{{ 1e 2e 3e    z*f   f->  3e  6e ->}}f
f{{ 3e 6e 3e    z/f   f->  1e  2e ->}}f
f{{ 1e 2e 3e 4e z*    f-> -5e 10e ->}}f
f{{ 1e 2e z=1   z*    f->  1e  2e ->}}f
f{{ 1e 2e z=i   z*    f-> -2e  1e ->}}f
f{{ 1e 1e 3e 4e z/    f->  7e 25e f/ -1e 25e f/ ->}}f
f{{ 1e 1e 4e 3e z/    f->  7e 25e f/  1e 25e f/ ->}}f
f{{ 1e 2e 3e 4e z+    f->  4e  6e ->}}f
f{{ 1e 2e 3e 4e z-    f-> -2e -2e ->}}f

testing  |Z|  |Z^2|  1/Z  Z^2  Z^N  ZNEGATE  Z2*  Z2/  I*  (-I)*

set-exact
f{{   z=0        |z|     f->   0e        ->}}f
f{{   z=0        |z|^2   f->   0e        ->}}f
f{{   z=0        z^2     f->   z=0       ->}}f
f{{   z=0        -z      f->  -0e   -0e   ->}}f
f{{   1e   -2e   -z      f->  -1e    2e  ->}}f
f{{   z=0        z2*     f->   z=0       ->}}f
f{{  40e1 -20e1  z2*     f->  80e1 -40e1 ->}}f
f{{ -40e1  20e1  z2*     f-> -80e1  40e1 ->}}f
f{{   z=0        z2/     f->   z=0       ->}}f
f{{  50e1 -30e1  z2/     f->  25e1 -15e1 ->}}f
f{{ -50e1  30e1  z2/     f-> -25e1  15e1 ->}}f
f{{   z=0        i*      f->  -0e    0e  ->}}f
f{{  40e1 -20e1  i*      f->  20e1  40e1 ->}}f
f{{ -40e1  20e1  i*      f-> -20e1 -40e1 ->}}f
f{{   z=0        (-i)*   f->   0e   -0e  ->}}f
f{{  40e1 -20e1  (-i)*   f-> -20e1 -40e1 ->}}f
f{{ -40e1  20e1  (-i)*   f->  20e1  40e1 ->}}f

set-near
f{{  3e  4e |z|   f->  5e ->}}f
f{{ -3e  4e |z|   f->  5e ->}}f
f{{  3e -4e |z|   f->  5e ->}}f
f{{  3e  4e |z|^2 f-> 25e ->}}f
f{{ -3e  4e |z|^2 f-> 25e ->}}f
f{{  3e -4e |z|^2 f-> 25e ->}}f
f{{  3e  4e 1/z   f->  3e  25e f/ -4e 25e f/ ->}}f
f{{ -3e  4e 1/z   f-> -3e  25e f/ -4e 25e f/ ->}}f
f{{  3e -4e 1/z   f-> -3e -25e f/  4e 25e f/ ->}}f
f{{  3e  4e z^2   f-> -7e  24e ->}}f
f{{ -3e  4e z^2   f-> -7e -24e ->}}f
f{{  3e -4e z^2   f-> -7e -24e ->}}f
f{{ -3e -4e z^2   f-> -7e  24e ->}}f
f{{ z=1     1/z   f->  1e -0e  ->}}f  \ sign of 0 ignored here

set-exact
f{{  z=0      0 z^n f->  z=1      ->}}f
f{{  z=1      0 z^n f->  z=1      ->}}f
f{{ -1e   0e  0 z^n f->  z=1      ->}}f
f{{  z=i      0 z^n f->  z=1      ->}}f
f{{  0e  -1e  0 z^n f->  z=1      ->}}f
f{{  rt2  rt2 0 z^n f->  z=1      ->}}f
f{{  rt2 -rt2 0 z^n f->  z=1      ->}}f
f{{ -rt2  rt2 0 z^n f->  z=1      ->}}f
f{{ -rt2 -rt2 0 z^n f->  z=1      ->}}f

f{{  z=0      1 z^n f->  z=0      ->}}f
f{{  z=1      1 z^n f->  z=1      ->}}f
f{{ -1e   0e  1 z^n f-> -1e   0e  ->}}f
f{{  z=i      1 z^n f->  z=i      ->}}f
f{{  0e  -1e  1 z^n f->  0e  -1e  ->}}f
f{{  rt2  rt2 1 z^n f->  rt2  rt2 ->}}f
f{{  rt2 -rt2 1 z^n f->  rt2 -rt2 ->}}f
f{{ -rt2  rt2 1 z^n f-> -rt2  rt2 ->}}f
f{{ -rt2 -rt2 1 z^n f-> -rt2 -rt2 ->}}f

f{{  z=0      2 z^n f->  z=0      ->}}f
f{{  z=1      2 z^n f->  z=1      ->}}f
f{{ -1e   0e  2 z^n f->  z=1      ->}}f
f{{  z=i      2 z^n f-> -1e   0e  ->}}f
set-near \ avoid signed zero discrepancy
f{{  0e  -1e  2 z^n f-> -1e   0e  ->}}f
set-exact
f{{  3e   4e  2 z^n f-> -7e   24e ->}}f
f{{ -3e   4e  2 z^n f-> -7e  -24e ->}}f
f{{  3e  -4e  2 z^n f-> -7e  -24e ->}}f
f{{ -3e  -4e  2 z^n f-> -7e   24e ->}}f

f{{  z=0      5 z^n f->  z=0        ->}}f
f{{  z=1      5 z^n f->  z=1        ->}}f
f{{ -1e   0e  5 z^n f-> -1e    0e   ->}}f
f{{  z=i      5 z^n f->  z=i        ->}}f
f{{  0e  -1e  5 z^n f->  0e   -1e   ->}}f
f{{  2e   2e  5 z^n f-> -128e -128e ->}}f
f{{  2e  -2e  5 z^n f-> -128e  128e ->}}f
f{{ -2e   2e  5 z^n f->  128e -128e ->}}f
f{{ -2e  -2e  5 z^n f->  128e  128e ->}}f

testing  ARG  >POLAR  POLAR>  ZSQRT  ZLN  ZEXP  Z^

set-exact
f{{  z=0      arg f-> 0e     ->}}f
f{{  z=1      arg f-> 0e     ->}}f
f{{  z=i      arg f-> pi/2   ->}}f
f{{  0e  -1e  arg f-> 270arg ->}}f
f{{ -1e   0e  arg f-> pi     ->}}f
PRINCIPAL-ARG [IF]
f{{ -1e  -0e  arg f-> -pi     ->}}f
[THEN]

set-near
f{{  2e   2e  arg f-> pi/4   ->}}f
f{{  3e  -3e  arg f-> 315arg ->}}f
set-exact
f{{ -rt2  rt2 arg f-> 3pi/4  ->}}f
f{{ -rt2 -rt2 arg f-> 225arg ->}}f

rt2 f2*   fconstant 2rt2
rt2 3e f* fconstant 3rt2

set-exact
f{{  z=0      >polar f-> 0e   0e     ->}}f
f{{  z=1      >polar f-> 1e   0e     ->}}f
f{{  z=i      >polar f-> 1e   pi/2   ->}}f
f{{  0e  -1e  >polar f-> 1e   270arg ->}}f
f{{ -1e   0e  >polar f-> 1e   pi     ->}}f
set-near
f{{  2e   2e  >polar f-> 2rt2 pi/4   ->}}f
f{{  3e  -3e  >polar f-> 3rt2 315arg ->}}f
f{{ -rt2  rt2 >polar f-> 2e   3pi/4  ->}}f
f{{ -rt2 -rt2 >polar f-> 2e   225arg ->}}f

set-exact
f{{ 0e    0e    polar> f->  z=0      ->}}f
f{{ 1e    0e    polar> f->  z=1      ->}}f
set-near
f{{ 1e    pi/2  polar> f->  z=i      ->}}f
f{{ 1e   -pi/2  polar> f->  0e  -1e  ->}}f
f{{ 1e    pi    polar> f-> -1e   0e  ->}}f
f{{ 2rt2  pi/4  polar> f->  2e   2e  ->}}f
f{{ 3rt2 -pi/4  polar> f->  3e  -3e  ->}}f
f{{ 2e    3pi/4 polar> f-> -rt2  rt2 ->}}f
f{{ 2e   -3pi/4 polar> f-> -rt2 -rt2 ->}}f

: gsqrt  ( z -- exp[[ln|z|+iarg[z]]/2] )
  zln z2/ zexp ; 

' zsqrt is func   ' gsqrt is gauge
set-near
f{{ z=0  zsqrt f->  z=0 ->}}f
f{{  2e   0e  ?gauge }}f
f{{ -2e   0e  ?gauge }}f
f{{  0e   2e  ?gauge }}f
f{{  0e  -2e  ?gauge }}f
f{{  rt2  rt2 ?gauge }}f
f{{  rt2 -rt2 ?gauge }}f
f{{ -rt2  rt2 ?gauge }}f
f{{ -rt2 -rt2 ?gauge }}f

set-exact
f{{  z=1      zln f-> z=0        ->}}f
f{{  z=i      zln f-> 0e  pi/2   ->}}f
f{{  0e  -1e  zln f-> 0e  270arg ->}}f
f{{ -1e   0e  zln f-> 0e  pi     ->}}f
set-near
f{{ -2e   0e  zln f-> ln2 pi     ->}}f
f{{  rt2  rt2 zln f-> ln2 pi/4   ->}}f
f{{  rt2 -rt2 zln f-> ln2 315arg ->}}f
f{{ -rt2  rt2 zln f-> ln2 3pi/4  ->}}f
f{{ -rt2 -rt2 zln f-> ln2 225arg ->}}f

 1/rt2 f2/      fconstant  1/2rt2
 1/2rt2 fnegate fconstant -1/2rt2

set-exact
f{{  z=0        zexp f->  z=1            ->}}f
f{{  ln2  0e    zexp f->  2e      0e     ->}}f
set-near
f{{ -ln2  0e    zexp f->  0.5e    0e     ->}}f
f{{  0e   pi    zexp f-> -1e      0e     ->}}f
f{{  0e   pi/2  zexp f->  z=i            ->}}f
f{{  0e  -pi/2  zexp f->  z=i conjg      ->}}f
f{{  0e   pi/4  zexp f->  1/rt2   1/rt2  ->}}f
f{{  0e  -pi/4  zexp f->  1/rt2  -1/rt2  ->}}f
f{{  0e   3pi/4 zexp f-> -1/rt2   1/rt2  ->}}f
f{{  0e  -3pi/4 zexp f-> -1/rt2  -1/rt2  ->}}f
f{{  ln2  pi/4  zexp f->  rt2     rt2    ->}}f
f{{  ln2 -pi/4  zexp f->  rt2    -rt2    ->}}f
f{{ -ln2  3pi/4 zexp f-> -1/2rt2  1/2rt2 ->}}f
f{{ -ln2 -3pi/4 zexp f-> -1/2rt2 -1/2rt2 ->}}f

set-exact
\ f{{  z=0      z=0  z^ f->  z=0     ->}}f
f{{  z=1      z=0  z^ f->  z=1     ->}}f
f{{ -1e   0e  z=0  z^ f->  z=1     ->}}f
f{{  z=i      z=0  z^ f->  z=1     ->}}f
f{{  0e  -1e  z=0  z^ f->  z=1     ->}}f
f{{  rt2  rt2 z=0  z^ f->  z=1     ->}}f
f{{  rt2 -rt2 z=0  z^ f->  z=1     ->}}f
f{{ -rt2  rt2 z=0  z^ f->  z=1     ->}}f
f{{ -rt2 -rt2 z=0  z^ f->  z=1     ->}}f

: identical  ( z -- z )  ;

: z^(z=1)   z=1 z^ ;

' z^(z=1) is func   ' identical is gauge
set-near
\ f{{  z=0     ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e   0e  ?gauge }}f
f{{  z=i      ?gauge }}f
f{{  0e  -1e  ?gauge }}f
f{{  rt2  rt2 ?gauge }}f
f{{  rt2 -rt2 ?gauge }}f
f{{ -rt2  rt2 ?gauge }}f
f{{ -rt2 -rt2 ?gauge }}f

: noname  ( z -- z^(1+i2)  1+i2 z^ ;          ' noname  is func
: noname  ( z -- z^(1+i2)  zln 1+i2 z* zexp ; ' noname is gauge
f{{  z=1      ?gauge }}f
f{{ -1e   0e  ?gauge }}f
f{{  z=i      ?gauge }}f
f{{  0e  -1e  ?gauge }}f
f{{  rt2  rt2 ?gauge }}f
f{{  rt2 -rt2 ?gauge }}f
f{{ -rt2  rt2 ?gauge }}f
f{{ -rt2 -rt2 ?gauge }}f

testing  ZCOSH  ZSINH  ZTANH  ZCOTH  ZCOS  ZSIN  ZTAN  ZCOT

e 1/e f+ f2/ fconstant ch1
e 1/e f- f2/ fconstant sh1
      ch1 0e zconstant zch1
      sh1 0e zconstant zsh1
  sh1 ch1 f/ fconstant th1
  ch1 sh1 f/ fconstant cth1
      th1 0e zconstant zth1
     cth1 0e zconstant zcth1

ch1 sh1 rt2 z/f zconstant zC1
      zC1 conjg zconstant zC2
sh1 ch1 rt2 z/f zconstant zC3
      zC3 conjg zconstant zC4 

set-exact
f{{  z=0      zcosh f-> z=1  ->}}f
set-near
f{{  z=1      zcosh f-> zch1 ->}}f
f{{ -1e  0e   zcosh f-> zch1 ->}}f
f{{  0e  pi/2 zcosh f-> z=0  ->}}f
f{{  0e -pi/2 zcosh f-> z=0  ->}}f
f{{  1e  pi/4 zcosh f-> zC1  ->}}f
f{{  1e -pi/4 zcosh f-> zC2  ->}}f
f{{ -1e  pi/4 zcosh f-> zC2  ->}}f
f{{ -1e -pi/4 zcosh f-> zC1  ->}}f

set-exact
f{{  z=0      zsinh f-> z=0        ->}}f
set-near
f{{  z=1      zsinh f-> zsh1       ->}}f
f{{ -1e  0e   zsinh f-> sh1 fnegate 0e ->}}f
f{{  0e  pi/2 zsinh f-> z=i        ->}}f
f{{  0e -pi/2 zsinh f-> z=i conjg  ->}}f
f{{  1e  pi/4 zsinh f-> zC3        ->}}f
f{{  1e -pi/4 zsinh f-> zC4        ->}}f
f{{ -1e  pi/4 zsinh f-> zC4 -z     ->}}f
f{{ -1e -pi/4 zsinh f-> zC3 -z     ->}}f

1e  pi/4 zdup zsinh zswap zcosh z/ zconstant ztanhA
1e -pi/4 zdup zsinh zswap zcosh z/ zconstant ztanhB
ztanhA 1/z zconstant zcothA
ztanhB 1/z zconstant zcothB

set-exact
f{{  z=0      ztanh f-> z=0        ->}}f
set-near
f{{  z=1      ztanh f-> zth1       ->}}f
f{{ -1e  0e0  ztanh f-> zth1 -z    ->}}f
f{{  0e  pi/4 ztanh f-> z=i        ->}}f
f{{  0e -pi/4 ztanh f-> z=i conjg  ->}}f
f{{  1e  pi/4 ztanh f-> ztanhA     ->}}f
f{{  1e -pi/4 ztanh f-> ztanhB     ->}}f
f{{ -1e  pi/4 ztanh f-> ztanhB -z  ->}}f
f{{ -1e -pi/4 ztanh f-> ztanhA -z  ->}}f

set-near
f{{  z=1      zcoth f-> zcth1      ->}}f
f{{ -1e  0e0  zcoth f-> zcth1 -z   ->}}f
f{{  0e  pi/4 zcoth f-> z=i conjg  ->}}f
f{{  0e -pi/4 zcoth f-> z=i        ->}}f
f{{  1e  pi/4 zcoth f-> zcothA     ->}}f
f{{  1e -pi/4 zcoth f-> zcothB     ->}}f
f{{ -1e  pi/4 zcoth f-> zcothB -z  ->}}f
f{{ -1e -pi/4 zcoth f-> zcothA -z  ->}}f

: noname  (-i)* zcos ;   ' noname is func
' zcosh is gauge
set-exact
f{{  z=0      ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/2 ?gauge }}f
f{{  0e -pi/2 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f

: noname  i* zsin ;    ' noname is func
: noname  zsinh i* ;   ' noname is gauge
set-near
f{{  z=0      ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/2 ?gauge }}f
f{{  0e -pi/2 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f

: noname  i* ztan ;     ' noname is func
: noname  ztanh i* ;    ' noname is gauge
set-near
f{{  z=0      ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/4 ?gauge }}f
f{{  0e -pi/4 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f

: noname  i* zcot ;     ' noname is func
: noname  zcoth (-i)* ; ' noname is gauge
set-near
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/4 ?gauge }}f
f{{  0e -pi/4 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f



\ *** INVERSE FUNCTIONS

PRINCIPAL-ARG 0= [IF]
  cr .( Skipping inverse function tests.  To do those,)
  cr .(   set PRINCIPAL-ARG to true in complex.fs.)
  cr

[ELSE]
testing  ZASINH  ZACOSH  ZATANH  ZACOTH

\ Inverse hyperbolic gauges.  Note that in the principal
\ expressions for the gauges here, and in GACOS in the next
\ section, it is important to use "1E x+" instead of "z=1 z+"
\ to preserve the sign of zero on the branch cuts.  That is
\ not tested in this file (see complex-szero-test.fs).

: gasinh   ( z -- [ln[z+sqrt[z^2+1]]] )
  zdup z^2 1E x+ zsqrt z+ zln ;

: gacosh   ( z -- 2ln[sqrt[[z+1]/2]+sqrt[[z-1]/2] )
  zdup 1E x- z2/ zsqrt   zswap 1E x+ z2/ zsqrt
  z+ zln z2* ;

: gatanh   ( z -- [ln[1+z]-ln[1-z]]/2 )
  zdup 1E x+ zln   zswap znegate 1E x+ zln   z- z2/ ;

: gacoth  ( z = [ln[-1-z]-ln[1-z]]/2 )
(
Use -1e 0e Z+ instead of Z=1 Z- so -0 doesn't give the wrong
value on the ZLN principal branch cut.
)
  -z zdup -1e 0e z+ zln   zswap z=1 z+ zln   z- z2/ ;

\ Check that the gauges are inverses.  The order func(inverse)
\ used here, e.g., ZACOSH COSH in Forth reverse polish, should
\ work for all branches of the inverse when func is meromorphic.

' gasinh is inverse   ' zsinh is func
set-near
f{{ z=0        ?inverse }}f
f{{ zsh1       ?inverse }}f
f{{ zsh1 -z    ?inverse }}f
f{{ z=i        ?inverse }}f
f{{ z=i conjg  ?inverse }}f
f{{ zC3        ?inverse }}f
f{{ zC4        ?inverse }}f
f{{ zC4 -z     ?inverse }}f
f{{ zC3 -z     ?inverse }}f

' zasinh is func   ' gasinh is gauge
set-near
f{{ z=0        ?gauge }}f
f{{ zsh1       ?gauge }}f
f{{ zsh1 -z    ?gauge }}f
f{{ z=i        ?gauge }}f
f{{ z=i conjg  ?gauge }}f
f{{ zC3        ?gauge }}f
f{{ zC4        ?gauge }}f
f{{ zC4 -z     ?gauge }}f
f{{ zC3 -z     ?gauge }}f

' gacosh is inverse   ' zcosh  is func
set-near
f{{ z=1  ?inverse }}f
f{{ zch1 ?inverse }}f
f{{ z=0  ?inverse }}f
f{{ zC1  ?inverse }}f
f{{ zC2  ?inverse }}f

' zacosh is func   ' gacosh is gauge   
set-near
f{{ z=1  ?gauge }}f
f{{ zch1 ?gauge }}f
f{{ z=0  ?gauge }}f
f{{ zC1  ?gauge }}f
f{{ zC2  ?gauge }}f

' gatanh is inverse   ' ztanh is func
set-near
f{{  z=0       ?inverse }}f
f{{ zth1       ?inverse }}f
f{{ zth1 -z    ?inverse }}f
f{{ z=i        ?inverse }}f
f{{ z=i conjg  ?inverse }}f
f{{ ztanhA     ?inverse }}f
f{{ ztanhB     ?inverse }}f
f{{ ztanhB -z  ?inverse }}f
f{{ ztanhA -z  ?inverse }}f

' zatanh is func   ' gatanh is gauge
set-near
f{{ z=0        ?gauge }}f
f{{ z=i        ?gauge }}f
f{{  1e  1e    ?gauge }}f
f{{  1e -1e    ?gauge }}f
f{{ -1e  1e    ?gauge }}f
f{{ -1e -1e    ?gauge }}f
f{{ z=i conjg  ?gauge }}f
f{{ zth1       ?gauge }}f
f{{ zth1 -z    ?gauge }}f
f{{ ztanhA     ?gauge }}f
f{{ ztanhB     ?gauge }}f
f{{ ztanhB -z  ?gauge }}f
f{{ ztanhA -z  ?gauge }}f

' gacoth is inverse   ' zcoth is func
set-near
f{{ zcth1      ?inverse }}f
f{{ zcth1 -z   ?inverse }}f
f{{ z=i conjg  ?inverse }}f
f{{ z=i        ?inverse }}f
f{{ zcothA     ?inverse }}f
f{{ zcothB     ?inverse }}f
f{{ zcothB -z  ?inverse }}f
f{{ zcothA -z  ?inverse }}f

[DEFINED] zacoth [IF]
' zacoth is func   ' gacoth is gauge
set-near
f{{ zcth1      ?gauge }}f
f{{ zcth1 -z   ?gauge }}f
f{{ z=i conjg  ?gauge }}f
f{{ z=i        ?gauge }}f
f{{ zcothA     ?gauge }}f
f{{ zcothB     ?gauge }}f
f{{ zcothB -z  ?gauge }}f
f{{ zcothA -z  ?gauge }}f
[THEN]

testing  ZASIN  ZACOS  ZATAN  ZACOT

\ Inverse trigonometric gauges.  GACOS is uncouth in the sense
\ of Corless, Davenport, Jeffrey, and Watt, i.e., not related to
\ the inverse hyperbolic counterpart by the naive identity.

: gacos   ( z -- -2iln[sqrt[[1+z]/2]+isqrt[[1-z]/2]] )
  zdup 1E x+ z2/ zsqrt   zswap -z 1E x+ z2/ zsqrt
  i* z+ zln z2* (-i)*  ;

: gasin   i*    gasinh (-i)* ;
: gatan   i*    gatanh (-i)* ;
: gacot   (-i)* gacoth (-i)* ;

\ We've checked that the inverse hyperbolic gauges are inverses,
\ so where they're couthly related, it's sufficient to check one
\ case of each inverse trigonometric gauge, where both input and
\ output are full complex numbers.  We checked by hand that zC1
\ works.

' gacos is inverse   ' zcos is func
set-near
f{{ zC1 ?inverse }}f
f{{ zC2 ?inverse }}f
f{{ zC3 ?inverse }}f
f{{ zC4 ?inverse }}f
f{{ zC1 gasin zsin f-> zC1 ->}}f
f{{ zC1 gatan ztan f-> zC1 ->}}f
f{{ zC1 gacot zcot f-> zC1 ->}}f

: noname   (-i)* zcos zacos ;  ' noname is func
: noname   (-i)* zcos gacos ;  ' noname is gauge
set-near
f{{  z=0      ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/2 ?gauge }}f
f{{  0e -pi/2 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f

: noname   (-i)* zsin zasin ;  ' noname is func
: noname   (-i)* zsin gasin ;  ' noname is gauge
set-near
f{{  z=0      ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/2 ?gauge }}f
f{{  0e -pi/2 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f

: noname   (-i)* ztan zatan ;   ' noname is func
: noname   (-i)* ztan gatan ;   ' noname is gauge
set-near
f{{  z=0      ?gauge }}f
f{{  z=1      ?gauge }}f
f{{ -1e  0e   ?gauge }}f
f{{  0e  pi/2 ?gauge }}f
f{{  0e -pi/2 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f

[DEFINED] zacot [IF]
: noname   (-i)* zcot zacot ;   ' noname is func
: noname   (-i)* zcot gacot ;   ' noname is gauge
set-near
f{{  z=1     ?gauge }}f
f{{ -1e  0e  ?gauge }}f
f{{  0e  pi/2 ?gauge }}f
f{{  0e -pi/2 ?gauge }}f
f{{  1e  pi/4 ?gauge }}f
f{{  1e -pi/4 ?gauge }}f
f{{ -1e  pi/4 ?gauge }}f
f{{ -1e -pi/4 ?gauge }}f
[THEN]

[THEN] \ inverse functions

testing done
