/*  encrypt.c,v 1.5 2005/05/20 01:17:28 eagle Exp
**
**  Routines to send and receive encrypted chunks using the krb_mk_priv and
**  krb_rd_priv routines.  A chunk consists of a network long "n" (the length)
**  followed by "n" bytes of encrypted data.
*/

#include "config.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_KERBEROSIV_KRB_H
# include <kerberosIV/krb.h>
#else
# include <krb.h>
#endif

#include "kftgt.h"

int 
send_encrypted_chunk(
         char *in,
         int   in_len,
         int   sock,
         des_cblock *session,
         des_key_schedule sched,
         struct sockaddr_in *sender,
         struct sockaddr_in *receiver)
{
      char buffer[KFTGT_MAX_BUFFER*2];
      int elen;
      KRB_UINT32 nlen;

      elen = krb_mk_priv(in, buffer, in_len, sched, session, sender, receiver);

      if (elen >KFTGT_MAX_BUFFER) return -1;

      nlen = htonl(elen);

      if (
              (krb_net_write(sock,(char *)&nlen,sizeof(nlen)) != sizeof(nlen))
          ||  (krb_net_write(sock,buffer,elen) != elen)
             ) {
                return -1;
      }
      return elen;
}

int 
receive_encrypted_chunk(
         MSG_DAT *m_data,
         char *buffer,
         int   buffer_max,
         int   sock,
         des_cblock *session,
         des_key_schedule sched,
         struct sockaddr_in *sender,
         struct sockaddr_in *receiver)

{
     KRB_UINT32 nlen,elen;
     int status;

     if (krb_net_read(sock,(char *)&nlen, sizeof(nlen)) != sizeof(nlen)) {
         return -1;
     }
     elen=ntohl(nlen);

     if (elen> buffer_max)  return -1;

     if ( krb_net_read(sock, buffer, elen) != elen) return -1;

     /* decrypt */
     
     status = krb_rd_priv(buffer,elen,sched,session,sender,receiver,m_data);

     if (status != KSUCCESS) return -1;
     else return m_data->app_length;
 
}
