/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPEXTENSIONS_H
#define KFTPEXTENSIONS_H

#include <sys/time.h>
#include <time.h>

#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qvaluelist.h>
#include <qdatetime.h>
#include <qtimer.h>

#include <kurl.h>

typedef unsigned long long int filesize_t;

struct FTPEntry
{
  QString name;
  QString owner;
  QString group;
  QString link;
  QString permissions;

  filesize_t size;
  char type;
  time_t date;
  struct tm date_tm;
};

struct retry_info
{
  int max_retries;
  int delay;
};

class FTPDirectoryItem
{
public:
    FTPDirectoryItem();
    FTPDirectoryItem(FTPEntry ftpEntry);

    QString name() const;
    QString owner() const;
    QString group() const;
    QString link() const;
    QString permissions() const;

    filesize_t size() const;
    char type() const;
    time_t date() const;

    QString dateAsString();

    FTPEntry m_ftpEntry;
    
    bool operator<(const FTPDirectoryItem &item) const;
};

QDataStream &operator<< (QDataStream &s, const FTPDirectoryItem &a);
QDataStream &operator>> (QDataStream &s, FTPDirectoryItem &a);

typedef QValueList<FTPDirectoryItem> FTPDirList;

namespace KFTPWidgets {
  namespace Browser {
    class ListView;
  }
}

class FTPCacheItem
{
friend class KFTPCacheExtensions;
friend class KFTPWidgets::Browser::ListView;
friend class KFTPSession;
public:
    FTPCacheItem();
    FTPCacheItem(KURL url, FTPDirList dirList);
    
    FTPDirList getDirList() { return m_dirList; }
private:
    time_t m_age;
    KURL m_url;
    FTPDirList m_dirList;

    friend QDataStream &operator<< (QDataStream &s, const FTPCacheItem &a);
    friend QDataStream &operator>> (QDataStream &s, FTPCacheItem &a);
};

QDataStream &operator<< (QDataStream &s, const FTPCacheItem &a);
QDataStream &operator>> (QDataStream &s, FTPCacheItem &a);

typedef QValueList<FTPCacheItem> FTPListCache;

/**
@author Jernej Kos
*/
class KFTPCacheExtensions
{
public:
    KFTPCacheExtensions();
    ~KFTPCacheExtensions();

    // Function for saving/loading the cache from file
    void cacheSaveToFile(const QString &filename);
    void cacheLoadFromFile(const QString &filename);

    void listCache(KURL url, FTPDirList list);
    FTPCacheItem *listGetFromCache(KURL url);
    FTPDirectoryItem *listGetFileFromCache(KURL url);
    void listRemoveFromCache(KURL url);
private:
    FTPListCache m_listCache;

    friend KFTPCacheExtensions &FTPCache();
};

KFTPCacheExtensions &FTPCache();

#endif

