/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPNETWORKSFTPSOCKET_H
#define KFTPNETWORKSFTPSOCKET_H

// LibSSH includes
#include "ssh/libssh.h"
#include "ssh/sftp.h"

#include "socket.h"

namespace KFTPNetwork {

/**
  * This class represents the SFTP socket implementation.
  *
  * @author Jernej Kos
  */
class SftpSocket : public Socket
{
Q_OBJECT
public:
    SftpSocket(QObject *parent);
    
    FTPDirList *dirList(const KURL &url, bool ignoreCache = false);
    
    void get(KURL source, KURL destination);
    void put(const KURL &source, const KURL &destination);
    void remove(const KURL &url);
    void rename(const KURL &source, const KURL &destination);
    void chmod(const KURL &url, int mode);
    void mkdir(const KURL &url);
    void fxpTransfer(const KURL&, const KURL&, Socket*) {}
    QString getLastDir() { return m_lastDir; }
    
    void stat(const KURL &url);
    
    bool isEncrypted() { return true; }
    int getFeatures();
    void initConfig();
protected:
    int protoConnect();
    void protoDisconnect();
    
    int protoLogin();
    bool protoDirList(const KURL &url);
    int protoCwd(const QString &dir);
    int protoCwdError(const QString &dir);
    int protoRmdir(const QString &dir);
    int protoDelete(const QString &path);
    int protoMkdir(const QString &dir);
    int protoRename(const QString &source, const QString &destination);
    int protoGet(const QString &source, const QString &destination);
    int protoPut(const QString &source, const QString &destination);
    int protoSize(const QString &file);
    void protoSendRawCommand(const QString&) {}
    FTPEntry protoStat(const KURL &url);
    
    void protoCloseDir();
    
    // Implementation specific methods
    int keyboardInteractiveLogin();
private:
    SSH_SESSION *m_sshSession;
    SSH_OPTIONS *m_sshOptions;
    SFTP_SESSION *m_sftpSession;
    SFTP_DIR *m_curDir;
    
    /* Directory navigation */
    QString m_defDir;
    QString m_lastDir;
    
    filesize_t m_lastSize;
    
    QString posixToString(int permissions);
    int intToPosix(int permissions);
};

}

#endif
