/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef _KFTPGRABBER_H_
#define _KFTPGRABBER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qtimer.h>

#include <kmainwindow.h>

#include "kftpclientthread.h"
#include "kftpmainactions.h"

class KFTPSystemTray;
class KFTPBookmarkEditorListView;
class KFTPZeroConfListView;

namespace KFTPWidgets {
namespace Bookmarks {
  class Sidebar;
}

namespace ServerManagement {
  class Sidebar;
}

  class Sidebar;
  class TrafficGraph;
  class QueueView;
}

/**
 * @short Application Main Window
 * @author Jernej Kos <kostko@jweb-network.net>
 */
class KFTPGrabber : public KMainWindow
{
Q_OBJECT
public:
    KFTPGrabber();
    virtual ~KFTPGrabber();

    void initTrafficGraph();
    void initStatusBar();
    void initMainView();    
    void initSidebars();
protected:
    bool queryClose();
private:
    QTimer *m_graphTimer;
    KFTPMainActions *m_actions;

    KActionMenu *m_bookmarkMenu;
    KActionMenu *m_zeroconfMenu;
    KActionMenu *m_walletMenu;

    KFTPWidgets::Sidebar *m_leftSidebar;
    KFTPWidgets::Sidebar *m_bottomSidebar;
    
    KFTPWidgets::Bookmarks::Sidebar *m_bookmarkSidebar;
    KFTPWidgets::ServerManagement::Sidebar *m_adminSidebar;
    
    KFTPWidgets::TrafficGraph *m_trafficGraph;
    
    KFTPZeroConfListView *m_zeroconfSidebar;
    KFTPWidgets::QueueView *m_queueView;
public slots:
    void initBookmarkMenu();
    void slotQuickConnect(QString title=QString(), QString host=QString(), int port=21);
private slots:
    void appShutdown();
    void showBookmarkEditor();
    void slotUpdateStatusBar();
    void slotReadBookmarks();
    void slotUpdateTrafficGraph();
};

#endif // _KFTPGRABBER_H_
