/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "mainwindow.h"
#include "misc/config.h"

#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <ksplashscreen.h>

#include "kftpsession.h"

static const char description[] =
    I18N_NOOP("KFTPGrabber - an FTP client for KDE");

static const char version[] = "0.8.0";

static KCmdLineOptions options[] =
{
    { "+[url]", I18N_NOOP("An optional URL to connect to"), 0},
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kftpgrabber", I18N_NOOP("KFTPGrabber"), version, description,
                     KAboutData::License_GPL, "(C) 2007, The KFTPGrabber developers", 0, "http://www.kftp.org");
    about.addAuthor("Jernej Kos", I18N_NOOP("Lead developer"), "kostko@jweb-network.net");
    about.addAuthor("Markus Brüffer", I18N_NOOP("Developer"), "markus@brueffer.de");
    
    about.addCredit("Aris Adamantiadis", I18N_NOOP("LibSSH code"), "aris@0xbadc0de.be");
    about.addCredit("Anthony D. Urso", I18N_NOOP("otpCalc code"));
    about.addCredit("Kopete Developers", I18N_NOOP("KopeteBalloon popup code"), "kopete-devel@kde.org");
    about.addCredit("KSysGuard Developers", I18N_NOOP("Traffic graph widget"), "cs@kde.org");
    about.addCredit("Bob Ziuchkovski", I18N_NOOP("Icon design"), "ziuchkov@uiuc.edu");
    about.addCredit("Tobias Ussing", I18N_NOOP("Testing and debugging"), "thehole@mail.seriesdb.com");
    about.addCredit("Lee Joseph", I18N_NOOP("Testing and debugging"), "cyberspy1@hotmail.com");
    about.addCredit("Tim Kosse", I18N_NOOP("Directory parser code"), "tim.kosse@gmx.de");
    about.addCredit("Peter Penz", I18N_NOOP("Listview column handling code"), "peter.penz@gmx.at");

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication app;
    
    if (app.isRestored()) {
      RESTORE(MainWindow);
    } else {
      MainWindow *mainWindow = 0;
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

      KSplashScreen *splash = 0L;
      QString splashPath = locate("appdata", "kftpgrabber-logo.png");
      if (!KFTPCore::Config::startMinimized() && KFTPCore::Config::showSplash()) {
        // Show the splash screen
        if (!splashPath.isNull()) {
          QPixmap splashImage = QPixmap(splashPath);
          splash = new KSplashScreen(splashImage);
          splash->setMaximumWidth(400);
          splash->show();
        }
      }
      
      mainWindow = new MainWindow();
      app.setMainWidget(mainWindow);
      
      if (!KFTPCore::Config::startMinimized())
        mainWindow->show();
        
      // Check if an URL was passed as a command line argument
      if (args->count() == 1) {
        KURL remoteUrl = args->url(0);
        
        if (!remoteUrl.isLocalFile()) {
          if (!remoteUrl.port())
            remoteUrl.setPort(21);
            
          if (!remoteUrl.hasUser())
            remoteUrl.setUser("anonymous");
            
          if (!remoteUrl.hasPass()) {
            if (!KFTPCore::Config::anonMail().isEmpty())
              remoteUrl.setPass(KFTPCore::Config::anonMail());
            else
              remoteUrl.setPass("userlogin@anonymo.us");
          }

          KFTPSession::Manager::self()->spawnRemoteSession(KFTPSession::IgnoreSide, remoteUrl);
        }
      }
        
      if (splash != 0L) {
        splash->finish(mainWindow);
        delete splash;
      }
      
      args->clear();
    }
    
    return app.exec();
}

