
#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

from qt import *
from kfile import KFileDialog
from kdeui import KMessageBox
from iconpaths import *

class ConfigurationDialog(QObject):
	def __init__(self,configHandler,languageHandler):
		QObject.__init__(self)
		
		self.configHandler = configHandler
		self.languageHandler = languageHandler
		
		self.itsWindow = QTabDialog(None,"configWindow",False,Qt.WStyle_ContextHelp)
		self.itsWindow.setCaption(self.languageHandler.Translate("Configure KGmailNotifier"))
		self.itsWindow.setIcon(QPixmap(ICON_RED))
		
		# General tab #######################################################################################
		self.generalTab = QWidget(None,"generalTab")
		
		# Set up the layout
		self.generalLayout = QVBoxLayout(self.generalTab,20,15,"generalLayout")
		
		
		# Username & Password
		self.accountLayout = QGridLayout(self.generalLayout,2,2,30,"accountLayout")
		
		# Username
		self.usernameLabel = QLabel(self.generalTab,"Username")
		self.usernameLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.usernameLabel.setText(self.languageHandler.Translate("Username:"))
		
		self.usernameInputField = QLineEdit(self.generalTab, "usernameInputField")
		
		self.usernameDescription = self.languageHandler.Translate("Your username (including @gmail.com)")
		QWhatsThis.add(self.usernameLabel,self.usernameDescription)
		QWhatsThis.add(self.usernameInputField,self.usernameDescription)
		
		self.accountLayout.addWidget(self.usernameLabel,0,0)
		self.accountLayout.addWidget(self.usernameInputField,0,1)
		
		# Password
		self.passwordLabel = QLabel(self.generalTab,"Password")
		self.passwordLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.passwordLabel.setText(self.languageHandler.Translate("Password:"))
		
		self.passwordInputField = QLineEdit(self.generalTab, "passwordInputField")
		self.passwordInputField.setEchoMode(QLineEdit.Password)
			
		self.passwordDescription = self.languageHandler.Translate("Your password")
		QWhatsThis.add(self.passwordLabel,self.passwordDescription)
		QWhatsThis.add(self.passwordInputField,self.passwordDescription)
			
		self.accountLayout.addWidget(self.passwordLabel,1,0)
		self.accountLayout.addWidget(self.passwordInputField,1,1)
		
		
		# Save password?
		self.savePasswordCheckBox = QCheckBox(self.languageHandler.Translate("Save password"),self.generalTab,"savePasswordCheckBox")
		self.savePasswordLayout = QHBoxLayout(self.generalLayout,-1,"savePasswordLayout")
		self.savePasswordLayout.addWidget(self.savePasswordCheckBox)	
		self.savePasswordDescription = "<p>%s<br><br><b>%s </b>%s <b>%s</b></p>" % (self.languageHandler.Translate("Do you want your password to be saved in the configuration file?"),self.languageHandler.Translate("Note:"),self.languageHandler.Translate("Even though it will be encrypted, this may not be completely secure."),self.languageHandler.Translate("Use at your own risk!"))
		QWhatsThis.add(self.savePasswordCheckBox,QString(self.savePasswordDescription))
		
		
		# Check Interval
		self.checkIntervalLayout = QHBoxLayout(self.generalLayout,-1,"checkIntervalLayout")
		
		self.checkIntervalLabel = QLabel(self.generalTab,"Interval")
		self.checkIntervalLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.checkIntervalLabel.setText(self.languageHandler.Translate("Check interval (in sec):"))
		
		self.checkIntervalSpinBox = QSpinBox(self.generalTab, "checkIntervalSpinBox")
		self.checkIntervalSpinBox.setMinimumWidth(80)
		self.checkIntervalSpinBox.setMaximumWidth(80)
		self.checkIntervalSpinBox.setMinValue(10)
		self.checkIntervalSpinBox.setMaxValue(1000)
		self.checkIntervalSpinBox.setLineStep(1)
			
		self.checkIntervalDescription = self.languageHandler.Translate("The interval in which to check for new mail (in seconds)")
		QWhatsThis.add(self.checkIntervalLabel,self.checkIntervalDescription)
		QWhatsThis.add(self.checkIntervalSpinBox,self.checkIntervalDescription)
		
		self.checkIntervalLayout.addWidget(self.checkIntervalLabel)
		self.checkIntervalLayout.addWidget(self.checkIntervalSpinBox,0,Qt.AlignRight)
		
		
		# Browser path
		self.browserPathLayout = QHBoxLayout(self.generalLayout,-1,"generalLayout")
		
		self.browserPathLabel = QLabel(self.generalTab,"browserPath")
		self.browserPathLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.browserPathLabel.setText(self.languageHandler.Translate("Path to browser:"))
		
		self.browserPathLayout.addWidget(self.browserPathLabel)
		
		self.browserObjectsLayout = QHBoxLayout(self.browserPathLayout,-1,"browserLayout")
		self.browserPathButton = QPushButton("...", self.generalTab, "browserPathButton")
		self.browserPathButton.setMaximumWidth(25)
		self.connect(self.browserPathButton,SIGNAL("clicked()"),self.ShowBrowserOpenFileDialog)

		self.browserPathInputField = QLineEdit(self.generalTab, "browserPathInputField")
		
		self.browserPathDescription = self.languageHandler.Translate("The path to your web browser (e.g. /usr/bin/firefox)")
		QWhatsThis.add(self.browserPathLabel,self.browserPathDescription)
		QWhatsThis.add(self.browserPathInputField,self.browserPathDescription)
		
		self.browserObjectsLayout.addWidget(self.browserPathButton)
		self.browserObjectsLayout.addWidget(self.browserPathInputField)
		
		
		# Language
		self.languageLayout = QHBoxLayout(self.generalLayout,-1,"languageLayout")
		
		self.languageLabel = QLabel(self.generalTab,"languageLabel")
		self.languageLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.languageLabel.setText(self.languageHandler.Translate("Language:"))
		
		self.languageBox = QComboBox(self.generalTab, "languageBox")
		self.languageBox.setMaximumWidth(150)
		self.languageBox.setMinimumWidth(150)
		
		self.languageList = self.languageHandler.GetLanguageList()
		for i in range(len(self.languageList)):
			self.languageBox.insertItem(self.languageList[i])
		self.languageBox.setCurrentText(self.configHandler.GetLanguage())
		
			
		self.languageDescription = self.languageHandler.Translate("Please select your language.")
		QWhatsThis.add(self.languageLabel,self.languageDescription)
		QWhatsThis.add(self.languageBox,self.languageDescription)
		
		self.languageLayout.addWidget(self.languageLabel)
		self.languageLayout.addWidget(self.languageBox)
		
		
		
		# Appearance tab ########################################################################################
		self.appearanceTab = QWidget(None,"appearanceTab")
		
		# Set up the layout
		self.appearanceLayout = QVBoxLayout(self.appearanceTab,20,15,"appearanceLayout")
		
		
		# Horizontal offset
		self.horizontalOffsetLayout = QHBoxLayout(self.appearanceLayout,-1,"horizontalOffsetLayout")
		
		self.horizontalOffsetLabel = QLabel(self.appearanceTab,"horizontalOffsetLabel")
		self.horizontalOffsetLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.horizontalOffsetLabel.setText(self.languageHandler.Translate("Horizontal offset:"))
		
		self.horizontalOffsetSpinBox = QSpinBox(self.appearanceTab, "horizontalOffsetSpinBox")
		self.horizontalOffsetSpinBox.setMinimumWidth(80)
		self.horizontalOffsetSpinBox.setMaximumWidth(80)
		self.horizontalOffsetSpinBox.setMinValue(0)
		self.horizontalOffsetSpinBox.setMaxValue(10000)
		self.horizontalOffsetSpinBox.setLineStep(1)
			
		self.horizontalOffsetDescription = self.languageHandler.Translate("Horizontal offset of the popup window in pixels (from the right)")
		QWhatsThis.add(self.horizontalOffsetLabel,self.horizontalOffsetDescription)
		QWhatsThis.add(self.horizontalOffsetSpinBox,self.horizontalOffsetDescription)
		
		self.horizontalOffsetLayout.addWidget(self.horizontalOffsetLabel)
		self.horizontalOffsetLayout.addWidget(self.horizontalOffsetSpinBox,0,Qt.AlignRight)
		

		# Vertical offset
		self.verticalOffsetLayout = QHBoxLayout(self.appearanceLayout,-1,"verticalOffsetLayout")
		
		self.verticalOffsetLabel = QLabel(self.appearanceTab,"verticalOffsetLabel")
		self.verticalOffsetLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.verticalOffsetLabel.setText(self.languageHandler.Translate("Vertical offset:"))
		
		self.verticalOffsetSpinBox = QSpinBox(self.appearanceTab, "verticalOffsetSpinBox")
		self.verticalOffsetSpinBox.setMinimumWidth(80)
		self.verticalOffsetSpinBox.setMaximumWidth(80)
		self.verticalOffsetSpinBox.setMinValue(0)
		self.verticalOffsetSpinBox.setMaxValue(10000)
		self.verticalOffsetSpinBox.setLineStep(1)
		
		self.verticalOffsetDescription = self.languageHandler.Translate("Vertical offset of the popup window in pixels (from the bottom)")
		QWhatsThis.add(self.verticalOffsetLabel,self.verticalOffsetDescription)
		QWhatsThis.add(self.verticalOffsetSpinBox,self.verticalOffsetDescription)
		
		self.verticalOffsetLayout.addWidget(self.verticalOffsetLabel)
		self.verticalOffsetLayout.addWidget(self.verticalOffsetSpinBox,0,Qt.AlignRight)
		
		
		# Popup timeout
		self.popupTimeoutLayout = QHBoxLayout(self.appearanceLayout,-1,"popupTimeoutLayout")
		
		self.popupTimeoutLabel = QLabel(self.appearanceTab,"popupTimeoutLabel")
		self.popupTimeoutLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.popupTimeoutLabel.setText(self.languageHandler.Translate("Popup timeout (in sec):"))
		
		self.popupTimeoutSpinBox = QSpinBox(self.appearanceTab, "popupTimeoutSpinBox")
		self.popupTimeoutSpinBox.setMinimumWidth(80)
		self.popupTimeoutSpinBox.setMaximumWidth(80)
		self.popupTimeoutSpinBox.setMinValue(1)
		self.popupTimeoutSpinBox.setMaxValue(100)
		self.popupTimeoutSpinBox.setLineStep(1)
		
		self.popupTimeoutDescription = self.languageHandler.Translate("How long should the popup window stay up?")
		QWhatsThis.add(self.popupTimeoutLabel,self.popupTimeoutDescription)
		QWhatsThis.add(self.popupTimeoutSpinBox,self.popupTimeoutDescription)
		
		self.popupTimeoutLayout.addWidget(self.popupTimeoutLabel)
		self.popupTimeoutLayout.addWidget(self.popupTimeoutSpinBox,0,Qt.AlignRight)
		
		
		# Popup animation
		self.animatePopupLayout = QHBoxLayout(self.appearanceLayout,-1,"animatePopupLayout")
		
		self.animatePopupCheckBox = QCheckBox(self.languageHandler.Translate("Animate popup"),self.appearanceTab,"animatePopupCheckBox")
		self.connect(self.animatePopupCheckBox,SIGNAL("toggled(bool)"),self.AnimatePopupCheckBoxToggled)
			
		self.animatePopupDescription = self.languageHandler.Translate("Do you want the popup window to be animated?")
		QWhatsThis.add(self.animatePopupCheckBox,self.animatePopupDescription)
		
		self.animatePopupLayout.addWidget(self.animatePopupCheckBox)
		
		
		# Animation delay
		self.animationLayout = QHBoxLayout(self.appearanceLayout,-1,"animationLayout")
		
		self.animationDelayLabel = QLabel(self.appearanceTab,"animationDelayLabel")
		self.animationDelayLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.animationDelayLabel.setText(self.languageHandler.Translate("Animation delay (in ms):"))
		
		self.animationDelaySpinBox = QSpinBox(self.appearanceTab, "animationDelaySpinBox")
		self.animationDelaySpinBox.setMinimumWidth(80)
		self.animationDelaySpinBox.setMaximumWidth(80)
		self.animationDelaySpinBox.setMinValue(1)
		self.animationDelaySpinBox.setMaxValue(100)
		self.animationDelaySpinBox.setLineStep(1)
			
		self.animationDelayDescription = self.languageHandler.Translate("Milliseconds between animation updates")
		QWhatsThis.add(self.animationDelayLabel,self.animationDelayDescription)
		QWhatsThis.add(self.animationDelaySpinBox,self.animationDelayDescription)
		
		self.animationLayout.insertSpacing(-1,30)
		self.animationLayout.addWidget(self.animationDelayLabel)
		self.animationLayout.addWidget(self.animationDelaySpinBox)
		
		
		# Popup direction
		self.directionLayout = QHBoxLayout(self.appearanceLayout,-1,"directionLayout")
		
		self.directionLabel = QLabel(self.appearanceTab,"directionLabel")
		self.directionLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.directionLabel.setText(self.languageHandler.Translate("Popup direction:"))
		
		self.directionLayout.insertSpacing(-1,30)
		self.directionLayout.addWidget(self.directionLabel)
		
		self.directionRadioButtonLayout = QHBoxLayout(self.directionLayout,-1,"directionRadioButtonLayout")		
		self.directionUpRadioButton = QRadioButton(self.languageHandler.Translate("Up"),self.appearanceTab, "directionUpRadioButton")
		self.directionDownRadioButton = QRadioButton(self.languageHandler.Translate("Down"),self.appearanceTab, "directionDownRadioButton")
		self.connect(self.directionUpRadioButton,SIGNAL("clicked()"),self.DirectionUpRadioButtonClicked)
		self.connect(self.directionDownRadioButton,SIGNAL("clicked()"),self.DirectionDownRadioButtonClicked)
		
		self.directionDescription = self.languageHandler.Translate("In which direction should the window popup?")
		QWhatsThis.add(self.directionLabel,self.directionDescription)
		QWhatsThis.add(self.directionUpRadioButton,self.directionDescription)
		QWhatsThis.add(self.directionDownRadioButton,self.directionDescription)
	
		self.directionRadioButtonLayout.insertSpacing(-1,100)
		self.directionRadioButtonLayout.addWidget(self.directionUpRadioButton)
		self.directionRadioButtonLayout.addWidget(self.directionDownRadioButton)
		
		
		# Notification tab ########################################################################################
		self.notificationTab = QWidget(None,"notificationTab")
		
		# Set up the layout
		self.notificationLayout = QVBoxLayout(self.notificationTab,30,15,"notificationLayout")
		
		
		# Enable sound?
		self.enableSoundLayout = QHBoxLayout(self.notificationLayout,-1,"enableSoundLayout")
		
		self.enableSoundCheckBox = QCheckBox(self.languageHandler.Translate("Enable sound"),self.notificationTab,"enableSoundCheckBox")
		self.connect(self.enableSoundCheckBox,SIGNAL("toggled(bool)"),self.EnableSoundCheckBoxToggled)

		self.enableSoundDescription = self.languageHandler.Translate("Do you want to get an audible signal when you have received new mail?")
		QWhatsThis.add(self.enableSoundCheckBox,self.enableSoundDescription)
		
		self.notificationLayout.addWidget(self.enableSoundCheckBox,0,1)
	
		
		# Sound to play
		self.soundToPlayLayout = QHBoxLayout(self.notificationLayout,-1,"soundToPlayLayout")
		
		self.soundToPlayLabel = QLabel(self.notificationTab,"soundToPlayLabel")
		self.soundToPlayLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.soundToPlayLabel.setText(self.languageHandler.Translate("File to play:"))
				
		self.soundToPlayLayout.insertSpacing(-1,30)
		self.soundToPlayLayout.addWidget(self.soundToPlayLabel)

		self.soundToPlayObjectsLayout = QHBoxLayout(self.soundToPlayLayout,-1,"soundToPlayObjectsLayout")
		
		self.selectFileToPlayButton = QPushButton("...", self.notificationTab, "selectFileToPlayButton")
		self.selectFileToPlayButton.setMaximumWidth(25)
		self.connect(self.selectFileToPlayButton,SIGNAL("clicked()"),self.ShowAudioOpenFileDialog)

		self.soundToPlayInputField = QLineEdit(self.notificationTab, "soundToPlayInputField")
			
		self.soundToPlayDescription = self.languageHandler.Translate("The audio file to be played when new mail has arrived")
		QWhatsThis.add(self.soundToPlayLabel,self.soundToPlayDescription)
		QWhatsThis.add(self.soundToPlayInputField,self.soundToPlayDescription)
		
		self.soundToPlayObjectsLayout.addWidget(self.selectFileToPlayButton)
		self.soundToPlayObjectsLayout.addWidget(self.soundToPlayInputField)
		
		
		# Enable LEDs?
		self.enableLedsLayout = QHBoxLayout(self.notificationLayout,-1,"enableLedsLayout")
		
		self.enableLedsCheckBox = QCheckBox(self.languageHandler.Translate("Enable LEDs"),self.notificationTab,"enableLedsCheckBox")
		self.connect(self.enableLedsCheckBox,SIGNAL("toggled(bool)"),self.EnableLedsCheckBoxToggled)
		
		self.enableLedsDescription = self.languageHandler.Translate("Do you want to enable support for your mail LED?")
		QWhatsThis.add(self.enableLedsCheckBox,self.enableLedsDescription)
		
		self.notificationLayout.addWidget(self.enableLedsCheckBox)
		
		
		# LED On Command
		self.ledOnCommandLayout = QHBoxLayout(self.notificationLayout,-1,"ledOnCommandLayout")
		
		self.ledOnCommandLabel = QLabel(self.notificationTab,"ledOnCommandLabel")
		self.ledOnCommandLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.ledOnCommandLabel.setText(self.languageHandler.Translate("Command for LED on:"))
		
		self.ledOnCommandInputField = QLineEdit(self.notificationTab, "ledOnCommandInputField")
			
		self.ledOnCommandDescription = self.languageHandler.Translate("The command for turning on your mail LED") + "\n" + self.languageHandler.Translate("(e.g. echo 1 >> /proc/acpi/asus/mled)")
		QWhatsThis.add(self.ledOnCommandLabel,self.ledOnCommandDescription)
		QWhatsThis.add(self.ledOnCommandInputField,self.ledOnCommandDescription)
		
		self.ledOnCommandLayout.insertSpacing(-1,30)
		self.ledOnCommandLayout.addWidget(self.ledOnCommandLabel)
		self.ledOnCommandLayout.addWidget(self.ledOnCommandInputField)
		
		
		# LED Off Command
		self.ledOffCommandLayout = QHBoxLayout(self.notificationLayout,-1,"ledOffCommandLayout")
		
		self.ledOffCommandLabel = QLabel(self.notificationTab,"ledOffCommandLabel")
		self.ledOffCommandLabel.setAlignment(QLabel.SingleLine | QLabel.AlignLeft | QLabel.AlignVCenter)
		self.ledOffCommandLabel.setText(self.languageHandler.Translate("Command for LED off:"))
		
		self.ledOffCommandInputField = QLineEdit(self.notificationTab, "ledOffCommandInputField")
			
		self.ledOffCommandDescription = self.languageHandler.Translate("The command for turning off your mail LED") + "\n" + self.languageHandler.Translate("(e.g. echo 0 >> /proc/acpi/asus/mled)")
		QWhatsThis.add(self.ledOffCommandLabel,self.ledOffCommandDescription)
		QWhatsThis.add(self.ledOffCommandInputField,self.ledOffCommandDescription)
		
		self.ledOffCommandLayout.insertSpacing(-1,30)
		self.ledOffCommandLayout.addWidget(self.ledOffCommandLabel)
		self.ledOffCommandLayout.addWidget(self.ledOffCommandInputField)
		
		
		# Configuration window ############################################################################
		
		# Add everything to the window
		self.itsWindow.addTab(self.generalTab, self.languageHandler.Translate("General"))
		self.itsWindow.addTab(self.appearanceTab, self.languageHandler.Translate("Appearance"))
		self.itsWindow.addTab(self.notificationTab, self.languageHandler.Translate("Notification"))
		
		self.itsWindow.setOkButton()
		self.itsWindow.setCancelButton()
		self.itsWindow.setApplyButton()
		
		self.connect(self.itsWindow,SIGNAL("applyButtonPressed()"),self.SaveConfiguration)
		
		# Set up the window
		self.itsHintSize = self.itsWindow.sizeHint()
		self.itsSize = QSize()
		self.itsSize.setHeight(self.itsHintSize.height())
		self.itsSize.setWidth(self.itsHintSize.height() * 1.2)
		self.itsWindow.resize(self.itsSize)
		self.desktop = QApplication.desktop()
		self.itsXPos = (self.desktop.width() / 2) - (self.itsWindow.width() / 2)
		self.itsYPos = (self.desktop.height() / 2) - (self.itsWindow.height() / 2)
		self.itsWindow.move(QPoint(self.itsXPos,self.itsYPos))
		
		
		
	def Show(self):
		# Seed entries in configuration elements
		self.usernameInputField.setText(self.configHandler.GetUsername())
		self.passwordInputField.setText(self.configHandler.GetPassword())
		self.savePasswordCheckBox.setChecked(self.configHandler.GetSavePassword())
		self.browserPathInputField.setText(self.configHandler.GetBrowserPath())
		
		self.enableSoundCheckBox.setChecked(self.configHandler.GetSoundEnabled())
		if self.configHandler.GetSoundEnabled():
			self.soundToPlayLabel.setEnabled(True)
			self.selectFileToPlayButton.setEnabled(True)
			self.soundToPlayInputField.setEnabled(True)
		else:
			self.soundToPlayLabel.setEnabled(False)
			self.selectFileToPlayButton.setEnabled(False)
			self.soundToPlayInputField.setEnabled(False)
		self.soundToPlayInputField.setText(self.configHandler.GetFileToPlay())
		
		self.checkInterval = self.configHandler.GetCheckInterval()
		if self.checkInterval < self.checkIntervalSpinBox.minValue():
			self.checkInterval = self.checkIntervalSpinBox.minValue()
		self.checkIntervalSpinBox.setValue(self.checkInterval)
		
		self.verticalOffset = self.configHandler.GetVerticalOffset()
		if self.verticalOffset < self.verticalOffsetSpinBox.minValue():
			self.verticalOffset = self.verticalOffsetSpinBox.minValue()
		self.verticalOffsetSpinBox.setValue(self.verticalOffset)
		
		self.horizontalOffset = self.configHandler.GetHorizontalOffset()
		if self.horizontalOffset < self.horizontalOffsetSpinBox.minValue():
			self.horizontalOffset = self.horizontalOffsetSpinBox.minValue()
		self.horizontalOffsetSpinBox.setValue(self.horizontalOffset)
		
		self.popupTimeout = self.configHandler.GetPopupTimeout()
		if self.popupTimeout < self.popupTimeoutSpinBox.minValue():
			self.popupTimeout = self.popupTimeoutSpinBox.minValue()
		self.popupTimeoutSpinBox.setValue(self.popupTimeout)
		
		self.animatePopupCheckBox.setChecked(self.configHandler.GetPopupAnimated())
		
		if self.configHandler.GetPopupAnimated():
			self.animationDelayLabel.setEnabled(True)
			self.animationDelaySpinBox.setEnabled(True)
			self.directionLabel.setEnabled(True)
			self.directionUpRadioButton.setEnabled(True)
			self.directionDownRadioButton.setEnabled(True)
		else:
			self.animationDelayLabel.setEnabled(False)
			self.animationDelaySpinBox.setEnabled(False)
			self.directionLabel.setEnabled(False)
			self.directionUpRadioButton.setEnabled(False)
			self.directionDownRadioButton.setEnabled(False)
		
		self.animationDelay = self.configHandler.GetAnimationDelay()
		if self.animationDelay < self.animationDelaySpinBox.minValue():
			self.animationDelay = self.animationDelaySpinBox.minValue()
		self.animationDelaySpinBox.setValue(self.animationDelay)
		
		self.popupDirection = self.configHandler.GetPopupDirection()
		if self.popupDirection == "Down":
			self.directionDownRadioButton.setChecked(True)
			self.directionUpRadioButton.setChecked(False)
		else:
			self.directionUpRadioButton.setChecked(True)
			self.directionDownRadioButton.setChecked(False)
		
		self.enableLedsCheckBox.setChecked(self.configHandler.GetLedsEnabled())
		
		if self.configHandler.GetLedsEnabled():
			self.ledOnCommandLabel.setEnabled(True)
			self.ledOnCommandInputField.setEnabled(True)
			self.ledOffCommandLabel.setEnabled(True)
			self.ledOffCommandInputField.setEnabled(True)
		else:
			self.ledOnCommandLabel.setEnabled(False)
			self.ledOnCommandInputField.setEnabled(False)
			self.ledOffCommandLabel.setEnabled(False)
			self.ledOffCommandInputField.setEnabled(False)
			
		self.ledOnCommandInputField.setText(self.configHandler.GetLedOnCommand())
		self.ledOffCommandInputField.setText(self.configHandler.GetLedOffCommand())
		
		self.itsWindow.show()
		
		
	def ShowAudioOpenFileDialog(self):
		self.fileToPlay = KFileDialog.getOpenFileName(self.soundToPlayInputField.text(),"*.wav *.ogg *.mp3",self.itsWindow,self.languageHandler.Translate("Select a file"))
		if self.fileToPlay != QString.null:
			if QFile.exists(self.fileToPlay):
				self.soundToPlayInputField.setText(self.fileToPlay)


	def ShowBrowserOpenFileDialog(self):
		self.browserPath = KFileDialog.getOpenFileName(self.browserPathInputField.text(),"",self.itsWindow,self.languageHandler.Translate("Select a file"))
		if self.browserPath != QString.null:
			if QFile.exists(self.browserPath):
				self.browserPathInputField.setText(self.browserPath)


	def EnableSoundCheckBoxToggled(self,state):
		if state == True:
			self.soundToPlayLabel.setEnabled(True)
			self.soundToPlayInputField.setEnabled(True)
			self.selectFileToPlayButton.setEnabled(True)
		else:
			self.soundToPlayLabel.setEnabled(False)
			self.soundToPlayInputField.setEnabled(False)
			self.selectFileToPlayButton.setEnabled(False)


	def AnimatePopupCheckBoxToggled(self,state):
		if state == True:
			self.animationDelayLabel.setEnabled(True)
			self.animationDelaySpinBox.setEnabled(True)
			self.directionLabel.setEnabled(True)
			self.directionUpRadioButton.setEnabled(True)
			self.directionDownRadioButton.setEnabled(True)
		else:
			self.animationDelayLabel.setEnabled(False)
			self.animationDelaySpinBox.setEnabled(False)
			self.directionLabel.setEnabled(False)
			self.directionUpRadioButton.setEnabled(False)
			self.directionDownRadioButton.setEnabled(False)


	def DirectionUpRadioButtonClicked(self):
		self.directionUpRadioButton.setChecked(True)
		self.directionDownRadioButton.setChecked(False)
		
	
	def DirectionDownRadioButtonClicked(self):
		self.directionDownRadioButton.setChecked(True)
		self.directionUpRadioButton.setChecked(False)
		

	def EnableLedsCheckBoxToggled(self,state):
		if state == True:
			self.ledOnCommandLabel.setEnabled(True)
			self.ledOnCommandInputField.setEnabled(True)
			self.ledOffCommandLabel.setEnabled(True)
			self.ledOffCommandInputField.setEnabled(True)
		else:
			self.ledOnCommandLabel.setEnabled(False)
			self.ledOnCommandInputField.setEnabled(False)
			self.ledOffCommandLabel.setEnabled(False)
			self.ledOffCommandInputField.setEnabled(False)


	def SaveConfiguration(self):
		# Store configuration data
		self.configHandler.SetUsername(self.usernameInputField.text())
		self.configHandler.SetPassword(self.passwordInputField.text())
		self.configHandler.SetSavePassword(self.savePasswordCheckBox.isChecked())
		self.configHandler.SetBrowserPath(self.browserPathInputField.text())
		if self.languageBox.currentText() != self.configHandler.GetLanguage():
			KMessageBox.information(None, self.languageHandler.Translate("The language settings were changed. You must restart KGmailNotifier for changes to take effect."), self.languageHandler.Translate("Language changed"), "NotifyAgain")
		self.configHandler.SetLanguage(self.languageBox.currentText())
		self.configHandler.SetCheckInterval(self.checkIntervalSpinBox.value())
		self.configHandler.SetVerticalOffset(self.verticalOffsetSpinBox.value())
		self.configHandler.SetHorizontalOffset(self.horizontalOffsetSpinBox.value())
		self.configHandler.SetSoundEnabled(self.enableSoundCheckBox.isChecked())
		self.configHandler.SetFileToPlay(self.soundToPlayInputField.text())
		self.configHandler.SetPopupTimeout(self.popupTimeoutSpinBox.value())
		self.configHandler.SetPopupAnimated(self.animatePopupCheckBox.isChecked())
		self.configHandler.SetAnimationDelay(self.animationDelaySpinBox.value())
		if self.directionDownRadioButton.isChecked():
			direction = "Down"
		else:
			direction = "Up"
		self.configHandler.SetPopupDirection(direction)
		self.configHandler.SetLedsEnabled(self.enableLedsCheckBox.isChecked())
		self.configHandler.SetLedOnCommand(self.ledOnCommandInputField.text())
		self.configHandler.SetLedOffCommand(self.ledOffCommandInputField.text())
		
		# Save to file
		self.configHandler.SaveConfiguration()
		
		self.emit(PYSIGNAL("ConfigurationChanged()"),())

	