
#  _   _______                 _ _ _   _       _   _  __ _
# | | / /  __ \               (_) | \ | |     | | (_)/ _(_)
# | |/ /| |  \/_ __ ___   __ _ _| |  \| | ___ | |_ _| |_ _  ___ _ __
# |    \| | __| '_ ` _ \ / _` | | | . ` |/ _ \| __| |  _| |/ _ \ '__|
# | |\  \ |_\ \ | | | | | (_| | | | |\  | (_) | |_| | | | |  __/ |
# \_| \_/\____/_| |_| |_|\__,_|_|_\_| \_/\___/ \__|_|_| |_|\___|_|

############################################################################
#    Copyright (C) 2007 by Marcel Hasler                                   #
#    mahasler@gmail.com                                                    #
#                                                                          #
#    This program is free software; you can redistribute it and/or modify  #
#    it under the terms of the GNU General Public License version 2        #
#    as published by the Free Software Foundation.                         #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################

from kdecore import KSimpleConfig
import sys, os

LANGS_PATH = os.path.abspath(os.path.dirname(sys.argv[0])) + "/langsrc"
		
class i18n:
	def __init__(self):
		# Abuse KSimpleConfig for looking up translation strings rather than config options
		self.languageParser = KSimpleConfig(LANGS_PATH,False)
	
	def GetLanguageList(self):
		self.languages = self.languageParser.groupList()
		self.languageList = list()
		for i in range (len(self.languages)):
			self.languageList.append(self.languages[i])
			
		self.languageList.append("English")
		self.languageList.sort()
		
		return self.languageList
	
	def SetLanguage(self, language):
		self.languageParser.setGroup(language)
	
	def Translate(self, string):
		if self.languageParser.group() == "English":
			return string
		
		translation = self.languageParser.readEntry(string,"")
		
		if translation == "":
			print "Couldn't find translation for \"%s\"!" % string
			return string
		else:
			return unicode(translation)

		
