/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CONFIGURATIONHANDLER_H
#define CONFIGURATIONHANDLER_H

#include "wallet.h"
#include <kconfig.h>
#include <map>

class ConfigurationHandler
{
	friend ConfigurationHandler& Configuration();
public:
	QString readEntry(const QString &option) const;
	int readNumEntry(const QString &option) const;
	bool readBoolEntry(const QString &option) const;

	void writeEntry(const QString &option, QString value);
	void writeEntry(const QString &option, int value);
	void writeEntry(const QString &option, bool value);

	void writeToDisk();

private:
	ConfigurationHandler();
	~ConfigurationHandler();
	ConfigurationHandler(const ConfigurationHandler&);
	ConfigurationHandler& operator=(const ConfigurationHandler&);

	std::map<QString, QString> m_stringOptions;
	std::map<QString, int> m_numOptions;
	std::map<QString, bool> m_boolOptions;

	KConfig *m_config;
	Wallet *m_wallet;
};

// Global friend function
ConfigurationHandler& Configuration();

#endif
