/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ICON_PATHS_H
#define ICON_PATHS_H

//#define TESTING

#ifdef TESTING
#include <qdir.h>

// For systray / general
#define ICON_RED			QDir::currentDirPath() + "/../../pics/gmailRed.png"
#define ICON_BLUE			QDir::currentDirPath() + "/../../pics/gmailBlue.png"
#define ICON_ALERT			QDir::currentDirPath() + "/../../pics/gmailAlert.png"
#define ICON_SMALL			QDir::currentDirPath() + "/../../pics/gmailSmall.png"

// For systray menu
#define ICON_CHECK			QDir::currentDirPath() + "/../../pics/down.png"
#define ICON_INBOX			QDir::currentDirPath() + "/../../pics/internet.png"
#define ICON_CONFIGURE		QDir::currentDirPath() + "/../../pics/configure.png"
#define ICON_ABOUT			QDir::currentDirPath() + "/../../pics/info.png"
#define ICON_QUIT			QDir::currentDirPath() + "/../../pics/exit.png"

// For popup window
#define ICON_CLOSE			QDir::currentDirPath() + "/../../pics/close.png"
#define PIC_BACKGROUND		QDir::currentDirPath() + "/../../pics/gmailLabel.png"


#else
#include <kstandarddirs.h>

// For systray / general
#define ICON_RED			QString(locate("appdata", "pics/gmailRed.png") + "\0")
#define ICON_BLUE			QString(locate("appdata", "pics/gmailBlue.png") + "\0")
#define ICON_ALERT			QString(locate("appdata", "pics/gmailAlert.png") + "\0")
#define ICON_SMALL			QString(locate("appdata", "pics/gmailSmall.png") + "\0")

// For systray menu
#define ICON_CHECK			QString(locate("appdata", "pics/down.png") + "\0")
#define ICON_INBOX			QString(locate("appdata", "pics/internet.png") + "\0")
#define ICON_CONFIGURE		QString(locate("appdata", "pics/configure.png") + "\0")
#define ICON_ABOUT			QString(locate("appdata", "pics/info.png") + "\0")
#define ICON_QUIT			QString(locate("appdata", "pics/exit.png") + "\0")

// For popup window
#define ICON_CLOSE			QString(locate("appdata", "pics/close.png") + "\0")
#define PIC_BACKGROUND		QString(locate("appdata", "pics/gmailLabel.png") + "\0")


#endif // TESTING


#endif // ICON_PATHS_H
