/***************************************************************************
 *   Copyright (C) 2007 by Marcel Hasler                                   *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

// mysystemtray.h - Customized KSystemtray class with redefined mousePressEvent method

#ifndef MYSYSTEMTRAY_H
#define MYSYSTEMTRAY_H

#include <ksystemtray.h>
#include <qevent.h>
#include <qpopupmenu.h>


class MySystemTray : public KSystemTray
{
	Q_OBJECT
public:
	MySystemTray(QWidget *parent,const char *name);
	~MySystemTray();

	// Originaly inherited from QWidget and reimplemented by KSystemTray.
	// Once more reimplemented to simply send an signal on mouse click
	// instead of showing/hiding the parent window.
	void mousePressEvent(QMouseEvent *event);

	// Reimplemented to return a QPopupMenu (this->m_contextMenu) instead of
	// the KPopupMenu "menu" from KSystemTray.
	QPopupMenu *contextMenu() const;
	
private:
	QPopupMenu *m_contextMenu;

signals:
	// Emitted by mousePressEvent when left mouse button click has occured.
	void mouseButtonPressed();

};

#endif
