/***************************************************************************
 *   Copyright (C) 2007 by Marcel Hasler                                   *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef POPUPWINDOW_H
#define POPUPWINDOW_H

#include <qobject.h>
#include <qstring.h>
#include <qlabel.h>
#include <qtimer.h>
#include <qpushbutton.h>

#include <kurllabel.h>

class PopupWindow : public QWidget
{
	Q_OBJECT
public:
	PopupWindow();
	~PopupWindow();

	void popup();

	void setMessageCount(unsigned int count);
	void setSender(const QString &sender);
	void setSubject(const QString &title);
	void setConnectionFailed();

	void updateConfiguration();
	void updatePosition();

signals:
	void urlClicked();

private slots:
	void slotProcessURLClicked();
	void slotProcessAnimation();
	void slotOpen();
	void slotClose();
	void slotTimeout();

private:
	PopupWindow(const PopupWindow&);
	PopupWindow& operator=(const PopupWindow&);

	unsigned int m_xPos;
	unsigned int m_yPos;
	unsigned int m_hOffset;
	unsigned int m_vOffset;
	unsigned int m_width;
	unsigned int m_height;
	unsigned int m_currentHeight;
	unsigned int m_currentImagePos;
	bool m_lockOnPrimaryScreen;

	unsigned int m_closeTimeout;
	unsigned int m_animationDelay;
	QString m_popupDirection;

	QFont *m_font;
	QLabel *m_image;
	QPushButton *m_closeButton;
	KURLLabel *m_newMailLabel;
	QLabel *m_senderLabel;
	QLabel *m_subjectLabel;
	QLabel *m_connectionFailedLabel;

	QTimer *m_closeTimer;
	QTimer *m_animationTimer;

	bool m_isAnimated;
	bool m_isUp;
	bool m_isOpening;
};

#endif
