/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef KGMAILNOTIFIER_H
#define KGMAILNOTIFIER_H

#include "account.h"
#include "audioplayer.h"
#include "configurationdialog.h"
#include "ledhandler.h"
#include "popupwindow.h"
#include "trayicon.h"

#include <QTimer>

#include <KActionCollection>
#include <KUniqueApplication>

class KGmailNotifier : public KUniqueApplication
{
    Q_OBJECT
public:
    KGmailNotifier();
    ~KGmailNotifier();

private:
    KGmailNotifier(const KGmailNotifier&);
    KGmailNotifier& operator=(const KGmailNotifier&);

    TrayIcon *m_trayIcon;
    PopupWindow *m_popupWindow;
    KActionCollection *m_actionCollection;
    ConfigurationDialog *m_configurationDialog;
    Account *m_account;
    QTimer *m_checkMailTimer;
    AudioPlayer *m_audioPlayer;
    LEDHandler *m_ledHandler;
    bool m_silentNotification;

    QPixmap m_redIcon;
    QPixmap m_blueIcon;
    QPixmap m_alertIcon;

private slots:
    void slotSilentNotificationSelected();
    void slotProcessMailInfo();
    void slotProcessConnectionError(const QString errorType);
    void slotTogglePopupWindow();
    void slotCheckNewMail();
    void slotLaunchBrowser();
    void slotApplyConfiguration();
    void slotShowConfigWindow();
    void slotDeleteConfigWindow();
};

#endif // KGMAILNOTIFIER_H
