/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#ifndef CONFIGURATIONDIALOG_H
#define CONFIGURATIONDIALOG_H

#include "configgeneral.h"
#include "configappearance.h"
#include "confignotification.h"

#include <KConfigDialog>
#include <KConfigSkeleton>

class ConfigurationDialog : public KConfigDialog
{
    Q_OBJECT
public:
    ConfigurationDialog(KConfigSkeleton *config);
    ~ConfigurationDialog();

private:
    ConfigurationDialog(const ConfigurationDialog&);
    ConfigurationDialog& operator=(const ConfigurationDialog&);

    ConfigGeneral *m_configGeneralPage;
    ConfigAppearance *m_configAppearancePage;
    ConfigNotification *m_configNotificationPage;
};

#endif // CONFIGURATIONDIALOG_H
